# Overview

Preference handling and optimization are indispensable means for addressing
non-trivial applications in Answer Set Programming (ASP). However, their
implementation becomes difficult whenever they bring about a significant
increase in computational complexity. As a consequence, existing ASP systems do
not offer complex optimization capacities, supporting, for instance,
inclusion-based minimization or Pareto efficiency. Here we provide a collection
of encodings that implement such complex preferences and optimization criteria
by means of meta-programming.

# Archive Contents

- `metasp/`
  - Folder containing the metasp encodings.
- `benchmarks/`
  - Benchmark set used to evaluat performance of metasp.
- `benchmark-results.ods`
  - Benchmark results.
- `application/`
  - Large instances stemming from an application in systems biology.

# Usage

You will need grounder gringo and solver claspD. Both are available from the
[Potassco](https://potassco.org/) project page.

The example calls assume that you are using a bash (compatible) shell.
(Depending on your shell, you might need to adjust the calls.)

- The first example call shows how to apply the meta-encodings to search for
  cardinality-minimal answer sets. The construct `<(echo
  "optimize(1,1,card).")` inserts the fact `optimize(1,1,card).` directly via
  the command line, indicating that literals of priority level one and weight
  one are subject to cardinality minimization.

      gringo --reify examples/p0.lp | \
        gringo - encodings/{meta.lp,metaD.lp,metaO.lp} <(echo "optimize(1,1,card).") | \
        claspD 0

- The second example call shows how to look for answer sets inclusion-minimal
  on literals subject to minimization, instead of minimizing their cardinality.
  This time the fact `optimize(1,1,incl).` specifies that literals of priority
  level one and weight one are subject to subset minimization. 

      gringo --reify examples/p0.lp | \
        gringo - encodings/{meta.lp,metaD.lp,metaO.lp} <(echo "optimize(1,1,incl).") | \
        claspD 0

- The third example call shows how to apply the meta-encodings to search for
  Pareto-efficient answer sets. To this end, all literals subject to
  minimization are of a different weight in `p1.lp`, so that Pareto efficiency
  here matches inclusion-minimality.

      gringo --reify examples/p1.lp | \
        gringo - encodings/{meta.lp,metaD.lp,metaO.lp} | \
        claspD 0
