/***************************************************************************
                          algorithm.cpp  -  description
                             -------------------
    begin                : Tue Aug 5 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include "print.h"
#include "algorithm.h"
#include "cnode.h"
#include "crule.h"
#include "misc.h"
#include "print.h"
#include "io.h"

namespace NS_NOMORE {

void ClearStatus(TNodeSet *nodes) {
  TNodeSet::iterator ite;

  for(ite=nodes->begin();ite!=nodes->end();ite++) {
    ite->second->SwitchIsInPropagationQueue(false);
    ite->second->SwitchIsInBackwardPropagationQueue(false);
    ite->second->SwitchIsInMinusQueue(false);
  }
  
}

// Helper function
void CopyQueue(TQueue &to, TQueue &from) {

//  cout << "CopyQueue(TPQueue, TPQueue)" << endl;
  
  TQueue bkp;
  CNode *n;

  while(!from.empty()) {
    n = from.front();from.pop();

////    cout << "pop node " << n->GetId() << endl;

    to.push(n);
    bkp.push(n);
  }

  while(!bkp.empty()) {
    n = bkp.front();bkp.pop();
//    cout << "push node " << n->GetId() << endl;
    from.push(n);
  }
}

void CopyQueue(CTodoLists* to, TQueue &from, TQueueType typ) {

//  cout << "CopyQueue(CTodoLists, TPQueue)" << endl;

  TQueue bkp;
  CNode *n;

  while(!from.empty()) {
    n = from.front();from.pop();
//    cout << "pop node " << n->GetId() << endl;

    switch(typ) {
      case queuetype_backwardpropagation :
        to->PushBackProp(n);
        break;
      case queuetype_minus :
        to->PushMinus(n);
        break;
      case queuetype_possiblechoices :
        to->PushPossChoices(n);
        break;
      default:
        cerr << "ERROR: CopyQueue with queue type "<<typ<<endl;
        exit(1);
        break;
    }
    bkp.push(n);
  }

  while(!bkp.empty()) {
    n = bkp.front();bkp.pop();
//    cout << "push node " << n->GetId() << endl;
    from.push(n);
  }
}

/***************************************************************************
 * function ColorGraph                                                     *
 ***************************************************************************/
bool ColorGraph(CGraph* graph, CTodoLists *todo, string op, int as_count, string lookahead_op, bool lookahead, bool choice_operator) {

  CHECK_POINTER("ColorGraph(graph)", graph);
  CHECK_POINTER("ColorGraph(todo)" , todo);
                  
  CDetOperator* det_operator;
  CDetOperator* pre_operator;
  CNdOperator*  ndet_operator;
  CDetOperator* post_operator;
  CDetOperator* det_lookahead;
  CHeuristic*   heuristic;
  
  COperator::SetSimpleChoiceOperator(choice_operator);
  if(!GenerateOperator(op, lookahead_op, det_operator, pre_operator, ndet_operator, post_operator, heuristic, det_lookahead)) {
    std::cerr << "trying to generate operator failed" << std::endl;
    return false;
  }

  {
    CStack stack;
    pre_operator->Call(graph,&stack,todo);
  }

  TSetOfAtomSets as;
  if(ndet_operator->Call(det_operator, post_operator, heuristic, det_lookahead, graph, todo, as_count, lookahead, &as)) {
    std::cout << "Yes" << std::endl;
  } else {
    std::cout << "No" << std::endl;
  }

  delete pre_operator;
  delete ndet_operator;
  delete det_operator;
  delete post_operator;
  delete heuristic;
  delete det_lookahead;

  return true;
}

/***************************************************************************
 *                                                                         *
 * Main non-deterministic operator classes                                 *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
  class CNdOperator
****************************************************************************/
CNdOperator::CNdOperator() : COperator() {
  
  CREATEOBJECT("CNdOperator");
  
}

CNdOperator::~CNdOperator() {
  
  DELETEOBJECT("CNdOperator");
  
}

bool CNdOperator::RestoreGraph(CGraph* graph,
                               CStack* stack,
                               CTodoLists *todo,
                               bool restore_cps) {

  CHECK_POINTER("CNdOperator::RestoreGraph(graph)", graph);
  CHECK_POINTER("CNdOperator::RestoreGraph(stack)", stack);
  CHECK_POINTER("CNdOperator::RestoreGraph(todo)" , todo);
                                 
  while(!stack->empty()) {

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return
    // true
    if(top._ChoicePoint && top._ChoicePointColor != color_none) {
        return true;
    }

    // else restore node
    graph->LoadState(&top, stack, todo);

    // delete top stack element
    stack->pop();

  }

  return false;
}

void CNdOperator::WriteAnswerSet(int nr, CGraph* graph, TSetOfAtomSets* sets) {
  CHECK_POINTER("CNdOperator::WriteAnswerSet(graph)", graph);
  CHECK_POINTER("CNdOperator::WriteAnswerSet(sets)" , sets);

  TAtomSet* as = graph->GetAnswerSet();
  TAtomSet set;
  TAtomSet::iterator ite;
  int i = 1;

  #ifdef ASOUTPUT
  std::cout << "Answer Set " << nr << ":" << std::endl;
  #endif

  for(ite=as->begin();ite!=as->end();ite++) {
    set[ite->first] = ite->second;
    #ifdef ASOUTPUT
    std::cout << ite->second->GetName();
    std::cout << " ";
    #endif
    i++;
  }

  (*sets)[nr] = set;

  #ifdef ASOUTPUT
  std::cout << std::endl;
  #endif
  
}

bool CNdOperator::RecolorChoicePoint(CGraph* graph, CStack* stack, CTodoLists *todo) {
  CHECK_POINTER("CNdOperator::RecolorChoicePoint(graph)", graph);
  CHECK_POINTER("CNdOperator::RecolorChoicePoint(stack)", stack);
  CHECK_POINTER("CNdOperator::RecolorChoicePoint(todo)" , todo);
  
  if(stack->empty())
    return false;

  TStackElement top = stack->top();
  if(top._ChoicePoint && top._ChoicePointColor != color_none) {
    graph->LoadState(&top, stack, todo);
    stack->pop();
    
//    cout << "Recolor CP: " <<*(CBodyNode*)top._pNode<<endl;

    if(graph->ColorNode(top._pNode, top._ChoicePointColor, stack, true, color_none, todo)) {
      todo->PushBackProp(top._pNode);
      return true;
    }
  }

  return false;
}

bool CNdOperator::Call(CDetOperator* det_op, CDetOperator* post_op, CHeuristic *heu,
      CDetOperator* lookahead_op, CGraph* graph, CTodoLists *todo, int as_count, 
      bool lookahead, TSetOfAtomSets* sets) {

  CHECK_POINTER("CNdOperator::Call(det_op)",       det_op);
  CHECK_POINTER("CNdOperator::Call(post_op)",      post_op);
  CHECK_POINTER("CNdOperator::Call(heu)",          heu);
  CHECK_POINTER("CNdOperator::Call(lookahead_op)", lookahead_op);
  CHECK_POINTER("CNdOperator::Call(graph)",        graph);
  CHECK_POINTER("CNdOperator::Call(todo)",         todo);
  CHECK_POINTER("CNdOperator::Call(sets)",         sets);

  CStack stack;
  int as_found = 0;
  while(true) {
    // if an error occured while calling the deterministic operators
    if(det_op->Call(graph, &stack, todo) == return_colorerror) {
      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack, todo))
        break; // nothing left to backtrack
      RecolorChoicePoint(graph, &stack, todo);
    } else
    // total coloring?
    if(graph->TotalColoring()) {
      as_found++;
      WriteAnswerSet(as_found, graph, sets);

      // all answer sets are found
      if(as_found == as_count)
        return true;

      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack, todo))
        break; // nothing left to backtrack
      RecolorChoicePoint(graph, &stack, todo);
    } else {
      // else use non-deterministic operator to color graph
      CNode* node = NULL;

      // do not use look ahead
      node = ChooseNode(graph, todo);
        
      // call end operator if node is NULL
      if(node == NULL) {      
        if(post_op->Call(graph, &stack, todo) != return_changed) {
          PRINT_ERROR(cout << "Error in closure operator" << endl);
          exit(1);
        }
      } else {
        INC_COUNT(choice_points);
        
//7        cout << "Choice: " << *(CBodyNode*)node << endl;
        
        // color choice node with plus
        if(!graph->ColorNode(node, color_plus, &stack, true, color_minus, todo)) {  
          // just colored a choice point and its successors
          if(!RestoreGraph(graph, &stack, todo))
            break; // nothing left to backtrack
          RecolorChoicePoint(graph, &stack, todo);
        } else {
          // put into queue for backward propagation
          todo->PushBackProp(node);
        }
      }
    }
  }

  return false;
}
/*
bool CNdOperator::Call(CDetOperator* det_op, CDetOperator* post_op, CHeuristic *heu,
      CDetOperator* lookahead_op, CGraph* graph, CTodoLists *todo, int as_count, 
      bool lookahead, TSetOfAtomSets* sets) {

  CHECK_POINTER("CNdOperator::Call(det_op)",       det_op);
  CHECK_POINTER("CNdOperator::Call(post_op)",      post_op);
  CHECK_POINTER("CNdOperator::Call(heu)",          heu);
  CHECK_POINTER("CNdOperator::Call(lookahead_op)", lookahead_op);
  CHECK_POINTER("CNdOperator::Call(graph)",        graph);
  CHECK_POINTER("CNdOperator::Call(todo)",         todo);
  CHECK_POINTER("CNdOperator::Call(sets)",         sets);

  CStack stack;
  int as_found = 0;
  while(true) {
    // if an error occured while calling the deterministic operators
    if(det_op->Call(graph, &stack, todo) == return_colorerror) {
      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack, todo))
        break; // nothing left to backtrack
      RecolorChoicePoint(graph, &stack, todo);
    } else
    // total coloring?
    if(graph->TotalColoring()) {
      as_found++;
      WriteAnswerSet(as_found, graph, sets);

      // all answer sets are found
      if(as_found == as_count)
        return true;

      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack, todo))
        break; // nothing left to backtrack
      RecolorChoicePoint(graph, &stack, todo);
    } else {
      // else use non-deterministic operator to color graph
      CNode* node = NULL;

      if(!lookahead) {

        // do not use look ahead
        node = ChooseNode(graph, todo);
        
//        cout << "CP : " << node->GetId()<<endl;

      } else {

        // use lookahead
        if(!Lookahead(graph, &stack, lookahead_op, det_op, heu,
                      &node, todo)) {

          // backtrack: restore graph to saved state
          if(!RestoreGraph(graph, &stack, todo))
            break; // nothing left to backtrack

      		RecolorChoicePoint(graph, &stack, todo);

          continue;

        }

      }

      // call end operator if node is NULL
      if(node == NULL) {



        if((!lookahead || !graph->TotalColoring()) &&
           (post_op->Call(graph, &stack, todo) != return_changed)) {

            PRINT_ERROR(cout << "Error in closure operator" << endl);
            exit(1);

          }

      } else {

        INC_COUNT(choice_points);
        
//        cout << "Choice: " << *(CBodyNode*)node << endl;

        // color choice node with plus
        if(!graph->ColorNode(node,
                             color_plus,
                             &stack,
                             true,
                             color_minus,
                             todo)) {  // color cp to plus

          // just colored a choice point and its successors
          RestoreGraph(graph, &stack, todo);
       		RecolorChoicePoint(graph, &stack, todo);

  	    } else {

          // put into queue for backward propagation
          todo->PushBackProp(node);
                  }

      }

    }

  }

  return false;

}

*/
bool CNdOperator::Lookahead(CGraph* graph,
                            CStack* stack,
                            CDetOperator* la_op,
                            CDetOperator* op,
                            CHeuristic* heu,
                            CNode** node,
                            CTodoLists *todo) {

  CHECK_POINTER("CNdOperator::Lookahead(graph)", graph);
  CHECK_POINTER("CNdOperator::Lookahead(stack)", stack);
  CHECK_POINTER("CNdOperator::Lookahead(la_op)", la_op);
  CHECK_POINTER("CNdOperator::Lookahead(op)"   , op);
  CHECK_POINTER("CNdOperator::Lookahead(heu)"  , heu);
  CHECK_POINTER("CNdOperator::Lookahead(node)" , node);
  CHECK_POINTER("CNdOperator::Lookahead(todo)" , todo);

  // saving CPs. important for using V2 operator
  TQueue pCPs;
//  cout << "la 1" << endl;
  CopyQueue(pCPs, *todo->GetPossChoicesQueue());

  // stack for temporal coloring
  CStack la_stack;

  // priorized queue for sorting the possible choice points
  CPQueueLookahead la_queue;

  // list of tested nodes
  TBoolSet tested_nodes;

  // set not to null
  *node = NULL;

/*  todo->ClearProp();
  todo->ClearMinus();
  todo->ClearBackProp();*/

  if(!todo->EmptyProp()) cout << "No empty prop queue check 1" << endl;
  if(!todo->EmptyBackProp()) cout << "No empty backprop queue check 1" << endl;
  if(!todo->EmptyMinus()) cout << "No empty minus queue check 1" << endl;

//  cout << "Lookahead" << endl;

  static int __counter2__ = 0;

  while(!todo->EmptyPossChoices()) {

    // get head of CP queue
    CNode *node = todo->PopPossChoices();

    // if node is not uncolored or a head node try the next node
    if(!((CBodyNode*)node)->Supported()                       ||
           // is not supported
       tested_nodes.find(node->GetId()) != tested_nodes.end() ||
           // is already tested
       node->GetColor() != color_none                         ||
           // is not uncolored
       node->GetType() != type_cbodynode)
           // type of node is head node
      continue;

    __counter2__ ++;  
//    cout << "Teste Knoten " << __counter2__ << " in old LA" << endl;
    
    // create lookahead information object
    CLookaheadInformation *info = new CLookaheadInformation(node);

    // set to already tested
    tested_nodes[node->GetId()] = true;

    // create todo queues for lookahead-plus-test
    CTodoLists todo_plus;

//    cout << "LA+test" << endl;
    // test lookahead-plus
//    cout << "do la:prop" << endl;
    todo_plus.PushBackProp(node);
    graph->ColorNode(node, color_plus, &la_stack, false, color_none,
                         &todo_plus, info->GetPlusStatus());
    if(return_colorerror == la_op->Call(graph, &la_stack, &todo_plus,
                                        info->GetPlusStatus())) {

      // ERROR: color node to minus
      RestoreGraph(graph, &la_stack, &todo_plus, false);
      todo_plus.ClearPossChoices();
      todo_plus.ClearProp();
      todo_plus.ClearBackProp();
      todo_plus.ClearMinus();

//      cout << "LA+test end" << endl;

      delete info;

//      cout << "la 2" << endl;
      todo->PushBackProp(node);
      graph->ColorNode(node, color_minus, stack, false, color_none, todo);
      if(return_colorerror == op->Call(graph, stack, todo)) {

        // ERROR: return false

        CopyQueue(todo, pCPs, queuetype_possiblechoices);
        return false;

      }

//      cout << "la 3" << endl;
      // save new CPs into pCPs
      CopyQueue(pCPs, *todo->GetPossChoicesQueue());

      // try next node
      continue;

    }

    if(!todo->EmptyProp()) cout << "No empty prop queue check 2" << endl;
    if(!todo->EmptyBackProp()) cout << "No empty backprop queue check 2" << endl;
    if(!todo->EmptyMinus()) cout << "No empty minus queue check 2" << endl;

//    cout << "do la:restore1" << endl;
    // restore graph
    todo_plus.ClearPossChoices();
    RestoreGraph(graph, &la_stack, &todo_plus, false);
//    cout << "LA+test end" << endl;

    // create todo queues for lookahead-minus-test
    CTodoLists todo_minus;

//    cout << "LA-test" << endl;
    // test lookahead-minus
    todo_minus.PushBackProp(node);
    graph->ColorNode(node, color_minus, &la_stack, false, color_none,
                         &todo_minus, info->GetPlusStatus());
    if(return_colorerror == la_op->Call(graph, &la_stack, &todo_minus,
                                        info->GetMinusStatus())) {

      todo_minus.ClearProp();
      todo_minus.ClearPossChoices();
      todo_minus.ClearBackProp();
      todo_minus.ClearMinus();
      // ERROR: color node to minus
      RestoreGraph(graph, &la_stack, &todo_minus, false);
//      cout << "LA-test end" << endl;

      delete info;

//      cout << "la 4" << endl;
      todo->PushBackProp(node);
      graph->ColorNode(node, color_plus, stack, false, color_none, todo);
      if(return_colorerror == op->Call(graph, stack, todo)) {

        // ERROR: return false
        CopyQueue(todo, pCPs, queuetype_possiblechoices);

        return false;

      }

      // save new CPs into pCPs
//      cout << "la 5" << endl;
      CopyQueue(pCPs, *todo->GetPossChoicesQueue());

      // try next node
      continue;

    }

    if(!todo->EmptyProp()) cout << "No empty prop queue check 3" << endl;
    if(!todo->EmptyBackProp()) cout << "No empty backprop queue check 3" << endl;
    if(!todo->EmptyMinus()) cout << "No empty minus queue check 3" << endl;

//    cout << "do la:restore2" << endl;
    // restore graph
    todo_minus.ClearPossChoices();
    RestoreGraph(graph, &la_stack, &todo_minus, false);
//    cout << "LA-test end" << endl;

    info->SetHeuristic(heu->Lookahead(info));
    la_queue.push(info);

  }

//  cout << "do la:bestnode" << endl;

  bool cp_found = false;
  while(!la_queue.empty()) {

    CLookaheadInformation* info = la_queue.top();
    la_queue.pop();

    // if no choice point is set and this node is uncolored
    if(!cp_found && info->GetNode()->GetColor() == color_none) {

      // set choice point
      *node = info->GetNode();
      cp_found = true;

    }

    delete info;

  }

  // set the cp queue
//  cout << "la 6" << endl;
  CopyQueue(todo, pCPs, queuetype_possiblechoices);

  return true;

}

/*

function lookahead()
pCPs := PossChoices
while PossChoices not empty do
  node := PossChoices.pop
  
  if node is supported and not tested and uncolored and bodynode then

    BackProp.push(node)
    color(node -> +)
    if la_op() causes error then
      restore 

      PossChoices += pCPs
      BackProp.push(node)
      color(node -> -)
      if op() causes error then
        return false
      endif

      pCPs += PossChoices
      continue
    endif

    restore

    BackProp.push(node);
    color(node -> -)
    if la_op() causes error then
      restore

      PossChoices += pCPs
      BackProp.push(node);
      color(node -> +)
      if op() causes error then
        return false
      endif

      pCPs += PossChoices
      continue;
    endif

    restore
    la_queue.push(info);

  endif
endwhile

while la_queue not empty do
  node := la_queue.pop

  if choicepoint not yet found and node is uncolored then
      best := node
  endif
endwhile

PossChoices += pCPs
return true

*/

/***************************************************************************
 *                                                                         *
 * non-deterministic operators                                             *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
  class COperatorC
****************************************************************************/
COperatorC::COperatorC() : CNdOperator() {
  
  CREATEOBJECT("COperatorC");
  
}

COperatorC::~COperatorC() {
  
	DELETEOBJECT("COperatorC");
  
}

CNode* COperatorC::ChooseNode(CGraph* graph, CTodoLists *todo) {
  CHECK_POINTER("COperatorC::ChooseNode(graph)", graph);
  CHECK_POINTER("COperatorC::ChooseNode(todo)" , todo);
  INC_COUNT(methode_operator_c_call);

  TBodyNodeVectorIterator ite;
  TBodyNodeVector* nodes = graph->GetBodyNodes();

  for(ite = nodes->begin();ite != nodes->end();ite++) {
    CNode *node = *ite;
    if(node->GetColor() == color_none) {
      return node;
    }
  }

  return NULL;
}

/***************************************************************************
  class COperatorD
****************************************************************************/
COperatorD::COperatorD() : CNdOperator() {
  
	CREATEOBJECT("COperatorD");
  
}

COperatorD::~COperatorD() {
  
	DELETEOBJECT("COperatorD");
  
}

CNode* COperatorD::ChooseNode(CGraph* graph, CTodoLists *todo) {
  CHECK_POINTER("COperatorD::ChooseNode(graph)", graph);
  CHECK_POINTER("COperatorD::ChooseNode(todo)" , todo);
  INC_COUNT(methode_operator_d_call);

  TBodyNodeVectorIterator ite;
  TBodyNodeVector* nodes = graph->GetBodyNodes();

  for(ite = nodes->begin();ite != nodes->end();ite++) {
    CBodyNode* node = *ite;
    if(node->GetColor() == color_none && node->Supported()) {      
      return node;
    }
  }

  return NULL;
}

/***************************************************************************
  class COperatorDQ
****************************************************************************/
COperatorDQ::COperatorDQ() : CNdOperator() {
  
	CREATEOBJECT("COperatorDQ");
  
}

COperatorDQ::~COperatorDQ() {
  
	DELETEOBJECT("COperatorDQ");
  
}

CNode* COperatorDQ::ChooseNode(CGraph* graph, CTodoLists* todo) {
  
	CHECK_POINTER("COperatorDQ::ChooseNode(graph)", graph);
	CHECK_POINTER("COperatorDQ::ChooseNode(todo)" , todo);

  INC_COUNT(methode_operator_dq_call);

  CNode *node = todo->PopPossChoices();
  while(node != NULL) {

    if(node->GetType() == type_cbodynode &&
       node->GetColor() == color_none &&
       ((CBodyNode*)node)->Supported()) {

      break;

    }

    node = todo->PopPossChoices();

  }

  if(node != NULL) {

    return node;

  }

  return NULL;

}

bool COperatorDQ::RestoreGraph(CGraph* graph,
                               CStack* stack,
                               CTodoLists *todo,
                               bool restore_cps) {

	CHECK_POINTER("COperatorDQ::RestoreGraph(graph)", graph);
	CHECK_POINTER("COperatorDQ::RestoreGraph(stack)", stack);
	CHECK_POINTER("COperatorDQ::RestoreGraph(todo)" , todo);

//  CNonPriorityQueue queue;
//  cout << *todo << endl;
  while(true) {

    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return
    // true
    if(top._ChoicePoint && top._ChoicePointColor != color_none) {

        return true;

    }

    // else restore node
    graph->LoadState(&top, stack, todo);

    if(restore_cps) {
      if(top._pNode->GetType() == type_cbodynode) {
        todo->PushPossChoices(top._pNode);
        INC_COUNT(queue_cp_call);
      }
      todo->PushCPossChoices(top._pNode);
    }

    // put all body nodes into queue
/*    if(top._pNode->GetType() == type_cbodynode) {

      queue.Insert(top._pNode);

    }*/

    // delete top stack element
    stack->pop();

  }

  // put all supported body nodes into cp queue
/*  while(!queue.Empty()) {

    CBodyNode *bnode = (CBodyNode*)queue.GetHead();

    if(bnode->Supported()) {

      todo->PushPossChoices(bnode);
      INC_COUNT(queue_cp_call);

    }

  } */

  return true;
}

/***************************************************************************
  class COperatorCQ
****************************************************************************/
COperatorCQ::COperatorCQ() : CNdOperator() {

	CREATEOBJECT("COperatorCQ");

}

COperatorCQ::~COperatorCQ() {

	DELETEOBJECT("COperatorCQ");

}

CNode* COperatorCQ::ChooseNode(CGraph* graph, CTodoLists *todo) {

	CHECK_POINTER("COperatorCQ::ChooseNode(graph)", graph);
	CHECK_POINTER("COperatorCQ::ChooseNode(todo)" , todo);

  INC_COUNT(methode_operator_cq_call);

  CNode *node = todo->PopCPossChoices();

  CNode *firstnode = node;
  bool start = true;

  if(node == NULL)
    return NULL;
    
  while((firstnode != node || start) && (node == NULL || node->GetType() != type_cbodynode || node->GetColor() != color_none)) {
    start = false;

    // put old into queue and take next node
    todo->PushCPossChoices(node);
    node = todo->PopCPossChoices();
  }

  if(node != NULL)
    return node;

  return NULL;
}

bool COperatorCQ::RestoreGraph(CGraph* graph, CStack* stack, CTodoLists *todo, bool restore_cps) {

	CHECK_POINTER("COperatorCQ::RestoreGraph(graph)", graph);
	CHECK_POINTER("COperatorCQ::RestoreGraph(stack)", stack);
	CHECK_POINTER("COperatorCQ::RestoreGraph(todo)" , todo);

//  CNonPriorityQueue queue;

  while(true) {

    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return
    // true
    if(top._ChoicePoint && top._ChoicePointColor != color_none)
      return true;

    // else restore node
    graph->LoadState(&top, stack, todo);

    if(restore_cps) {
        todo->PushPossChoices(top._pNode);
        todo->PushCPossChoices(top._pNode);
        INC_COUNT(queue_cp_call);
    }

    // delete top stack element
    stack->pop();

  }

  return true;

}

/***************************************************************************
  class COperatorDH
****************************************************************************/
COperatorDH::COperatorDH() : COperatorDQ() {
  CREATEOBJECT("COperatorDH");
}

COperatorDH::~COperatorDH() {
  DELETEOBJECT("COperatorDH");
}

CNode* COperatorDH::ChooseNode(CGraph* graph, CTodoLists *todo) {

  CHECK_POINTER("COperatorDH::ChooseNode(graph)", graph);
  CHECK_POINTER("COperatorDH::ChooseNode(todo)" , todo);

  INC_COUNT(methode_operator_dh_call);

  CNode *bestnode = NULL;
  CNode *next = NULL;

//  cout << *todo << endl;
  
  int len = todo->GetPossChoicesQueue()->size();
  for(int i=0;i<len;i++) {
    next = todo->PopPossChoices();

    if(next != NULL && next->GetType() == type_cbodynode &&
       next->GetColor() == color_none && ((CBodyNode*)next)->Supported()) {
       
//      cout << "Node = " << next->GetId() << " ["<<next->GetMaxHeuristics()<<"/"<<next->GetMinHeuristics()<<"]" << endl;

      if(bestnode == NULL) {
        bestnode = next;
      } else
      if(next->GetMaxHeuristics() > bestnode->GetMaxHeuristics() ||
         (next->GetMaxHeuristics() == bestnode->GetMaxHeuristics() &&
          next->GetMinHeuristics() > bestnode->GetMinHeuristics())) {

        // put old into queue and take next node
        todo->PushPossChoices(bestnode);
        bestnode = next;
      } else
        todo->PushPossChoices(next);
    }
  }

  return bestnode;
}

} // end of namespace
