/***************************************************************************
                          cheuristic.cpp  -  description
                             -------------------
    begin                : Thu Oct 16 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cheuristic.h"
#include "cnode.h"
#include "crule.h"
#include "cstatusinformation.h"

namespace NS_NOMORE {

/***************************************************************************
  class CHeuristic
****************************************************************************/
CHeuristic::CHeuristic() : _pnode(NULL) {
  
  CREATEOBJECT("CHeuristic")
  
}

CHeuristic::~CHeuristic() {
  
  DELETEOBJECT("CHeuristic")
  
}

bool CHeuristic::LookaheadTest(CLookaheadInformation *l_old,
                               CLookaheadInformation *l_new) {
  
  CHECK_POINTER("CHeuristic::LookaheadTest(l_new)", l_new);

  if(l_old == NULL)
    return true;

  int oplus = l_old->GetPlusStatus()->GetHardColored();
  int nplus = l_new->GetPlusStatus()->GetHardColored();

  int ominus = l_old->GetMinusStatus()->GetHardColored();
  int nminus = l_new->GetMinusStatus()->GetHardColored();

  // get max and min
  int omin = oplus;
  int omax = ominus;
  if(oplus > ominus) {
    omax = oplus;
    omin = ominus;
  }

  int nmin = nplus;
  int nmax = nminus;
  if(nplus > nminus) {
    nmax = nplus;
    nmin = nminus;
  }
  
  if(omin < nmin)
    return true;

  if(omin == nmin && omax < nmax)
    return true;

/*  if(l_old->GetPlusStatus()->GetHardColored() <
     l_new->GetPlusStatus()->GetHardColored())
    return true;

  if(l_old->GetPlusStatus()->GetHardColored() ==
     l_new->GetPlusStatus()->GetHardColored() &&
     l_old->GetMinusStatus()->GetHardColored() <
     l_new->GetMinusStatus()->GetHardColored())
    return true;
  */
  return false;
  
}

int CHeuristic::Lookahead(CLookaheadInformation *info) {

  CHECK_POINTER("CHeuristic::Lookahead(info)", info);

  return 1000 * info->GetPlusStatus()->GetHardColored() +
         info->GetMinusStatus()->GetHardColored();
         
}

/***************************************************************************
  class CStaticHeuristic
****************************************************************************/
CStaticHeuristic::CStaticHeuristic() : CHeuristic(), _value(0) {
  
  CREATEOBJECT("CStaticHeuristic")
  
}


CStaticHeuristic::~CStaticHeuristic() {
  
  DELETEOBJECT("CStaticHeuristic")
  
}

/***************************************************************************
  class CDynamicHeuristic
****************************************************************************/

CDynamicHeuristic::CDynamicHeuristic() : CHeuristic() {
  
  CREATEOBJECT("CDynamicHeuristic")
  
}


CDynamicHeuristic::~CDynamicHeuristic() {
  
  DELETEOBJECT("CDynamicHeuristic")
  
}

/***************************************************************************
  class CHeuristicNone
****************************************************************************/
CHeuristicNone::CHeuristicNone() : CStaticHeuristic() {
  
  CREATEOBJECT("CHeuristicNone")
  
}

CHeuristicNone::~CHeuristicNone() {
  
  DELETEOBJECT("CHeuristicNone")
  
}

CHeuristic* CHeuristicNone::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicNone::GenerateInstance(node)", node);
  
  CHeuristicNone *heu = new CHeuristicNone();

  return (CHeuristic*)heu;
  
}

/***************************************************************************
  class CHeuristicS1
****************************************************************************/
CHeuristicS1::CHeuristicS1() : CStaticHeuristic() {
  
  CREATEOBJECT("CHeuristicS1")
  
}

CHeuristicS1::~CHeuristicS1() {
  
  DELETEOBJECT("CHeuristicS1")
  
}

CHeuristic* CHeuristicS1::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicS1::GenerateInstance(node)", node);
  
  CHeuristicS1 *heu = new CHeuristicS1();

  heu->SetNode(node);

  return (CHeuristic*)heu;
  
}

int CHeuristicS1::CalculateHeuristicValue() {
  INC_COUNT(heuristics_s1_call);

  int value = 0;
  // 256*1_succs+1_preds only if bodynode
  if(_pnode->GetType() == type_cbodynode) {
    CBodyNode *bnode = (CBodyNode*)_pnode;
    THeadNodeSetIterator ite = bnode->GetSuccessors().begin();
    THeadNodeSetIterator end = bnode->GetSuccessors().end();
    for (; ite!=end; ite++) {
      value += (*ite)->GetOneSuccessors().size()*256;
    }
    value += bnode->GetOnePredecessors().size();
  }
  return value;
}

/***************************************************************************
  class CHeuristicS2
****************************************************************************/
CHeuristicS2::CHeuristicS2() : CStaticHeuristic() {
  
  CREATEOBJECT("CHeuristicS2")
  
}

CHeuristicS2::~CHeuristicS2() {
  
  DELETEOBJECT("CHeuristicS2")
  
}

CHeuristic* CHeuristicS2::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicS2::GenerateInstance(node)", node);

  CHeuristicS2 *heu = new CHeuristicS2();

  heu->SetNode(node);

  return (CHeuristic*)heu;
  
}

int CHeuristicS2::CalculateHeuristicValue() {
  INC_COUNT(heuristics_s2_call);

  int value = 0;
  // 256*1_succs+1_preds only if bodynode
  if(_pnode->GetType() == type_cbodynode) {
    CBodyNode *bnode = (CBodyNode*)_pnode;
    THeadNodeSetIterator ite = bnode->GetSuccessors().begin();
    THeadNodeSetIterator end = bnode->GetSuccessors().end();
    for(; ite!=end; ite++) {
      value += (*ite)->GetZeroSuccessors().size();
      value += (*ite)->GetOneSuccessors().size();      
    }
  }
  return value;
}

/***************************************************************************
  class CHeuristicSR
****************************************************************************/
CHeuristicSR::CHeuristicSR() : CStaticHeuristic() {
  
  CREATEOBJECT("CHeuristicSR")
  
}

CHeuristicSR::~CHeuristicSR() {
  
  DELETEOBJECT("CHeuristicSR")
  
}

CHeuristic* CHeuristicSR::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicSR::GenerateInstance(node)", node);
  
  CHeuristicSR *heu = new CHeuristicSR();

  heu->SetNode(node);

  return (CHeuristic*)heu;
  
}

/***************************************************************************
  class CHeuristicD1
****************************************************************************/
CHeuristicD1::CHeuristicD1() : CDynamicHeuristic() {
  
  CREATEOBJECT("CHeuristicD1")
  
}

CHeuristicD1::~CHeuristicD1() {
  
  DELETEOBJECT("CHeuristicD1")
  
}

CHeuristic* CHeuristicD1::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicD1::GenerateInstance(node)", node);
  
  CHeuristicD1 *heu = new CHeuristicD1();

  heu->SetNode(node);

  return (CHeuristic*)heu;
  
}

int CHeuristicD1::CalculateHeuristicValue() {
  INC_COUNT(heuristics_d1_call);

  int heu = 0;
  // 256*1_succs+1_preds only if bodynode
  if(_pnode->GetType() == type_cbodynode) {
    CBodyNode *bnode = (CBodyNode*)_pnode;
    THeadNodeSetIterator ite = bnode->GetSuccessors().begin();
    THeadNodeSetIterator end = bnode->GetSuccessors().end();
    for (; ite!=end; ite++) {
      CHeadNode* hnode = *ite;
      TBodyNodeSetIterator ite2 = hnode->GetOneSuccessors().begin();
      TBodyNodeSetIterator end2 = hnode->GetOneSuccessors().end();
      for (; ite2!=end2; ite2++) {
        if((*ite2)->GetColor() == color_none)
          heu += 256;
      }
    }
    
    ite = bnode->GetOnePredecessors().begin();
    end = bnode->GetOnePredecessors().end();
    for(; ite!=end; ite++) {
      if((*ite)->GetColor() == color_none)
        heu ++;
    }
  }
  return heu;
}

/***************************************************************************
  class CHeuristicDR
****************************************************************************/
CHeuristicDR::CHeuristicDR() : CDynamicHeuristic() {
  
  CREATEOBJECT("CHeuristicDR")
  
}

CHeuristicDR::~CHeuristicDR() {
  
  DELETEOBJECT("CHeuristicDR")
  
}

CHeuristic* CHeuristicDR::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicDR::GenerateInstance(node)", node);

  CHeuristicDR *heu = new CHeuristicDR();

  return (CHeuristic*)heu;
  
}

/***************************************************************************
  class CHeuristicAlphabetical
****************************************************************************/
CHeuristicAlphabetical::CHeuristicAlphabetical() : CDynamicHeuristic() {
  
  CREATEOBJECT("CHeuristicAlphabetical")
  
}

CHeuristicAlphabetical::~CHeuristicAlphabetical() {
  
  DELETEOBJECT("CHeuristicAlphabetical")
  
}

CHeuristic* CHeuristicAlphabetical::GenerateInstance(CNode* node) {

  CHECK_POINTER("CHeuristicAlphabetical::GenerateInstance(node)", node);
  
  CHeuristicAlphabetical *heu = new CHeuristicAlphabetical();

  // set node
  heu->SetNode(node);

  return (CHeuristic*)heu;
  
}

void CHeuristicAlphabetical::SetNode(CNode* n) {

  CHECK_POINTER("CHeuristicAlphabetical::SetNode(n)", n);
  
  CHeuristic::SetNode(n);  

  if(n->GetType() == type_cbodynode) {

    // sort atoms in body
/*    CLessAtom cla;
    ((CBodyNode*)n)->GetBody()->GetPosAtoms()->sort(cla);
    ((CBodyNode*)n)->GetBody()->GetNegAtoms()->sort(cla);
*/    
  }
  
}

bool CHeuristicAlphabetical::operator<(CHeuristic &heu) {

  INC_COUNT(heuristics_alpha_call);

  // wrong type of heuristic
  if(heu.GetType() != type_cheuristic_alpha)
    return false;

  CNode *node1 = GetNode();
  if(node1->GetType() != type_cbodynode)
    return false;
    
  CNode *node2 = heu.GetNode();
  if(node2->GetType() != type_cbodynode)
    return false;

  CBodyNode *bnode1 = (CBodyNode*)node1;
  if(bnode1->GetBody() == NULL)
    return false;
    
  CBodyNode *bnode2 = (CBodyNode*)node2;  
  if(bnode2->GetBody() == NULL)
    return false;

  return *bnode2->GetBody() < *bnode1->GetBody();
  
}

} // end of Namespace
