/***************************************************************************
                          crule.cpp  -  description
                             -------------------
    begin                : Thu Jul 10 2003
    copyright            : (C) 2003 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <algorithm>
#include "crule.h"
#include "print.h"

namespace NS_NOMORE {

/***************************************************************************
  class CAtom
****************************************************************************/
CAtom::CAtom(const TId id, const string name)
        : _name(name), _id(id), _color(color_none) {
  
  CREATEOBJECT("CAtom");
  
}

CAtom::CAtom(CIdGenerator *ig, const string name)
        : _name(name), _color(color_none) {

  CHECK_POINTER("CAtom::CAtom(ig)", ig);

  _id = ig->GetId();

  CREATEOBJECT("CAtom");
  
}

CAtom::~CAtom() {

  DELETEOBJECT("CAtom");
  
}

/***************************************************************************
  class CBody
****************************************************************************/
CBody::CBody(const TId id, CProgram* prg) : _id(id), _pprogram(prg) {
  CREATEOBJECT("CBody");
}

CBody::CBody(CIdGenerator *ig, CProgram* prg) : _pprogram(prg) {
  CHECK_POINTER("CBody::CBody(ig)", ig);
  _id = ig->GetId();
  CREATEOBJECT("CBody");
}

CBody::~CBody() {
  DELETEOBJECT("CBody");
}

bool CBody::Supported(const TIdSet &atoms) {
  if(_positives.size() > atoms.size())
    return false;
  
  TIdSetIterator ite = _positives.begin();
  TIdSetIterator end = _positives.end();
  TIdSetIterator atoms_ite = atoms.begin();
  TIdSetIterator atoms_end = atoms.end();
  
  while(ite != end && atoms_ite != atoms_end) {
    if(*ite == *atoms_ite) {
      ite++;
      atoms_ite++;
    } else 
    if(*atoms_ite < *ite) {
      atoms_ite = atoms.lower_bound(*ite);
    } else {
      return false;
    }
  }
  return ite == end;
}

/***************************************************************************
  classCRule
****************************************************************************/
CRule::CRule(const TId id) : _id(id) {
  CREATEOBJECT("CRule");
  
  _phead = NULL;
  _pbody = NULL;
}

CRule::CRule(CIdGenerator *ig) {
  CHECK_POINTER("CRule::CRule(ig)", ig);
  
  _id = ig->GetId();

  _phead = NULL;
  _pbody = NULL;

  CREATEOBJECT("CRule");
}

CRule::~CRule() {
  DELETEOBJECT("CRule");
}

} // end of namespace NS_NOMORE
