/***************************************************************************
                          cset.h  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CSET_H
#define CSET_H

/*! \file cset.h
 *  Contains the definition of CSet.
 */

/***************************************************************************
 *                                                                         *
 * Includes                                                                *
 *                                                                         *
 ***************************************************************************/
#include <map>
#include <list>
#include "print.h"

/***************************************************************************
 *                                                                         *
 * Namespace NS_NOMORE                                                     *
 *                                                                         *
 ***************************************************************************/
namespace NS_NOMORE {

using namespace std;

/***************************************************************************
 *                                                                         *
 * class CSet                                                              *
 *                                                                         *
 ***************************************************************************/
/*! \class CSet
 *  \brief Defines a map with equality- and inequaltity-operator.
 *  \author Andre Neumann, Christian Anger
 *  \date Mon Jul 28 2003
 *  \attention Important is that the data-class is a pointer, else the
 *             equality-operator doesn't work.
 */
template<typename Key,
         typename Data,
         typename Compare = std::less<Key>,
         typename Alloc = std::allocator<std::pair<const Key, Data> > >
class CSet : public std::map<Key, Data> {

public:
  //! Key type for map.
  typedef Key key_type;

  //! Mapping type for data.
  typedef Data mapped_type;

  //! Value type (key and data).
  typedef std::pair<const Key, Data> value_type;

  //! Compareable key.
  typedef Compare key_compare;

  //! STL important.
  typedef _Rb_tree<key_type,
                   value_type,
                   _Select1st<value_type>,
                   key_compare,
                   Alloc> _Rep_type;

  //! Important for iterators on set.
	typedef typename std::map<Key, Data>::iterator iterator;

  //! Constructor.              
  CSet() : std::map<Key, Data>() {
    
    CREATEOBJECT("CSet");
    
  }

  //! Copy-constructor.
  CSet(const CSet& set) : std::map<Key, Data>(set) {
    
    CREATEOBJECT("CSet");
    
  }

  //! Destructor.
  virtual ~CSet() {
    
    DELETEOBJECT("CSet");
    
  }

  //! Equality operator working on pointers.
  bool operator==(CSet<Key, Data>& set) {
    
    // is the size the same?
    if(set.size() != size())
      return false;

    iterator ite;
    iterator ite2;

    // are the sets empty?
    if(!empty())
      // test for every element in list 1 if there is a same element in list 2
      for(ite = begin();ite != end();ite++) {
        
        for(ite2 = set.begin();ite2 != set.end();ite2++) {
          
          if(*(ite->second) == *(ite2->second))
            break;
            
        }
        
        if(ite2 == set.end())
          return false;
          
      }

    return true;
    
  }


  //! Inequality operator working on pointers.
  inline bool operator!=(CSet<Key, Data>& set) {
    
    return !(operator==(set));
    
  }
  
};


/***************************************************************************
 *                                                                         *
 * class CList                                                             *
 *                                                                         *
 ***************************************************************************/
/*! \class CList
 *  \brief Defines a list with equality- and inequaltity-operator.
 *  \author Andre Neumann, Christian Anger
 *  \date Mon Jul 28 2003
 *
 *  \Attention Important is that the data-class is a pointer, else the
 *             equality-operator doesn't work.
 */
template<class Data>
class CList : public std::list<Data> {

public:
  //! Important for iteration on list.
  typedef _List_iterator<Data, Data&, Data*> iterator;

  //! Constructor.
  CList() : std::list<Data>() {
    
    CREATEOBJECT("CList");
    
  }

  //! Copy-constructor.
  CList(const CList& list) : std::list<Data>(list) {
    
    CREATEOBJECT("CList");
    
  }

  //! Destructor.
  virtual ~CList() {
    
    DELETEOBJECT("CList");
    
  }

  //! Equality operator working on pointers.
  bool operator==(CList<Data>& set) {

    // is the size the same?
    if(set.size() != size())
      return false;

    iterator ite;
    iterator ite2;

    // are the sets empty?
    if(!empty())
      // test for every element in list 1 if there is a same element in list 2
      for(ite = begin();ite != end();ite++) {
        
        for(ite2 = set.begin();ite2 != set.end();ite2++) {
          
          if(*(*ite) == *(*ite2))
            break;
            
        }
        
        if(ite2 == set.end())
          return false;
          
      }

    return true;
    
  }


  //! Inequality operator working on pointers.
  inline bool operator!=(CList<Data>& set) {
    
    return !(operator==(set));
    
  }
  
};

} //NS_NAMESPACE

#endif
