/***************************************************************************
                          io.h  -  description
                             -------------------
    begin                : Sat Aug 30 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 * Includes                                                                *
 *                                                                         *
 ***************************************************************************/
#include "algorithm.h"
#include "caggregation.h"
#include "cgraph.h"
#include "cnode.h"
#include "coperator.h"
#include "cprogram.h"
#include "crule.h"

/***************************************************************************
 *                                                                         *
 * Namespace NS_NOMORE                                                     *
 *                                                                         *
 ***************************************************************************/
namespace NS_NOMORE{
 
//! Output operator for an atom.
ostream& operator<<(ostream& os,
                    CAtom& atom);

//! Output operator for a body.
ostream& operator<<(ostream& os,
                    CBody &body);

//! Output operator for a rule.
ostream& operator<<(ostream& os,
                    CRule& rule);

//! Output operator for a program.
ostream& operator<<(ostream& os,
                    CProgram& program);

//! Output operator for a body node.
ostream& operator<<(ostream& os,
                    CBodyNode& node);

//! Output operator for a head node.
ostream& operator<<(ostream& os,
                    CHeadNode& node);

//! Output operator for a graph.
ostream& operator<<(ostream& os,
                    CGraph& graph);

//! Output operator for any heuristics.
ostream& operator<<(std::ostream& os,
                    CHeuristic& heu);

//! Output operator for any non-deterministic operator.
ostream& operator<<(std::ostream& os,
                    CNdOperator& op);

//! Output operator for any deterministic operator.
ostream& operator<<(std::ostream& os,
                    CDetOperator& op);

//! Output operator for todo queues
ostream& operator<<(std::ostream& os,
                    CTodoLists& todo);


} //end of namespace
