/***************************************************************************
                          misc.cpp  -  description
                             -------------------
    begin                : Thu Jun 19 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "misc.h"
#include "cnode.h"
#include "crule.h"
#include "cstatusinformation.h"

namespace NS_NOMORE {

/***************************************************************************
  different functions
****************************************************************************/
string TranslateColor(const TColor color) {
  
  switch(color) {
    
    case color_plus :
      return string("plus     ");
      
    case color_minus :
      return string("minus    ");
      
    case color_weak_plus :
      return string("weak-plus");
      
    case color_unknown :
      return string("unknown  ");
      
    case color_ignore :
      return string("ignore   ");
      
    case color_none :
      return string("none     ");
      
    default :
      return string("         ");
      
  };
  
}

/***************************************************************************
  class CIdGenerator
****************************************************************************/
TId CIdGenerator::_id = 0;

CIdGenerator::CIdGenerator() {
  
  CREATEOBJECT("CIdGenerator")
  
}

CIdGenerator::~CIdGenerator() {
  
  DELETEOBJECT("CIdGenerator")
  
}

/***************************************************************************
  class CLessNode
****************************************************************************/
bool CLessNode::operator()(CNode* n1, CNode* n2) {
  
  CHECK_POINTER("CLessNode::operator(n1)", n1);
  CHECK_POINTER("CLessNode::operator(n2)", n2);

  CHeuristic* heu1 = n1->GetHeuristic();
  CHeuristic* heu2 = n2->GetHeuristic();

  // possible CHECK_POINTER usage
  if(heu1 == NULL || heu2 == NULL) {
    
    cerr << "ERROR: Heuristics object is NULL!" << endl;
    return false;
    
  }

  return *heu1 < *heu2;
  
}

/***************************************************************************
  class CLessAtom
****************************************************************************/
bool CLessAtom::operator()(CAtom* a1, CAtom* a2) {

  CHECK_POINTER("CLessAtom::operator(a1)", a1);
  CHECK_POINTER("CLessAtom::operator(a2)", a2);
  
  return *a1 < *a2;
  
}

/***************************************************************************
  class CLessLookahead
****************************************************************************/
bool CLessLookahead::operator()(CLookaheadInformation* n1,
                                CLookaheadInformation* n2) {

  CHECK_POINTER("CLessLookahead::operator(n1)", n1);
  CHECK_POINTER("CLessLookahead::operator(n2)", n2);
  
	return n1->HeuristicValue() < n2->HeuristicValue();
  
}

/***************************************************************************
  class CPQueueLookahead
****************************************************************************/
CPQueueLookahead::CPQueueLookahead() {
  
  CREATEOBJECT("CPQueueLookahead");
  
}

CPQueueLookahead::~CPQueueLookahead() {
  
  Delete();
  DELETEOBJECT("CPQueueLookahead");
  
}

void CPQueueLookahead::Delete() {
  
  while(!empty()) {
    
    CLookaheadInformation* info = top();
    pop();

    if(info != NULL)
      delete info;
      
  }
  
}

/***************************************************************************
  class CIdGenerator
****************************************************************************/
CLookaheadInformation::CLookaheadInformation(CNode* node) {
  
  CREATEOBJECT("CLookAhead");
  
  _pnode = node;
  _pstatus_plus = new CStatusInformation();
  _pstatus_minus = new CStatusInformation();
  _heuristic = 0;
  
}

CLookaheadInformation::~CLookaheadInformation() {
  
  DELETEOBJECT("CLookAhead");
  
  delete _pstatus_plus;
  delete _pstatus_minus;
  
}

/***************************************************************************
  class CStack
****************************************************************************/
CStack::CStack() {
  
  CREATEOBJECT("CStack");

}

CStack::~CStack() {
  
  DELETEOBJECT("CStack");
  
}

/***************************************************************************
  class CAtomComparison
****************************************************************************/
bool CAtomComparison::operator()(const CAtom* a1, const CAtom* a2) const {

  CHECK_POINTER("CAtomComparison::operator(a1)", a1);
  CHECK_POINTER("CAtomComparison::operator(a2)", a2);
  
  return a1->operator<(*a2);
  
}

} // end of namespace NS_NOMORE
