/***************************************************************************
                          cnode.cpp  -  description
                             -------------------
    begin                : Thu Jun 19 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <cstdio>
#include "cnode.h"
#include "crule.h"
#include "misc.h"
#include "print.h"

#include <unistd.h>

namespace NS_NOMORE {

/***************************************************************************
  class CNode
****************************************************************************/
CNode::CNode() : _color(color_none), _is_in_propagation_queue(false),
    _is_in_backward_propagation_queue(false), _is_in_possible_choices_queue(false),
    _is_in_c_possible_choices_queue(false), _is_in_minus_queue(false), _min(0), _max(0),
     _can_be_propagated(false), _is_in_v4_set(false) {
  CREATEOBJECT("CNode");
  _pheuristic = new CHeuristicNone();
}

CNode::~CNode() {
  DELETEOBJECT("CNode");
  if(_pheuristic != NULL)
    delete _pheuristic;
  _pheuristic = NULL;
}

bool CNode::ColorNode(TColor color, CStack *stack, bool choice_point, TColor choice_color) {
  CHECK_POINTER("CNode::ColorNode(stack)", stack);
  INC_COUNT(methode_colornode);

  TStackElement elem;
  elem._pNode = this;
  elem._ChoicePoint = choice_point;
  elem._ChoicePointColor = choice_color;
  elem._SavedColor = GetColor();
  stack->push(elem);

  _color = color;
 
  return true; 
}

/***************************************************************************
 class CBodyNode
****************************************************************************/
CBodyNode::CBodyNode(CIdGenerator *ig, CBody *body) : CNode(), _pbody(body), _supported(0), 
      _weak_supported(0), _unsupported(0), _blocked(0), _unblocked(0), _uncolored_succs(0) {
  CHECK_POINTER("CBodyNode::CBodyNode(ig)", ig);
  SetId(ig->GetId());
  CREATEOBJECT("CBodyNode");
}

CBodyNode::CBodyNode(TId sid, CBody *body) : CNode(), _pbody(body), _supported(0), 
      _weak_supported(0), _unsupported(0), _blocked(0), _unblocked(0), _uncolored_succs(0) {

  SetId(sid);
  CREATEOBJECT("CBodyNode");  
}

CBodyNode::~CBodyNode() {
  DELETEOBJECT("CBodyNode");  
}

bool CBodyNode::operator==(const CNode &rhs) {
  
  if(GetType() != rhs.GetType())
    return false;

  CBodyNode *fg = (CBodyNode*)&rhs;
  if(_pbody == NULL || fg->_pbody == NULL)
  	return false;

  // same size of predecessors and successors
  if(_zero_predecessors.size() != fg->_zero_predecessors.size())
    return false;
  if(_one_predecessors.size() != fg->_one_predecessors.size())
    return false;
  if(_successors.size() != fg->_successors.size())
    return false;
    
  return *_pbody == *fg->_pbody;
}

bool CBodyNode::operator!=(const CNode &rhs) {
  return !(operator==(rhs));
}

bool CBodyNode::InsertZeroPredecessor(CHeadNode* node) {
  CHECK_POINTER("CBodyNode::InsertZeroPredecessor(node)", node);
  return _zero_predecessors.insert(node).second;
}

bool CBodyNode::InsertOnePredecessor(CHeadNode* node) {
  CHECK_POINTER("CBodyNode::InsertOnePredecessor(node)", node);
  return _one_predecessors.insert(node).second;
}

bool CBodyNode::Supported(TNodeSet* plus_colored) {
  INC_COUNT(methode_supported_by_set);

  if(_zero_predecessors.empty())
    return true;

  THeadNodeSetIterator ite;
  THeadNodeSetIterator end = _zero_predecessors.end();
  for(ite=_zero_predecessors.begin();ite!=end;ite++) {
    if(plus_colored->find((*ite)->GetId()) != plus_colored->end())
      return true;
  }
  return false;
}

bool CBodyNode::InsertSuccessor(CHeadNode* node) {
  CHECK_POINTER("CBodyNode::InsertSuccessor(node)", node);
  
  _successors.insert(node).second;
  if(node->InsertPredecessor(this)) {
    node->ModifyUnsupportedCounter(1);
    ModifyAllSuccsColoredCounter(1);
    return true;
  }
  return false;
}

bool CBodyNode::SelfBlocker() {
  THeadNodeSetIterator ite = _successors.begin();
  THeadNodeSetIterator end = _successors.end();
  for(; ite!=end; ite++) {
    THeadNodeSetIterator ite2 = _one_predecessors.find(*ite);
    if (ite2 != _one_predecessors.end())
      return true;
  }
  return false;
}

bool CBodyNode::LoadState(TStackElement *stack_element, CStack *stack) {
  CHECK_POINTER("CBodyNode::LoadState(stack_element)", stack_element);
  CHECK_POINTER("CBodyNode::LoadState(stack)"        , stack);

  TColor old_color = _color;
  _color = stack_element->_SavedColor;
  TColor new_color = _color;

  if(old_color == color_minus) {
    THeadNodeSetIterator hite = _successors.begin();
    THeadNodeSetIterator hend = _successors.end();
    // for all successors decrease unsupported counter
    for(; hite!=hend; hite++) {
      (*hite)->ModifyUnsupportedCounter(1);
    }
  }
    
  return true;  
}

/***************************************************************************
 class CHeadNode
****************************************************************************/
CHeadNode::CHeadNode(CIdGenerator *ig, CAtom* atom) : CNode(), _patom(atom), _unsupported(0) {
  CHECK_POINTER("CHeadNode::CHeadNode(ig)", ig);
  SetId(ig->GetId());
  CREATEOBJECT("CHeadNode");
}

CHeadNode::CHeadNode(TId sid, CAtom* atom) : CNode(), _patom(atom), _unsupported(0) {
  SetId(sid);
  CREATEOBJECT("CHeadNode");
}

CHeadNode::~CHeadNode() {
  DELETEOBJECT("CHeadNode");  
}

bool CHeadNode::operator==(const CNode &rhs) {
  
  if(GetType() != rhs.GetType())
    return false;

  CHeadNode *fg = (CHeadNode*)&rhs;

  if(_patom == NULL || fg->_patom == NULL)
  	return false;

  // same size of predecessors and successors
  if(_zero_successors.size() != fg->_zero_successors.size())
    return false;
  if(_one_successors.size() != fg->_one_successors.size())
    return false;
  if(_predecessors.size() != fg->_predecessors.size())
    return false;

  return *_patom == *fg->_patom;  
}

bool CHeadNode::operator!=(const CNode &rhs) {
  return !(operator==(rhs));
}

bool CHeadNode::InsertZeroSuccessor(CBodyNode* node) {
  CHECK_POINTER("CHeadNode::InsertZeroSuccessor(node)", node);
  _zero_successors.insert(node).second;
  if(node->InsertZeroPredecessor(this)) {
    node->ModifySupportedCounter(1);
    node->ModifyWeakSupportedCounter(1);
    return true;
  }
  return false;
}

bool CHeadNode::InsertOneSuccessor(CBodyNode* node) {
  CHECK_POINTER("CHeadNode::InsertOneSuccessor(node)", node);
  _one_successors.insert(node).second;
  if(node->InsertOnePredecessor(this)) {
    node->ModifyUnblockedCounter(1);
    return true;
  }
  return false;
}

bool CHeadNode::InsertPredecessor(CBodyNode* node) {
  CHECK_POINTER("CHeadNode::InsertSuccessor(node)", node);
  return _predecessors.insert(node).second;
}

bool CHeadNode::LoadState(TStackElement *stack_element, CStack *stack) {
  CHECK_POINTER("CHeadNode::LoadState(stack_element)", stack_element);
  CHECK_POINTER("CHeadNode::LoadState(stack)"        , stack);

  TColor old_color = _color;
  _color = stack_element->_SavedColor;
  TColor new_color = _color;

  TBodyNodeSetIterator bite, bend;

  if(old_color == color_plus) {
    bite = _zero_successors.begin();
    bend = _zero_successors.end();
    // for all 0-successors decrease supported counter
    for(; bite!=bend; bite++) {
      CBodyNode* bnode = *bite;
      bnode->ModifySupportedCounter(1);
      if(new_color != color_weak_plus)
        bnode->ModifyWeakSupportedCounter(1);
    }

    bite = _one_successors.begin();
    bend = _one_successors.end();
    // for all 1-successors decrease blocked counter
    for(; bite!=bend; bite++) {
      if(new_color != color_weak_plus)
        (*bite)->ModifyBlockedCounter(1);
    }
  } else 
  if(old_color == color_minus) {
    bite = _zero_successors.begin();
    bend = _zero_successors.end();
    // for all 0-successors decrease unsupported counter
    for(; bite!=bend; bite++) {
      CBodyNode* bnode = *bite;
      bnode->ModifyUnsupportedCounter(1);
      if(new_color == color_weak_plus)
        bnode->ModifyWeakSupportedCounter(-1);
    }

    bite = _one_successors.begin();
    bend = _one_successors.end();
    // for all 1-successors decrease unblocked counter
    for(; bite!=bend; bite++) {
      CBodyNode* bnode = *bite;
      bnode->ModifyUnblockedCounter(1);
      if(new_color == color_weak_plus)
        bnode->ModifyBlockedCounter(-1);
    }
  } else  
  if(old_color == color_weak_plus) {
    bite = _zero_successors.begin();
    bend = _zero_successors.end();
    // for all 0-successors decrease supported counter
    for(; bite!=bend; bite++) {
      (*bite)->ModifyWeakSupportedCounter(1);
    }

    bite = _one_successors.begin();
    bend = _one_successors.end();
    // for all 1-successors decrease blocked counter
    for(; bite!=bend; bite++) {
      if(new_color == color_none)
        (*bite)->ModifyBlockedCounter(1);
    }
  } else {
    bite = _zero_successors.begin();
    bend = _zero_successors.end();
    // for all 0-successors
    for(; bite!=bend; bite++) {
      if(new_color == color_weak_plus)
        (*bite)->ModifyWeakSupportedCounter(-1);
    }
  }

  if(old_color == color_plus || old_color == color_minus) {
    bite = _predecessors.begin();
    bend = _predecessors.end();
    // for all 0-successors decrease unsupported counter
    for(; bite!=bend; bite++) {
      (*bite)->ModifyAllSuccsColoredCounter(1);
    }
  }
  
  return true;  
}

} // end of namespace NS_NOMORE
