/***************************************************************************
                          cstatusinformation.h  -  description
                             -------------------
    begin                : Wed Jan 28 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSTATUSINFORMATION_H
#define CSTATUSINFORMATION_H

/*! \file cstatusinformation.h
 *  Contains the definition of CStatusInformation.
 */

/***************************************************************************
 *                                                                         *
 * Namespace NS_NOMORE                                                     *
 *                                                                         *
 ***************************************************************************/
namespace NS_NOMORE {

/***************************************************************************
 *                                                                         *
 * class CStatusInformation                                                *
 *                                                                         *
 ***************************************************************************/
/*! \class CStatusInformation cstatusinformation.h
 *  \brief Class for counting color changes in operators like P or Ps.
 *  \author Andre Neumann, Christian Anger
 *  \date Wed Jan 28 2004
 *
 *  Whenever a node changes its color this class calls it. See in the
 *  CGraph::ColorNode() methode for more information.
 */
class CStatusInformation {

private:
  //! Number of colored nodes (color_plus, color_minus, color_ignore).
  long _hard_colored;

  //! Number of colored nodes (any color).
  long _all_colored;
  
public:
  //! Constructs the object.
	CStatusInformation();

  //! Destructs the object.
  virtual ~CStatusInformation();

  //! Modifies the _hard_colored counter.
  void ModifyHardColored(int value);

  //! Returns the _hard_colored counter.
  inline long GetHardColored() {
    
    return _hard_colored;
    
  }

  //! Modifies the _all_colored counter.
  inline void ModifyAllColored(int value) {
    
    _all_colored += value;
    
  }

  //! Returns the _all_colored counter.
  inline long GetAllColored() {
    
    return _all_colored;
    
  }

  //! Clears all counters to zero.
  inline void Clear() {
    
    _hard_colored = 0;
    _all_colored = 0;
    
  }
  
};

} // NS_NOMORE

#endif
