/***************************************************************************
                          io.cpp  -  description
                             -------------------
    begin                : Sat Aug 30 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "algorithm.h"
#include "caggregation.h"
#include "cgraph.h"
#include "cnode.h"
#include "coperator.h"
#include "cprogram.h"
#include <stdio.h>

#include "crule.h"

namespace NS_NOMORE{
 
/***************************************************************************
  CNdOperator
****************************************************************************/
std::ostream& operator<<(std::ostream& os, CNdOperator& op) {
  
  if(op.GetType() == type_coperator_c)
    os << "NDET:C";
  else
  if(op.GetType() == type_coperator_cq)
    os << "NDET:CQ";
  else
  if(op.GetType() == type_coperator_d)
    os << "NDET:D";
  else
  if(op.GetType() == type_coperator_dq)
    os << "NDET:DQ";
  else
  if(op.GetType() == type_coperator_dh)
    os << "NDET:DH";
    
  return os;
  
}

/***************************************************************************
  CDetOperator
****************************************************************************/
std::ostream& operator<<(std::ostream& os, CDetOperator& op) {

  if(op.GetType() == type_coperator_bp)
    os << "BP";
  else
  if(op.GetType() == type_coperator_p)
    os << "P";
  else
  if(op.GetType() == type_coperator_ps)
    os << "Ps";
  else
  if(op.GetType() == type_coperator_u)
    os << "U";
  else
  if(op.GetType() == type_coperator_v)
    os << "V";
  else
  if(op.GetType() == type_coperator_v2)
    os << "V2";
  else
  if(op.GetType() == type_coperator_v3)
    os << "V3";
  else
  if(op.GetType() == type_coperator_v4)
    os << "V4";
  else
  if(op.GetType() == type_coperator_v5)
    os << "V5";
  else
  if(op.GetType() == type_coperator_n)
    os << "N";
  else
  if(op.GetType() == type_coperator_nsecure)
    os << "N";
  else
  if(op.GetType() == type_coperator_pre)
    os << "Pre";
  else
  if(op.GetType() == type_cdetoperator_none)
    os << "None";
  else
  if(op.GetType() == type_caggregation_star) {

    os << *((CAggregationStar*)&op)->GetOperator() << "*";

  } else
  if(op.GetType() == type_caggregation_sequence) {

    os << "(" << *((CAggregationSequence*)&op)->GetFirst()
       << "," << *((CAggregationSequence*)&op)->GetSecond() << ")";

  }

  return os;

}

/***************************************************************************
  CHeuristic
****************************************************************************/
ostream& operator<<(std::ostream& os, CHeuristic& heu) {

  if(heu.GetType() == type_cheuristic_none)
    os << "None" << &heu<<endl;
  else
  if(heu.GetType() == type_cheuristic_s1)
    os << "Static(1)" << endl;
  else
  if(heu.GetType() == type_cheuristic_s2)
    os << "Static(2)" << endl;
  else
  if(heu.GetType() == type_cheuristic_sr)
    os << "Static(Random)" << endl;
  else
  if(heu.GetType() == type_cheuristic_d1)
    os << "Dynamic(1)" << endl;
  else
  if(heu.GetType() == type_cheuristic_dr)
    os << "Dynamic(Random)" << endl;
  else
  if(heu.GetType() == type_cheuristic_alpha)
    os << "Dynamic(Alphabetical)" << endl;

  return os;
}

/***************************************************************************
  CGraph
****************************************************************************/
ostream& operator<<(ostream& os, CGraph& graph) {
  os << "GRAPH-BEGIN" << endl;
  os << "  Head-Nodes: " << endl;
  for(THeadNodeVectorIterator ite = graph.GetHeadNodes()->begin(); ite != graph.GetHeadNodes()->end();
      ite++) {
    os << "    " << *(CHeadNode*)(*ite);
  }

  os << "  Body-Nodes: " << endl;
  for(TBodyNodeVectorIterator ite = graph.GetBodyNodes()->begin(); ite != graph.GetBodyNodes()->end();
      ite++) {
    os << "    " << *(CBodyNode*)(*ite);
  }
  os << "GRAPH-END" << endl;
  return os;
}

/***************************************************************************
  CBodyNode
****************************************************************************/
ostream& operator<<(ostream& os, CBodyNode& node) {

  // output: '{B/H}id[color]: body'

  char buffer[1024];

  sprintf(buffer, "B[%5i/%s]: ", node.GetId(),
          TranslateColor(node.GetColor()).c_str());
  
  os << buffer << *node.GetBody();/* << "      -> Heu: "<<*(node.GetHeuristic());
  THeadNodeSetIterator it = node.GetSuccessors().begin();
  THeadNodeSetIterator end = node.GetSuccessors().end();
  os << "Succs:" << endl;
  for(; it!=end; ++it) {
    os << "H"<<(*it)->GetId() << ", ";
  }
  os << endl;*/

  return os;

}

/***************************************************************************
  CHeadNode
****************************************************************************/
ostream& operator<<(ostream& os, CHeadNode& node) {

  // output: '{B/H}id[color]: head'

  char buffer[1024];

  sprintf(buffer, "H[%5i/%s]: ", node.GetId(),
          TranslateColor(node.GetColor()).c_str());

  os << buffer << *node.GetHead();// << "      -> Heu: "<<*(node.GetHeuristic());
/*  TBodyNodeSetIterator it = node.GetZeroSuccessors().begin();
  TBodyNodeSetIterator end = node.GetZeroSuccessors().end();
  os << "0-Succs:" << endl;
  for(; it!=end; ++it) {
    os << "B"<<(*it)->GetId() << ", ";
  }
  os << endl;
  it = node.GetOneSuccessors().begin();
  end = node.GetOneSuccessors().end();
  os << "1-Succs:" << endl;
  for(; it!=end; ++it) {
    os << "B"<<(*it)->GetId() << ", ";
  }
  os << endl;*/

  return os;

}

/***************************************************************************
  CProgram 
****************************************************************************/
ostream& operator<<(ostream& os, CProgram& program) {
  
  os << "PROGRAM-BEGIN" << endl;

  os << "  Atoms: " << endl;
  for(TAtomVectorIterator ite = program.GetAtoms().begin(); ite != program.GetAtoms().end(); ite++) {
    os << "    " << *(*ite);
  }

  os << "  Heads: " << endl;
  for(TIdSetIterator ite = program.GetHeads().begin(); ite != program.GetHeads().end(); ite++) {
    os << "    " << *ite << endl;
  }

  os << "  Bodies: " << endl;
  TBodySet::iterator ite2;
  for(TnBodySetIterator ite2 = program.GetBodies().begin(); ite2 != program.GetBodies().end();ite2++) {
    os << "    " << *(*ite2);
  }

  os << "  Rules: " << endl;
  for(TRuleVectorIterator ite3 = program.GetRules().begin(); ite3 != program.GetRules().end(); ite3++){
    os << *(*ite3);
  }

  os << "PROGRAM-END" << endl;
  return os;
}

/***************************************************************************
  CAtom
****************************************************************************/
ostream& operator<<(ostream& os, CAtom& atom) {

  // name [id]

  char buffer[1024];
  sprintf(buffer, "%s  [%i]", atom.GetName().c_str(), atom.GetId());

  os << buffer << endl;
  return os;
  
}

/***************************************************************************
  CBody
****************************************************************************/
ostream& operator<<(ostream& os, CBody &body) {

  // pos-Atoms, not neg-Atoms [id]
  
  int pos = body.GetPosAtoms().size();
  int neg = body.GetNegAtoms().size();

  int i = 0;
  TIdSetIterator ite;
  for(ite = body.GetPosAtoms().begin();
      ite != body.GetPosAtoms().end();
      ite++) {
    
    os << (*ite);

    if(i<pos-1 ||neg!=0)
      os << ", ";
    
  }

  i = 0;
  for(ite = body.GetNegAtoms().begin();
      ite != body.GetNegAtoms().end();
      ite++) {
    
    os << "not " << (*ite);

    if(i<neg-1)
      os << ", ";
      
  }

  char buffer[10];
  sprintf(buffer, "[%i]", body.GetId());

  os << " " << buffer << endl;
  
	return os;

}

/***************************************************************************
  CRule
****************************************************************************/
ostream& operator<<(ostream& os, CRule& rule) {
  char buffer[10];
  sprintf(buffer, "[%i]", rule.GetId());
  os << "  RULE-BEGIN " << buffer << endl;
  if(rule.GetHead() != NULL)
    os << "    Head : " << *rule.GetHead() << endl;
  if(rule.GetBody() != NULL)
    os << "    Body : " << *rule.GetBody() << endl;
  os << "  RULE-END" << endl;

  return os;
}

/***************************************************************************
  CTodoLists
****************************************************************************/
ostream& operator<<(std::ostream& os, CTodoLists& todo) {

  TQueue save;
  CNode* node;
  TBodyNodeQueue bsave;
  CBodyNode* bnode;

  os << "PropQueue = [";
  while(!todo._prop.empty()) {
    bnode = todo._prop.front();
    todo._prop.pop();
    bsave.push(bnode);
    os << bnode->GetId();
    if(bnode->GetType() == type_cbodynode)
      os << "b";
    else
      os << "h";
    os << ", ";
  }
  while(!bsave.empty()) {
    bnode = bsave.front();
    bsave.pop();
    todo._prop.push(bnode);
  }
  os << "]" << endl;

  os << "BackPropQueue = [";
  while(!todo._backprop.empty()) {
    node = todo._backprop.front();
    todo._backprop.pop();
    save.push(node);
    os << node->GetId();
    if(node->GetType() == type_cbodynode)
      os << "b";
    else
      os << "h";
    os << ", ";
  }
  while(!save.empty()) {
    node = save.front();
    save.pop();
    todo._backprop.push(node);
  }
  os << "]" << endl;

  os << "MinusQueue = [";
  while(!todo._minus.empty()) {
    node = todo._minus.front();
    todo._minus.pop();
    save.push(node);
    os << node->GetId();
    if(node->GetType() == type_cbodynode)
      os << "b";
    else
      os << "h";
    os << ", ";
  }
  while(!save.empty()) {
    node = save.front();
    save.pop();
    todo._minus.push(node);
  }
  os << "]" << endl;

  os << "C-ChoicesQueue = [";
  while(!todo._c_choices.empty()) {
    node = todo._c_choices.front();
    todo._c_choices.pop();
    save.push(node);
    os << node->GetId();
    if(node->GetType() == type_cbodynode)
      os << "b";
    else
      os << "h";
    os << ", ";
  }
  while(!save.empty()) {
    node = save.front();
    save.pop();
    todo._c_choices.push(node);
  }
  os << "]" << endl;

  os << "D-ChoicesQueue = [";
  while(!todo._choices.empty()) {
    node = todo._choices.front();
    todo._choices.pop();
    save.push(node);
    os << node->GetId();
    if(node->GetType() == type_cbodynode)
      os << "b";
    else
      os << "h";
    os << ", ";
  }
  while(!save.empty()) {
    node = save.front();
    save.pop();
    todo._choices.push(node);
  }
  os << "]" << endl;

  return os;
}


} //end of namespace
