/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_BODY_LOOKAHEAD_HEURISTIC_H
#define LIBNOMORE_BODY_LOOKAHEAD_HEURISTIC_H
#include <operator_based_heuristic.h>
#include <operators/body_lookahead.h>
#include <functional>
namespace NS_NOMORE {

//! Heuristic-Strategy that compares two body nodes based on the  heuristic values generated by the BodyLookahead operator.
/*! The operator BodyLookahead generates values containing two counters called max and min.
 *  The node with the greatest max values is better. If both max values are equal
 *  the min value is checked.
 *  
 *  \note This strategy may be used only with an operator-based heuristic.
 *  \note If you want to use this strategy make sure that you also use the BodyLookahead-Operator.
 *
 *  \see BodyLookaheadHeuristic
 *  \see OperatorBasedHeuristic
 */
class BodyLookaheadHeuristicStrat {
public:
  typedef BodyLookahead::ResultType ValueType;
  typedef BodyLookahead::EventType EventType;
  typedef std::greater<ValueType> ComparatorType;
  
};

typedef OperatorBasedHeuristic<BodyLookaheadHeuristicStrat> BodyLookaheadHeuristic;

}
#endif
