/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <body_node.h>
#include <head_node.h>
#include <event/channel_manager.h>
#include "detail/functors.h"
namespace NS_NOMORE {

BodyNode::BodyNode(long id) 
    : Node(id)
    , supported_(0), weakSupported_(0), unsupported_(0)
    , blocked_(0), unblocked_(0), uncoloredSuccessors_(0) {
}

void BodyNode::zeroPredecessorColored(Color::ColorValue oldColor, 
                                      Color::ColorValue newColor) {

  // supported_ -= newColor == Color::plus;
  // weakSupported_ -= newColor == Color::plus && oldColor == Color::none;
  // unsupported_ -= newColor == Color::minus;
  // ...

  if(newColor == Color::plus) {
    --supported_;
    if(oldColor == Color::none)
      --weakSupported_;
  } 
  else if(newColor == Color::minus) {
    --unsupported_;
  } 
  else if(newColor == Color::weak_plus) {
    --weakSupported_;
  } 
  else if(oldColor == Color::weak_plus) {
    assert(false);
    ++weakSupported_;
  }
}

void BodyNode::onePredecessorColored(Color::ColorValue oldColor, 
                                     Color::ColorValue newColor) {

  // siehe zeroPredecessorColored

  if(newColor == Color::plus && oldColor != Color::weak_plus) {
    --blocked_;
  } 
  else if(newColor == Color::minus) {
    --unblocked_;
  } 
  else if(newColor == Color::weak_plus && oldColor == Color::none) {
    --blocked_;
  } 
}

void BodyNode::successorColored(Color::ColorValue, 
                                Color::ColorValue newColor) {

  if(newColor == Color::minus || newColor == Color::plus)
    --uncoloredSuccessors_;
}

void BodyNode::zeroPredecessorRestored(Color::ColorValue oldColor, 
                                       Color::ColorValue newColor) { 
  
  if(oldColor == Color::plus) {
    ++supported_;
    if(newColor != Color::weak_plus)
      ++weakSupported_;
  } 
  else if(oldColor == Color::minus) {
    ++unsupported_;
  } 
  else if(oldColor == Color::weak_plus) {
    ++weakSupported_;
  } 
  else if(newColor == Color::weak_plus) {
    assert(false);
    --weakSupported_;
  }
}

void BodyNode::onePredecessorRestored(Color::ColorValue oldColor, 
                                      Color::ColorValue newColor) {

  if(oldColor == Color::plus && newColor != Color::weak_plus) {
    ++blocked_;
  } 
  else if(oldColor == Color::minus) {
    ++unblocked_;
  } 
  else if(oldColor == Color::weak_plus && newColor == Color::none) {
    ++blocked_;
  } 
}

void BodyNode::successorRestored(Color::ColorValue oldColor, 
                                 Color::ColorValue) {
  if(oldColor == Color::minus || oldColor == Color::plus)
    ++uncoloredSuccessors_;
}


void BodyNode::insertZeroPredecessor(HeadNode &h){
  zeroPredecessors_.push_back(&h);
  ++supported_;
  ++weakSupported_;
}

void BodyNode::insertOnePredecessor(HeadNode &h) {
  onePredecessors_.push_back(&h);
  ++unblocked_;
}

void BodyNode::insertSuccessor(HeadNode &h) {
  successors_.push_back(&h);
  ++uncoloredSuccessors_;
  h.insertPredecessor(*this);
}

void BodyNode::doSetColor(Color::ColorValue oldColor) {
  HeadNodeSet::const_iterator it = successors_.begin();
  HeadNodeSet::const_iterator end = successors_.end();

  for(; it != end; ++it) {
    (*it)->predecessorColored(oldColor, getColor());
  }
}

void BodyNode::doRestoreColor(Color::ColorValue oldColor) {
  HeadNodeSet::const_iterator it = successors_.begin();
  HeadNodeSet::const_iterator end = successors_.end();

  for(; it != end; ++it) {
    (*it)->predecessorRestored(oldColor, getColor());
  }
}

void BodyNode::fireColorEvent(event::ChannelManager& c, Color::ColorValue oldColor) {
	BodyNodeColored e(this, oldColor);
	c.dispatch(e);
}

void BodyNode::fireColorChoicePointEvent(event::ChannelManager& c, Color::ColorValue oldColor, bool recolored) {
  BodyNodeColoredChoicePoint e(this, oldColor, recolored);
  c.dispatch(e);
}

void BodyNode::fireRestoreEvent(event::ChannelManager& c, Color::ColorValue oldColor) {
	BodyNodeRestored e(this, oldColor);
	c.dispatch(e);
}


} // NS_NOMORE
