/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include "lparse_writer.h"
#include <body_node.h>
#include <head_node.h>
#include <graph.h>

#include <algorithm>
#include <iterator>
#include <iostream>
#include <ostream>

#if defined (_MSC_VER) && _MSC_VER <= 1300
#define for if(0); else for
#endif

namespace NS_NOMORE { namespace DETAIL {

void LparseWriter::writeGraph(std::ostream& os, const Graph& grp) {

  const char* delimiter = "0";
  const char* endOfFile = "1";

	// write rules
	for(Graph::HeadNodeIterator it = grp.headNodesBegin(); it != grp.headNodesEnd(); ++it) {
    writeBodies(os, **it);    

    if((*it)->getColor() == Color::plus)
      bPlus_.insert((*it)->getId());

    if((*it)->getColor() == Color::minus)
      bMinus_.insert((*it)->getId());
  }

  os << delimiter << "\n";

	// write symbol table
	for(Graph::HeadNodeIterator it = grp.headNodesBegin(); it != grp.headNodesEnd(); ++it) {
    if(!bMinus_.count((*it)->getId())) {
      os << (*it)->getId() << " " << (*it)->getAtom().getName() << "\n";
    }
  }  

	// write compute statement
  os << delimiter << "\n";
  os << "B+\n";
  std::copy(bPlus_.begin(), bPlus_.end(), std::ostream_iterator<long>(os, "\n"));

  os << delimiter << "\n";
  os << "B-\n";
  std::copy(bMinus_.begin(), bMinus_.end(), std::ostream_iterator<long>(os, "\n"));

  os << delimiter << "\n";
  os << endOfFile << "\n";
}

void LparseWriter::writeBodies(std::ostream& os, const HeadNode& head) {

  const char* ruleType = "1";

  for(HeadNode::BodyNodeIterator it = head.predecessorsBegin(); 
    it != head.predecessorsEnd(); ++it) {
    os << ruleType << " " << head.getId() << " ";
    writeBody(os, **it);
  }
}

void LparseWriter::writeBody(std::ostream& os, const BodyNode& body) {

  os << (unsigned int)body.countBodyAtoms() << " " 
     << (unsigned int)body.countNegBodyAtoms() << " ";
  for(BodyNode::HeadNodeIterator it = body.onePredecessorsBegin(); 
    it != body.onePredecessorsEnd(); ++it) {
    os << (*it)->getAtom().getId() << " ";
  }

  for(BodyNode::HeadNodeIterator it = body.zeroPredecessorsBegin(); 
    it != body.zeroPredecessorsEnd(); ++it) {
    os << (*it)->getAtom().getId() << " ";
  }

  os << "\n";
}

} }
