/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <head_node.h>
#include <body_node.h>
#include <event/channel_manager.h>

namespace NS_NOMORE {

HeadNode::HeadNode(long atomId) 
	: Node(atomId)
	, atom_(new Atom(atomId))
	, unsupported_(0) {
}

HeadNode::~HeadNode() {
	delete atom_;
}

void HeadNode::predecessorColored(Color::ColorValue, 
                                  Color::ColorValue newColor) {

  // modify unsupported_ if newColor is minus
  unsupported_ -= (newColor == Color::minus);
}

void HeadNode::predecessorRestored(Color::ColorValue oldColor, 
                                   Color::ColorValue) {

  // modify unsupported_ if newColor is minus
  unsupported_ += (oldColor == Color::minus);
}

void HeadNode::insertPredecessor(BodyNode &b){
  assert(b.getColor() == Color::none);
  predecessors_.push_back(&b);
  ++unsupported_;
}

void HeadNode::insertZeroSuccessor(BodyNode &b) {
  zeroSuccessors_.push_back(&b);
  b.insertZeroPredecessor(*this);
}

void HeadNode::insertOneSuccessor(BodyNode &b) {
  oneSuccessors_.push_back(&b);
  b.insertOnePredecessor(*this);
}

void HeadNode::doSetColor(Color::ColorValue oldColor) {
  BodyNodeSet::const_iterator it = predecessors_.begin();
  BodyNodeSet::const_iterator end = predecessors_.end();
  for(; it != end; ++it) {
    (*it)->successorColored(oldColor, getColor());
  }

  end = zeroSuccessors_.end();
  for(it = zeroSuccessors_.begin(); it != end; ++it) {
    (*it)->zeroPredecessorColored(oldColor, getColor());
  }

  end = oneSuccessors_.end();
  for(it = oneSuccessors_.begin(); it != end; ++it) {
    (*it)->onePredecessorColored(oldColor, getColor());
  }
}

void HeadNode::doRestoreColor(Color::ColorValue oldColor) {
  BodyNodeSet::const_iterator it = predecessors_.begin();
  BodyNodeSet::const_iterator end = predecessors_.end();
  for(; it != end; ++it) {
    (*it)->successorRestored(oldColor, getColor());
  }

  end = zeroSuccessors_.end();
  for(it = zeroSuccessors_.begin(); it != end; ++it) {
    (*it)->zeroPredecessorRestored(oldColor, getColor());
  }

  end = oneSuccessors_.end();
  for(it = oneSuccessors_.begin(); it != end; ++it) {
    (*it)->onePredecessorRestored(oldColor, getColor());
  }
}

void HeadNode::fireColorEvent(event::ChannelManager& c, Color::ColorValue oldColor) {
	HeadNodeColored e(this, oldColor);
	c.dispatch(e);
}

void HeadNode::fireColorChoicePointEvent(event::ChannelManager& c, Color::ColorValue oldColor, bool recolored) {
  HeadNodeColoredChoicePoint e(this, oldColor, recolored);
  c.dispatch(e);
}

void HeadNode::fireRestoreEvent(event::ChannelManager& c, Color::ColorValue oldColor) {
	HeadNodeRestored e(this, oldColor);
	c.dispatch(e);
}

} // NS_NOMORE
