/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <node.h>
#include <generic_value.h>
#include <cassert>

namespace NS_NOMORE {

Node::Node(long id) : color_(Color::none), id_(id), value_(0) {

}

Node::~Node() {
  delete value_;
}

void Node::installValue(ValueBase* v) {
  if (v != value_) {
    delete value_;
    value_ = v;
  }
}

bool Node::setColor(Color::ColorValue c) {
  assert(c != Color::none);
  if((c == color_) ||  // same color
     (c == Color::weak_plus && color_ == Color::plus) || // plus to weak_plus
     (c == Color::ignore && color_ != Color::none)) // any color (except none) to ignore
    return false;

  if(isValidColoring(color_, c)) {
    Color::ColorValue oldColor = color_;
    color_ = c;

    doSetColor(oldColor);

    return true;
  }

  throw ColorError();
}

void Node::restoreColor(Color::ColorValue c) {
  assert(c == Color::ignore || c == Color::none || c == Color::weak_plus);

  Color::ColorValue oldColor = color_;
  color_ = c;

  doRestoreColor(oldColor);
}

} // NS_NOMORE
