/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/body_lookahead.h>
#include <body_node.h>
#include <head_node.h>
#include <colorerror.h>
#include <graph.h>
#include <iostream>
namespace NS_NOMORE {

BodyLookahead::BodyLookahead(Graph& grp, Operator& op) 
  : Lookahead(BodyLookahead::getOpName(), grp, op), counterPlus_(0)
  , counterMinus_(0), lookaheadNode_(0), isLookaheadNodeSupported_(false) {
}

BodyLookahead::BodyLookahead(Graph& grp) 
  : Lookahead(BodyLookahead::getOpName(), grp)
  , counterPlus_(0)
  , counterMinus_(0)
  , lookaheadNode_(0)
  , isLookaheadNodeSupported_(false) {
}

bool BodyLookahead::execute() {
  bool result = false;
  
  Lookahead::execute();
  event::ChannelManager &em = getGraph().getEventManager();
  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);

  while(checkBodyNodes())
    result = true;
    
  return result;
}

bool BodyLookahead::checkBodyNodes() {
  Graph::UncoloredBodyNodeIterator end = getGraph().uncoloredBodyNodesEnd();
  Graph::UncoloredBodyNodeIterator it = getGraph().uncoloredBodyNodesBegin();
  for(; it != end; ++it) {
    lookaheadNode_ = *it;
    assert(lookaheadNode_->getColor() == Color::none);
    isLookaheadNodeSupported_ = (*it)->isSupported();
    if(checkCurrentNode()) {
      return true;
    }
  }
  return false;
}

void BodyLookahead::handle(const HeadNodeColored& e) {
  if(e.node_->oneSuccessorsBegin() != e.node_->oneSuccessorsEnd())
    (lookaheadColorCheck_ == Color::plus)?++counterPlus_:++counterMinus_;
}

void BodyLookahead::handle(const HeadNodeColoredChoicePoint& e) {
  if(e.node_->oneSuccessorsBegin() != e.node_->oneSuccessorsEnd())
    (lookaheadColorCheck_ == Color::plus)?++counterPlus_:++counterMinus_;
}

void BodyLookahead::UpdateLookaheadInfoMap(LookaheadInfoMap &infoMap, long nodeId) {
  LookaheadInfoMapIterator it = infoMap.find(nodeId);
  if(it != infoMap.end() && !it->second) {
    it->second = isLookaheadNodeSupported_;
  } else {
    infoMap[nodeId] = isLookaheadNodeSupported_;
  }
}

void BodyLookahead::handle(const BodyNodeColored& e) {
  if(e.node_->getColor() == Color::plus || e.node_->getColor() == Color::weak_plus)
    UpdateLookaheadInfoMap(lookaheadPlusInfos_, e.node_->getId());
  else
  if(e.node_->getColor() == Color::minus)
    UpdateLookaheadInfoMap(lookaheadMinusInfos_, e.node_->getId());
}

void BodyLookahead::resetCounter() {
  counterPlus_ = 0;
  counterMinus_ = 0;
}

void BodyLookahead::storeHeuristic() {
  event::ChannelManager &em = getGraph().getEventManager();
  em.dispatch(EventType(lookaheadNode_, ResultType(counterPlus_, counterMinus_)));
}

void BodyLookahead::postExecute() {
  event::ChannelManager &em = getGraph().getEventManager();
  em.getChannelFor(event::Event<HeadNodeColored>()).disconnect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).disconnect(*this);  
  em.getChannelFor(event::Event<BodyNodeColored>()).disconnect(*this);
  lookaheadPlusInfos_.clear();
  lookaheadMinusInfos_.clear();

  Lookahead::postExecute();
}

bool BodyLookahead::checkCurrentNode() {

  try {
    resetCounter();
    LookaheadInfoMapIterator it = lookaheadPlusInfos_.find(lookaheadNode_->getId());
    if(it == lookaheadPlusInfos_.end() || !(it->second || !isLookaheadNodeSupported_)) {           
      lookaheadColorCheck_ = lookaheadNode_->preferredChoicePointColor();
      alternativeColor_ = lookaheadNode_->alternativeChoicePointColor();
      checkColor(*lookaheadNode_, lookaheadColorCheck_);
    }

    it = lookaheadMinusInfos_.find(lookaheadNode_->getId());
    if(it == lookaheadMinusInfos_.end() || !(it->second || !isLookaheadNodeSupported_)) {
      lookaheadColorCheck_ = lookaheadNode_->alternativeChoicePointColor();
      alternativeColor_ = lookaheadNode_->preferredChoicePointColor();      
      checkColor(*lookaheadNode_, lookaheadColorCheck_);
    }

    storeHeuristic();
  } 
  catch(const ColorError&) {
    // conflict found
    color(*lookaheadNode_, alternativeColor_);    
    // reset the info map (all nodes must be re-checked)
    lookaheadPlusInfos_.clear();
    lookaheadMinusInfos_.clear();
    // conflict, but other way work
    return true;
  }  

  // no conflict
  return false;
}


}
