#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>
#include <generic_value.h>
#include <memory>
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {
class TestGenericValue : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(TestGenericValue);
  CPPUNIT_TEST(testExtract);
  CPPUNIT_TEST(testExtractBad);
  CPPUNIT_TEST_SUITE_END();

public:
  TestGenericValue() {
  }
  
  void testExtract() {
    std::auto_ptr<ValueBase> v(new ValueHolder<long>(1));
    CPPUNIT_ASSERT_EQUAL(1l, value_cast<long>(v.get()));
  }
  void testExtractBad() {
    std::auto_ptr<ValueBase> v(new ValueHolder<long>(1));
    
    CPPUNIT_ASSERT_THROW(value_cast<char>(v.get()), std::bad_cast);
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(TestGenericValue);
}
