/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_HEURISTIC_H
#define LIBNOMORE_HEURISTIC_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <node.h>
#include <list>
#include <vector>
#include <constraint.h>

namespace NS_NOMORE {

class BodyNode;
class HeadNode;
class Graph;

//! Base class for Heuristics.
/*!
 * heuristics guide the selection of choice points. They are used together
 * with a \ref ChoiceOperator "choice-operator".
 */
class Heuristic {
public: 
  //! Constructs the heuristics.
  Heuristic();

  //! Destroys the heuristics.
  virtual ~Heuristic();
  
  //! sets the graph on which this heuristic should work.
  virtual void setGraph(Graph& g);

  
  //! returns the "best" node according to this heuristic that satisfies the given constraint.
  /*!
   * \param c the constraint a potential best node must satisfy.
   * \return the "best" head or body node according to this heuristic or 0 if no such node exists
   */
  virtual Node* selectNode(const Constraint& c) = 0;
};

/*!
 * This heuristic selects the first uncolored node that satisfies the
 * the given constraint.
 */
class SelectFirst : public Heuristic {
public:
  SelectFirst();
  virtual void setGraph(Graph& g);
  virtual Node* selectNode(const Constraint& c);
private:
  Graph* graph_;
};

typedef SelectFirst NoHeuristic;


}

#endif
