/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/hybrid_select.h>
#include <graph.h>
#include <body_node.h>
#include <head_node.h>
namespace NS_NOMORE {

HybridSelect::HybridSelect(Graph& grp, Heuristic* h) 
  : ChoiceOperator(HybridSelect::getOpName(), grp, h) {
}

Node* HybridSelect::selectChoice() {
  return getHeuristic().selectNode(*this);
}


bool HybridSelect::isSatisfiedBy(const Node& n) const {
  return n.getColor() == Color::none 
    && n.getType() == NodeType::body_node 
    && (n.trivialComponent() || static_cast<const BodyNode&>(n).isSupported());
}

bool HybridSelect::supersedes(const Node& n1, const Node& n2) const {
  if(n2.getType() == NodeType::head_node)
    return true;

  const BodyNode *bn2 = static_cast<const BodyNode*>(&n2);

  if(n1.getType() == NodeType::head_node)
    return !bn2->isSupported() && !bn2->trivialComponent();

  const BodyNode *bn1 = static_cast<const BodyNode*>(&n1);

  return (bn1->isSupported() || bn1->trivialComponent()) || 
        !(bn2->isSupported() || bn2->trivialComponent());
}

}
