#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <statistics/full_statistic.h>
#include <graph.h>
#include <operators/forward_prop.h>
#include <operators/unfounded_set.h>

using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class FullStatisticTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(FullStatisticTest);
  CPPUNIT_TEST(testDecorate);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
  }

  void tearDown() {
  }

  void testDecorate() {
    Graph grp;
    FullStatistics stats;
    stats.registerWith(grp.getEventManager());
    
    Operator *p = stats.decorate(new ForwardPropagator(grp));
    Operator *u = stats.decorate(new UnfoundedSetOperator(grp));

    CPPUNIT_ASSERT_EQUAL( 0l, stats.countOperatorCalls(p->getName()) );
    CPPUNIT_ASSERT_EQUAL( 0l, stats.countOperatorCalls(u->getName()) );
    (*p)();
    CPPUNIT_ASSERT_EQUAL( 1l, stats.countOperatorCalls(p->getName()) );
    CPPUNIT_ASSERT_EQUAL( 0l, stats.countOperatorCalls(u->getName()) );
    (*p)();
    CPPUNIT_ASSERT_EQUAL( 2l, stats.countOperatorCalls(p->getName()) );
    CPPUNIT_ASSERT_EQUAL( 0l, stats.countOperatorCalls(u->getName()) );
    (*p)();
    CPPUNIT_ASSERT_EQUAL( 3l, stats.countOperatorCalls(p->getName()) );
    CPPUNIT_ASSERT_EQUAL( 0l, stats.countOperatorCalls(u->getName()) );
    (*u)();
    CPPUNIT_ASSERT_EQUAL( 3l, stats.countOperatorCalls(p->getName()) );
    CPPUNIT_ASSERT_EQUAL( 1l, stats.countOperatorCalls(u->getName()) );
    (*u)();
    CPPUNIT_ASSERT_EQUAL( 3l, stats.countOperatorCalls(p->getName()) );
    CPPUNIT_ASSERT_EQUAL( 2l, stats.countOperatorCalls(u->getName()) );

    delete p;
    delete u;
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(FullStatisticTest);

} // NS_NOMORE_TESTS
