#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <operators/select_supported.h>
#include <operators/hybrid_lookahead.h>
#include <heuristics/hybrid_lookahead_heuristic.h>
#include <graph.h>
#include <head_node.h>
#include <body_node.h>

using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class SelectSupportTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(SelectSupportTest);
  CPPUNIT_TEST(testBetterUnsupportedChoice);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
  }

  void tearDown() {
  }

  void testBetterUnsupportedChoice() {
    Graph grp;
    HybridLookaheadHeuristic* heu = 0;
    SelectSupported supp(grp, heu = new HybridLookaheadHeuristic());

    BodyNode *bn1 = grp.insertBodyNode();
    BodyNode *bn2 = grp.insertBodyNode();
    HeadNode *hn1 = grp.insertHeadNode(1);

    hn1->insertZeroSuccessor(*bn1);

    heu->addHeuristicValue(bn1, HybridLookahead::HeuristicValueType(3));
    heu->addHeuristicValue(bn2, HybridLookahead::HeuristicValueType(2));
    CPPUNIT_ASSERT_EQUAL( (Node*)bn2, supp.selectChoice() );
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(SelectSupportTest);

} // end namespace NS_NOMORE_TESTS

