#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <operators/select_successors.h>
#include <heuristics/hybrid_lookahead_heuristic.h>
#include <graph.h>
#include <head_node.h>
#include <body_node.h>

using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class SelectSuccessorsTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(SelectSuccessorsTest);
  //CPPUNIT_TEST(testBaseCase);
  CPPUNIT_TEST(test2BodyNodes);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
  }

  void tearDown() {
  }

  void testBaseCase() {
    Graph grp;
    HybridLookaheadHeuristic* heu = new HybridLookaheadHeuristic();
    SelectSuccessors supp(grp, heu);

    BodyNode *bn1 = grp.insertBodyNode();
    HeadNode *hn1 = grp.insertHeadNode(1);
    HeadNode *hn2 = grp.insertHeadNode(2);

    bn1->insertSuccessor(*hn1);
    bn1->insertSuccessor(*hn2);

    heu->addHeuristicValue(bn1, HybridLookahead::HeuristicValueType(3));
    CPPUNIT_ASSERT_EQUAL( (Node*)bn1, supp.selectChoice().node() );

    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));
    CPPUNIT_ASSERT_EQUAL( (Node*)hn1, supp.selectChoice().node() );
    grp.color(*hn1, Color::plus);

    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));
    CPPUNIT_ASSERT_EQUAL( (Node*)hn2, supp.selectChoice().node() );
    grp.color(*hn2, Color::plus);

    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));
    CPPUNIT_ASSERT_EQUAL( (Node*)0, supp.selectChoice().node() );
  }

  void test2BodyNodes() {
    Graph grp;
    HybridLookaheadHeuristic* heu = new HybridLookaheadHeuristic();
    SelectSuccessors supp(grp, heu);
/*
    b1 <- h1
    b1 <- h2
    b2 <- h3

D1: select b1
D2: select b2
D3: select 0
D2: select h3
D2: select 0
D1: select h1
D1: select h2
D1: select 0
*/
    BodyNode *bn1 = grp.insertBodyNode();
    BodyNode *bn2 = grp.insertBodyNode();
    HeadNode *hn1 = grp.insertHeadNode(1);
    HeadNode *hn2 = grp.insertHeadNode(2);
    HeadNode *hn3 = grp.insertHeadNode(3);

    bn1->insertSuccessor(*hn1);
    bn1->insertSuccessor(*hn2);
    bn2->insertSuccessor(*hn3);

    heu->addHeuristicValue(bn1, HybridLookahead::HeuristicValueType(3));
    heu->addHeuristicValue(bn2, HybridLookahead::HeuristicValueType(2));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::succeeded, supp() );
    CPPUNIT_ASSERT_EQUAL( bn1->preferredChoicePointColor(), bn1->getColor() );    
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::save));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::succeeded, supp() );
    CPPUNIT_ASSERT_EQUAL( bn2->preferredChoicePointColor(), bn2->getColor() );    
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::save));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::unchanged, supp() );

    CPPUNIT_ASSERT_EQUAL( true, grp.recolorChoicePoint() );
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::succeeded, supp() );
    CPPUNIT_ASSERT_EQUAL( bn2->alternativeChoicePointColor(), bn2->getColor() );    
    CPPUNIT_ASSERT_EQUAL( hn3->preferredChoicePointColor(), hn3->getColor() );    
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::save));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::unchanged, supp() );

    CPPUNIT_ASSERT_EQUAL( true, grp.recolorChoicePoint() );
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::unchanged, supp() );

    CPPUNIT_ASSERT_EQUAL( true, grp.recolorChoicePoint() );
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));
    
    CPPUNIT_ASSERT_EQUAL( ColorOperation::succeeded, supp() );
    CPPUNIT_ASSERT_EQUAL( bn1->alternativeChoicePointColor(), bn1->getColor() );    
    CPPUNIT_ASSERT_EQUAL( hn1->preferredChoicePointColor(), hn1->getColor() );    
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::save));
    

    CPPUNIT_ASSERT_EQUAL( true, grp.recolorChoicePoint() );
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::succeeded, supp() );
    CPPUNIT_ASSERT_EQUAL( bn1->alternativeChoicePointColor(), bn1->getColor() );    
    CPPUNIT_ASSERT_EQUAL( hn1->alternativeChoicePointColor(), hn1->getColor() );    
    CPPUNIT_ASSERT_EQUAL( hn2->preferredChoicePointColor(), hn2->getColor() );    
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::save));
    
    CPPUNIT_ASSERT_EQUAL( true, grp.recolorChoicePoint() );
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));

    CPPUNIT_ASSERT_EQUAL( ColorOperation::unchanged, supp() );
    CPPUNIT_ASSERT_EQUAL( bn1->alternativeChoicePointColor(), bn1->getColor() );    
    CPPUNIT_ASSERT_EQUAL( hn1->alternativeChoicePointColor(), hn1->getColor() );    
    CPPUNIT_ASSERT_EQUAL( hn2->alternativeChoicePointColor(), hn2->getColor() );    
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::save));
    supp.handle(HeuristicValuesEvent(HeuristicValuesEvent::restore));
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(SelectSuccessorsTest);

} // end namespace NS_NOMORE_TESTS

