#ifndef TEST_COMMON_H
#define TEST_COMMON_H
#include <algorithm>
#include <heuristic.h>
#include <head_node.h>
#include <body_node.h>
namespace NS_NOMORE {

class Node;
class Graph;
class NoConstraint : public Constraint {
public:
  virtual bool isSatisfiedBy(const Node&) const {
    return true;
  }
  virtual bool supersedes(const Node& n1, const Node& n2) const {
    return true;
  }
  virtual Type getType() const {
    return Constraint::hybrid_constraint;
  }
};

struct OnlyBodies : public Constraint {
  bool isSatisfiedBy(const Node& n) const {
    return n.getType() == NodeType::body_node;
  }
  bool supersedes(const Node& n1, const Node& n2) const {
    return true;
  }
  virtual Type getType() const {
    return Constraint::uniform_constraint;
  }
};
struct OnlyHeads : public Constraint {
  bool isSatisfiedBy(const Node& n) const {
    return n.getType() == NodeType::head_node;
  }
  bool supersedes(const Node& n1, const Node& n2) const {
    return true;
  }
  virtual Type getType() const {
    return Constraint::uniform_constraint;
  }
};

class SuppConstraint : public Constraint {
public:
  virtual bool isSatisfiedBy(const Node& n) const {
    return true;
  }
  virtual bool supersedes(const Node& n1, const Node& n2) const {
    if(dynamic_cast<const HeadNode*>(&n2))
      return true;

    const BodyNode *bn2 = static_cast<const BodyNode*>(&n2);

    if(dynamic_cast<const HeadNode*>(&n1))
      return !bn2->isSupported();

    const BodyNode *bn1 = static_cast<const BodyNode*>(&n1);

    return bn1->isSupported() || !bn2->isSupported();
  }
  virtual Type getType() const {
    return Constraint::hybrid_constraint;
  }
};
  

}

//! Contains Tests for the NoMoRe++ library
namespace NS_NOMORE_TESTS {

template <class Cont>
inline bool findNode(const Cont& s, const NS_NOMORE::Node& b) {
  return std::find(s.begin(), s.end(), &b) != s.end();
}

template <class Iter>
inline bool findNode(Iter first, Iter last, const NS_NOMORE::Node& n) {
	return std::find(first, last, &n) != last;
}

}
#endif
