/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_PRINTER_H
#define NOMORE_PRINTER_H

namespace NS_NOMORE {

class Graph;

//! Base class for answer set printer.
/*! This abstract class declares an interface (the function-operator) for printing 
 *  an answer set. 
 *  Concrete subclasses implement this interface to print answer sets
 *  in a specific format to a specific output device.
 */
class Printer {
public:
  //! Constructs the printer.
  Printer();

  //! Destroys the printer.
  virtual ~Printer();

  //! interface for printing an answer set.
  /*! The answer set of the graph is the union of all plus colored head nodes (atoms)
   *  of the graph.
   *  \param nr The current number of the answer to print.
   *  \param grp The totally colored graph.
   *
   *  \pre The graph has been colored totally.
   */
  void operator()(int nr, const Graph& grp) {
    counter_ = nr;
    print(nr, grp);
  }
  int getNrOfFoundAS() const;
private:
  virtual void print(int nr, const Graph& g) = 0;
  Printer(const Printer&);
  Printer& operator=(const Printer&);
  int counter_;
};

}

#endif
