/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_MODE_WATCHER_H
#define NOMORE_MODE_WATCHER_H

#include <statistics/statistics_object.h>

namespace NS_NOMORE {

class Graph;
struct LookaheadExecution;
struct HeuristicExecution;

//! Interface for gathering statistic information about the current mode (lookahead, heuristics or normal mode).
class ModeWatcher : public StatisticsObject {
public:
  ModeWatcher(event::ChannelManager& m);

  //! Destroys the object
  virtual ~ModeWatcher();

  //! Register with the event handles.
  void registerWith(event::ChannelManager& m);

  //! Prints the result of the information-gathering.
  void print(std::ostream& os) const {}
  
  //! event handler for LookaheadExecution events for setting up currentMode_
  void handle(const LookaheadExecution& e);

  //! event handler for HeuristicExecution events for setting up currentMode_
  void handle(const HeuristicExecution& e);
};

}

#endif
