/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_STATISTICS_OBJECT_H
#define NOMORE_STATISTICS_OBJECT_H

#include <iosfwd>

namespace event {
  class ChannelManager;
}

namespace NS_NOMORE {

class Operator;

//! Interface for gathering statistic information about the answer set computation-process.
class StatisticsObject {
public:
  //! Mode in which the nomore++ system currently is.
  struct Mode {
    enum Value {
      normal,
      lookahead,
      heuristic
    };
  };

  StatisticsObject();

  //! Destroys the object
  virtual ~StatisticsObject();

  /*! Register with the event handles.
   *  Concrete subclasses implement this method in order to register 
   *  themselves as event handlers.
   */
  virtual void registerWith(event::ChannelManager& m) {}

  //! Prints the result of the information-gathering.
  virtual void print(std::ostream& os) const {}

  static void setCurrentMode(Mode::Value val) {
    currentMode_ = val;
  }

  static Mode::Value getCurrentMode() {
    return currentMode_;
  }

private:
  static Mode::Value currentMode_;
};

}

#endif
