/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <statistics/operator_call_statistics.h>
#include <ostream>

namespace NS_NOMORE {

OperatorCalls::OperatorCalls(event::ChannelManager& m) : StatisticsObject() {
}

void OperatorCalls::onOperatorStarted(const std::string& name) {
  if(StatisticsObject::getCurrentMode() == Mode::normal)
    ++operatorCounter_[name];
  else if(StatisticsObject::getCurrentMode() == Mode::lookahead)
    ++laOperatorCounter_[name];
  else
    ++heuOoperatorCounter_[name];
}

void OperatorCalls::print(std::ostream& os) const {
  
  OperatorMapIterator it = operatorCounter_.begin();
  OperatorMapIterator end = operatorCounter_.end();
  os << "Operator Calls\n";
  for(; it != end; ++it)
    os << it->first << ": " << it->second << "\n";

  it = laOperatorCounter_.begin();
  end = laOperatorCounter_.end();
  if(it != end) {
    os << "Operator Calls in Lookahead\n";
    for(; it != end; ++it)
      os << it->first << ": " << it->second << "\n";
  }

  it = heuOoperatorCounter_.begin();
  end = heuOoperatorCounter_.end();
  if(it != end) {
    os << "Operator Calls in Heuristic\n";
    for(; it != end; ++it)
      os << it->first << ": " << it->second << "\n";
  }
}

Operator* OperatorCalls::decorate(Operator* op) {
  return new InvocationDecorator(op, this);
}

}

