#ifndef TEST_COMMON_H
#define TEST_COMMON_H
#include <algorithm>
#include <heuristic.h>
#include <head_node.h>
#include <body_node.h>
namespace NS_NOMORE {

class Node;
class Graph;

}

//! Contains Tests for the NoMoRe++ library
namespace NS_NOMORE_TESTS {


class NoConstraint : public NS_NOMORE::Constraint {
public:
  virtual bool isSatisfiedBy(const NS_NOMORE::Node&) const {
    return true;
  }
  virtual bool supersedes(const NS_NOMORE::Node& n1, const NS_NOMORE::Node& n2) const {
    return true;
  }
  virtual Type getType() const {
    return NS_NOMORE::Constraint::hybrid_constraint;
  }
};

struct OnlyBodies : public NS_NOMORE::Constraint {
  bool isSatisfiedBy(const NS_NOMORE::Node& n) const {
    return n.getType() == NS_NOMORE::NodeType::body_node;
  }
  bool supersedes(const NS_NOMORE::Node& n1, const NS_NOMORE::Node& n2) const {
    return true;
  }
  virtual Type getType() const {
    return NS_NOMORE::Constraint::uniform_constraint;
  }
};
struct OnlyHeads : public NS_NOMORE::Constraint {
  bool isSatisfiedBy(const NS_NOMORE::Node& n) const {
    return n.getType() == NS_NOMORE::NodeType::head_node;
  }
  bool supersedes(const NS_NOMORE::Node& n1, const NS_NOMORE::Node& n2) const {
    return true;
  }
  virtual Type getType() const {
    return NS_NOMORE::Constraint::uniform_constraint;
  }
};

class SuppConstraint : public NS_NOMORE::Constraint {
public:
  virtual bool isSatisfiedBy(const NS_NOMORE::Node& n) const {
    return true;
  }
  virtual bool supersedes(const NS_NOMORE::Node& n1, const NS_NOMORE::Node& n2) const {
    if(dynamic_cast<const NS_NOMORE::HeadNode*>(&n2))
      return true;

    const NS_NOMORE::BodyNode *bn2 = static_cast<const NS_NOMORE::BodyNode*>(&n2);

    if(dynamic_cast<const NS_NOMORE::HeadNode*>(&n1))
      return !bn2->isSupported();

    const NS_NOMORE::BodyNode *bn1 = static_cast<const NS_NOMORE::BodyNode*>(&n1);

    return bn1->isSupported() || !bn2->isSupported();
  }
  virtual Type getType() const {
    return NS_NOMORE::Constraint::hybrid_constraint;
  }
};
  

template <class Cont>
inline bool findNode(const Cont& s, const NS_NOMORE::Node& b) {
  return std::find(s.begin(), s.end(), &b) != s.end();
}

template <class Iter>
inline bool findNode(Iter first, Iter last, const NS_NOMORE::Node& n) {
	return std::find(first, last, &n) != last;
}

}
#endif
