/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef LIBNOMORE_BODY_LOOKAHEAD_HEURISTIC_H
#define LIBNOMORE_BODY_LOOKAHEAD_HEURISTIC_H

#include <operators/body_lookahead.h>
#include <lookahead_heuristic.h>

namespace NS_NOMORE {

//! Heuristic strategy that compares nodes rated by the BodyLookahead operator.
/*! 
 *  The operator BodyLookahead generates values containing two counters called 
 *  max and min for some body nodes. The node with the greatest max values is 
 *  "better". If both max values are equal the min value is checked.
 *  
 *  \note If you want to use this strategy make sure that you also use the 
 *        BodyLookahead operator. If the operator is not used no choice point 
 *        can be found and the solver does not compute valid answer sets.
 *
 *  \see BodyLookaheadHeuristic */
class BodyLookaheadHeuristicStrat {
public:
  //! Type of the base for the heuristic.
  typedef BodyLAHeuristicBase BaseType;

  //! The value type of the heuristic.
  typedef BodyLAHeuristicBase::HeuristicValueType ValueType;

  //! The comparator type of the heuristic.
  typedef std::greater<ValueType> ComparatorType;
};

//! Type definition of the body lookahead strategy BodyLookaheadHeuristicStrat.
typedef LookaheadHeuristic<BodyLookaheadHeuristicStrat> BodyLookaheadHeuristic;

}
#endif
