/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef LIBNOMORE_NEIGHBORHOOD_HEURISTIC_H
#define LIBNOMORE_NEIGHBORHOOD_HEURISTIC_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <heuristic.h>
#include <propagator.h>
#include <util/overlay_list.h>

#include <utility>

namespace NS_NOMORE {

struct HeadNodeColored;
struct BodyNodeColored;

//! Dynamic heuristic stategy searching the neighborhood of current assignment.
/*! 
 *  The stategy propagates locally to the current assignment and counts the 
 *  colored nodes like the lookahead operator but only with a fixed search 
 *  depth set in constructor. If any conflict is found the heuristic returns 
 *  the conflicting nodes as "best" Choice. If no conflict is found the 
 *  strategy returns the node which decides the greatest number of nodes. 
 *
 *  \note This strategy can be used with head and body nodes. 
 *  \note This strategy is only as dynamic heuristic useful. */
class Neighborhood : public Heuristic {
public:
  //! The type of the heuristic value like the lookahead heuristics.
  typedef std::pair<int, int> ValueType;
  
  //! Creates a new Neighborhood object.
  /*! 
   *  \param maxDepth Set the maximal depth of propagations. Default is 3. */
  explicit Neighborhood(int maxDepth = 3);
    
  //! Cleans up the heuristic.
  ~Neighborhood();

  //! Sets the propagator for simple local propagation.
  /*!
   *  \param op The propagator object used to find the best dynamic heuristic 
   *            values. */
  void setPropagator(Propagator& op);

  //! Resets the maximal depth of propagations.
  /*! 
   *  \param maxDepth Set the maximal depth of propagations. Default is 3. */
  void setMaxDepth(int m);

  //! Event handler for the HeadNodeColored event.
  /*!
   *  \param e The raised event. */
  void handle(const HeadNodeColored&);

  //! Event handler for the BodyNodeColored event.
  /*!
   *  \param e The raised event. */
  void handle(const BodyNodeColored&);

  //! Returns the name of the heuristic.
  /*!
   *  \return Returns the name of the heuristics used for example for the 
   *          user interface. */
  const char* getName() const;

private:
  // instance methods
  Choice doSelectNode(const Constraint& c);
  Choice getBestChoice(Constraint::Type t) const;
  bool propagate(Node* n, Constraint::Type t);
  void doSetGraph();  
  void evaluate(Node* n, ValueType vt);
  void registerEventHandlers();
  void unregisterEventHandlers();  
  
  // instance variables
  int max_;  
  int currentValue_;
  bool lastStep_;

  std::pair<Node*, ValueType> bestNode_;
  Propagator* propagator_;
  StaticOverlayList overlayList_;  
};

}
#endif
