/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_MODE_WATCHER_H
#define NOMORE_MODE_WATCHER_H

#include <statistics/statistics_object.h>

namespace NS_NOMORE {

class Graph;
struct LookaheadExecution;
struct HeuristicExecution;

//! Observes changes in the computation mode during answer set solving.
/*! 
 *  A ModeWatcher observers the solving-process for changes in the computation 
 *  mode (e.g. Lookahead, Heuristic) and stores the current computation mode 
 *  in the base class.
 */
class ModeWatcher : public StatisticsObject {
public:
  //! Constructor sets the member variables.
  /*! 
   *  \param m The Channel manager that manages all event channels used by 
   *           one graph. */
  explicit ModeWatcher(event::ChannelManager& m);

  //! Clean ups the mode watcher object.
  virtual ~ModeWatcher();

  //! Event handler for LookaheadExecution events .
  /*!
	 *  Stores the current LookaheadExecution-State in the base class.
   * \param e The raised event. */
  void handle(const LookaheadExecution& e);

  //! Event handler for HeuristicExecution events
  /*!
   *  Stores the current HeuristicExecution-State in the base class.
	 *  \param e The raised event. */
  void handle(const HeuristicExecution& e);

private:
  // instance methods
  void registerWith(event::ChannelManager& m);
};

}

#endif
