#include "graph_test.h"
#include <graph.h>
#include <head_node.h>
#include <body_node.h>
using namespace NS_NOMORE;
using namespace std;

namespace NS_NOMORE_TESTS {

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( GraphTest );

void GraphTest::setUp() {
  graph = new Graph();
}

void GraphTest::tearDown() {
  delete graph;
}

void GraphTest::testEmpty() {
	
	CPPUNIT_ASSERT_EQUAL( size_t(0), graph->countNodes() );
	CPPUNIT_ASSERT_EQUAL( size_t(0), graph->countUncoloredNodes() );
}

void GraphTest::testInsertBodyNode() {
  
  
  BodyNode* bodynode1 = graph->insertBodyNode();
  
  CPPUNIT_ASSERT_EQUAL( bodynode1,      *graph->bodyNodesBegin() );
  CPPUNIT_ASSERT_EQUAL( size_t(1), graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( size_t(1), graph->countUncoloredNodes());

  BodyNode* bodynode2 = graph->insertBodyNode();

  Graph::BodyNodeIterator it = graph->bodyNodesBegin();
  ++it;
  CPPUNIT_ASSERT_EQUAL( bodynode2,      *it );
  CPPUNIT_ASSERT_EQUAL( size_t(2), graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( size_t(2), graph->countUncoloredNodes());
  
}

void GraphTest::testInsertHeadNode() {
  
  
  HeadNode* headnode1 = graph->insertHeadNode(1);
  CPPUNIT_ASSERT_EQUAL( headnode1,      *graph->headNodesBegin() );
  CPPUNIT_ASSERT_EQUAL( size_t(1), graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( size_t(1), graph->countUncoloredNodes());

  HeadNode* headnode2 = graph->insertHeadNode(2);
  Graph::HeadNodeIterator it = graph->headNodesBegin();
  ++it;
  CPPUNIT_ASSERT_EQUAL( headnode2,      *it );
  CPPUNIT_ASSERT_EQUAL( size_t(2), graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( size_t(2), graph->countUncoloredNodes());

  // reinsert -> Graph prft nicht, ob Atom bereits existiert!
  HeadNode* headnode3 = graph->insertHeadNode(1);	
  CPPUNIT_ASSERT_EQUAL( 3u, graph->countNodes());
  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes());
  CPPUNIT_ASSERT(headnode3 != headnode1);
}

void GraphTest::testSetColor() {
  
  /* 
     (1) none -> weak_plus
     (2) none -> plus
     (3) none -> minus
     (4) weak_plus -> plus
  */

  
  HeadNode* headnode1 = graph->insertHeadNode(1);
  HeadNode* headnode2 = graph->insertHeadNode(2);
  BodyNode* bodynode3 = graph->insertBodyNode();
  BodyNode* bodynode4 = graph->insertBodyNode();
  BodyNode* bodynode5 = graph->insertBodyNode();
  BodyNode* bodynode6 = graph->insertBodyNode();
  BodyNode* bodynode7 = graph->insertBodyNode();
  BodyNode* bodynode8 = graph->insertBodyNode();
  
  CPPUNIT_ASSERT_EQUAL( 8u, graph->countUncoloredNodes() );
  
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*headnode2, Color::weak_plus) );

  CPPUNIT_ASSERT_EQUAL( 8u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode3, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 7u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode4, Color::minus) );

  CPPUNIT_ASSERT_EQUAL( 6u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode5, Color::weak_plus) );

  CPPUNIT_ASSERT_EQUAL( 6u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode6, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 5u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode7, Color::minus) );

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode8, Color::weak_plus) );

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode8->getColor() );

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode8, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none, headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus, bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus, bodynode8->getColor() );

}

void GraphTest::testRestoreColor() {
  
  /* 
     (1) none <- weak_plus
     (2) none <- plus
     (3) none <- minus
     (4) weak_plus <-> plus
  */

  
  HeadNode* headnode1 = graph->insertHeadNode(1);
  HeadNode* headnode2 = graph->insertHeadNode(2);
  BodyNode* bodynode3 = graph->insertBodyNode();
  BodyNode* bodynode4 = graph->insertBodyNode();
  BodyNode* bodynode5 = graph->insertBodyNode();
  BodyNode* bodynode6 = graph->insertBodyNode();
  BodyNode* bodynode7 = graph->insertBodyNode();
  BodyNode* bodynode8 = graph->insertBodyNode();
  

  CPPUNIT_ASSERT_EQUAL( true, graph->color(*headnode2, Color::weak_plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode3, Color::plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode4, Color::minus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode5, Color::weak_plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode6, Color::plus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode7, Color::minus) );
  CPPUNIT_ASSERT_EQUAL( true, graph->color(*bodynode8, Color::plus) );

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none   , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*headnode2, Color::none);

  CPPUNIT_ASSERT_EQUAL( 3u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode3, Color::none);

  CPPUNIT_ASSERT_EQUAL( 4u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode4, Color::none);

  CPPUNIT_ASSERT_EQUAL( 5u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus    , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus     , bodynode8->getColor() );

  graph->restore(*bodynode8, Color::weak_plus);

  CPPUNIT_ASSERT_EQUAL( 6u, graph->countUncoloredNodes() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode1->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , headnode2->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode3->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::none     , bodynode4->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus   , bodynode5->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::plus   , bodynode6->getColor() );  
  CPPUNIT_ASSERT_EQUAL( Color::minus   , bodynode7->getColor() );
  CPPUNIT_ASSERT_EQUAL( Color::weak_plus, bodynode8->getColor() );
}

void GraphTest::testClear() {
	graph->insertBodyNode();
	graph->insertHeadNode(1);
	graph->clear();
	CPPUNIT_ASSERT(graph->headNodesBegin() == graph->headNodesEnd());
	CPPUNIT_ASSERT(graph->bodyNodesBegin() == graph->bodyNodesEnd());
  CPPUNIT_ASSERT_EQUAL(size_t(0), graph->countUncoloredNodes());

}

void GraphTest::testNumbering() {
  const long maxNodes = 4;
  Node* nodes[maxNodes] = {0};
  nodes[0] = graph->insertBodyNode();
  nodes[1] = graph->insertHeadNode(1);
  nodes[2] = graph->insertHeadNode(7);
  nodes[3] = graph->insertBodyNode();

  for (long i = 0; i != maxNodes; ++i) {
    CPPUNIT_ASSERT_EQUAL(i, nodes[i]->getId());
  }
}

} // NS_NOMORE_TESTS
