 /***************************************************************************
                          algorithm.cpp  -  description
                             -------------------
    begin                : Tue Aug 5 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include "print.h"
#include "algorithm.h"
//#include "cnode.h"
//#include "crule.h"
#include "misc.h"
//#include "print.h"
#include "cdetoperator.h"
#include "cndoperator.h"
#include "caggregation.h"
#include "cgraph.h"

using namespace std;
namespace NS_NOMORE{



/**********************************************************************************************************
  function ColorGraph
**********************************************************************************************************/
bool ColorGraph(CGraph* graph, string op, int as_count, bool todo, bool prefs){
  CDetOperator* det_operator;
  CDetOperator* pre_operator;
  CNdOperator* ndet_operator;
  CDetOperator* end_operator;

  if(!GenerateOperator(op, det_operator, pre_operator, ndet_operator, end_operator, todo, prefs)){
		PRINT_ERROR(std::cerr << "trying to generate operator failed" << std::endl);
		return false;
  }

  {
		TStack stack;
		pre_operator->Call(graph,&stack);
	}

  TSetOfAtomSets as;
  ndet_operator->Call(det_operator, end_operator, graph, as_count, &as);
  std::cout << "No" << std::endl;
  return true;
}


/*********************************************************************************************
  Generic stuff
*********************************************************************************************/


/*! Generates from the input an operator */
CDetOperator* CreateDetOperator(string op, bool todo, bool prefs){
  if (prefs) {
    if (todo) {
    	if(op == "P")	return (CDetOperator*)(new CDetOperatorPPref());
    	if(op == "Ps")	return (CDetOperator*)(new CDetOperatorPsPref());
    	if(op == "Psl")	return (CDetOperator*)(new CDetOperatorPslPref());
    	if(op == "U")	return (CDetOperator*)(new CDetOperatorUPref());
//    	if(op == "V")	return (CDetOperator*)(new CDetOperatorVPref());
    	if(op == "None")	return (CDetOperator*)(new CDetOperatorNone());
    } else {
    	if(op == "P")	return (CDetOperator*)(new CDetOperatorPPref());
    	if(op == "Ps")	return (CDetOperator*)(new CDetOperatorPsPref());
    	if(op == "Psl")	return (CDetOperator*)(new CDetOperatorPslPref());
    	if(op == "U")	return (CDetOperator*)(new CDetOperatorUPref());
//    	if(op == "V")	return (CDetOperator*)(new CDetOperatorV());
    	if(op == "None")	return (CDetOperator*)(new CDetOperatorNone());
    }
  } else {
    if (todo) {
    	if(op == "P")	return (CDetOperator*)(new CDetOperatorP());
    	if(op == "Ps")	return (CDetOperator*)(new CDetOperatorPs());
    	if(op == "Psl")	return (CDetOperator*)(new CDetOperatorPsl());
    	if(op == "U")	return (CDetOperator*)(new CDetOperatorU());
    	if(op == "V")	return (CDetOperator*)(new CDetOperatorV());
    	if(op == "None")	return (CDetOperator*)(new CDetOperatorNone());
    } else {
    	if(op == "P")	return (CDetOperator*)(new CDetOperatorP());
    	if(op == "Ps")	return (CDetOperator*)(new CDetOperatorPs());
    	if(op == "Psl")	return (CDetOperator*)(new CDetOperatorPsl());
    	if(op == "U")	return (CDetOperator*)(new CDetOperatorU());
    	if(op == "V")	return (CDetOperator*)(new CDetOperatorV());
    	if(op == "None")	return (CDetOperator*)(new CDetOperatorNone());
    }
  }
  return NULL;
}

/*! Generates from the input an operator */
CDetOperator* CreatePreOperator(string op, bool todo, bool prefs){
  if (prefs) {
    if (todo) {
      if(op == "Pre") return (CDetOperator*)(new CDetOperatorPrePref());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    } else {
      if(op == "Pre")	return (CDetOperator*)(new CDetOperatorPrePref());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    }
  } else {
    if (todo) {
      if(op == "Pre") return (CDetOperator*)(new CDetOperatorPre());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    } else {
      if(op == "Pre")	return (CDetOperator*)(new CDetOperatorPre());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    }
  }
  return NULL;
}

/*! Generates from the input an operator */
CDetOperator* CreateEndOperator(string op, bool todo, bool prefs){
  if (prefs) {
    if (todo) {
      if(op == "N") return (CDetOperator*)(new CDetOperatorN());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    } else {
      if(op == "N") return (CDetOperator*)(new CDetOperatorN());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    }
  } else {
    if (todo) {
      if(op == "N") return (CDetOperator*)(new CDetOperatorN());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    } else {
      if(op == "N") return (CDetOperator*)(new CDetOperatorN());
      if(op == "None") return (CDetOperator*)(new CDetOperatorNone());
    }
  }
  return NULL;
}

/*! Generates from the input an non-det. operator */
CNdOperator* CreateNdOperator(string op, bool todo, bool prefs){
  if (prefs) {
    if (todo) {
//    	if(op == "D") return (CNdOperator*)(new CNdOperatorDPref());
//    	if(op == "D2") return (CNdOperator*)(new CNdOperatorD2Pref());
    	if(op == "D") return (CNdOperator*)(new CNdOperatorD2Pref());
    	if(op == "DH") return (CNdOperator*)(new CNdOperatorDHPref());
    } else {
    }
  } else {
    if (todo) {
      if(op == "C") return (CNdOperator*)(new CNdOperatorCtodo());
      if(op == "C1") return (CNdOperator*)(new CNdOperatorC1todo());
      if(op == "D") return (CNdOperator*)(new CNdOperatorDtodo());
      if(op == "D2") return (CNdOperator*)(new CNdOperatorD2todo());
    } else {
      if(op == "C") return (CNdOperator*)(new CNdOperatorC());
    	if(op == "C1") return (CNdOperator*)(new CNdOperatorC1());
    	if(op == "D") return (CNdOperator*)(new CNdOperatorD());
    }
  }
  return NULL;
}

/*! Generates the aggregation tree out of the input string*/
bool GenerateOperator(string op, CDetOperator*& out, bool todo, bool prefs) {

  int len = op.size();
  int i, counter, pos;
  CDetOperator *o = NULL;
  CDetOperator *o2 = NULL;
  string buffer1;
  string buffer2;

  if(len == 0){
    out = NULL;
    return false;
  }
  // only single operator like P

  if(-1 == (signed int)op.find(",") &&
     -1 == (signed int)op.find("(") &&
     -1 == (signed int)op.find("*")) {

    out = CreateDetOperator(op,todo,prefs);

    if(out == NULL)
      return false;
    else
      return true;

  } else {
    if(op[0] == '('){
      // find corresponding ')'
      counter = 1;
      for(i=1;i!=len;i++){
        if(op[i] == '(') counter++;else
        if(op[i] == ')') counter--;
        if(counter == 0)
          break;
      }

      buffer1 = op.substr(1, i-1);
      pos = i;
    } else {
      for(i=1;i!=len;i++){
      	if(op[i] == ',' ||
           op[i] == '(' ||
           op[i] == ')' ||
           op[i] == '*')
          break;
      }

      buffer1 = op.substr(0, i);
      pos = i-1;
    }

    // only *-operator at the end of the char-list
    if(pos+2 == len && op[pos+1] == '*'){

      if(!GenerateOperator(buffer1, o, todo, prefs)){
        out = NULL;
        return false;
      }

      out = (CDetOperator*)(new CAggregationStar());
      ((CAggregation*)out)->SetFirst(o);

      return true;
    } else
    if(op[pos+1] == ','){
    	buffer2 = op.substr(pos+2, len);

      if(!GenerateOperator(buffer1, o, todo, prefs)){
        out = NULL;
        return false;
      }

      if(!GenerateOperator(buffer2, o2, todo, prefs)){
        delete o;
        out = NULL;
        return false;
      }

      out = (CDetOperator*)(new CAggregationSequence());
      ((CAggregation*)out)->SetFirst(o);
      ((CAggregation*)out)->SetSecond(o2);

      return true;
    } else
    if(pos+1 == len){
      // only delete of (...)
      return GenerateOperator(buffer1, out, todo, prefs);
    } else
    if(op[pos+1] == '*' && op[pos+2] == ','){

    	string b = buffer1;
      buffer1 = "(";
      buffer1 += b;
      buffer1 += ")*";

      pos++;

			buffer2 = op.substr(pos+2, len);

      if(!GenerateOperator(buffer1, o, todo, prefs)){
        out = NULL;
        return false;
      }

      if(!GenerateOperator(buffer2, o2, todo, prefs)){
        delete o;
        out = NULL;
        return false;
      }

      out = (CDetOperator*)(new CAggregationSequence());
      ((CAggregation*)out)->SetFirst(o);
      ((CAggregation*)out)->SetSecond(o2);

      return true;
    }
  }

  out = NULL;
  return false;
}

bool Extract(string in, string& op, string& rest){
	unsigned int pos = in.find(":");

	if(pos >= in.size())
		return false;

  op = in.substr(0, pos);
  rest = in.substr(pos+1, in.size());

	return true;
}

bool GenerateOperator(string op, CDetOperator*& det_out, CDetOperator*& pre_out,
                      CNdOperator*& ndet_out, CDetOperator*& end_out, bool todo, bool prefs) {

  det_out = NULL;
  pre_out = NULL;
  ndet_out = NULL;
  end_out = NULL;

  string str_det;
  string str_ndet;
  string str_pre;
  string str_end;

  Extract(op, str_pre, op);
  Extract(op, str_ndet, op);
  Extract(op, str_det, str_end);

  pre_out = CreatePreOperator(str_pre, todo, prefs);
  if(pre_out == NULL)
    return false;

  ndet_out = CreateNdOperator(str_ndet, todo, prefs);
  if(ndet_out == NULL){
  	delete pre_out;
  	pre_out = NULL;
    return false;
  }

  if(!GenerateOperator(str_det, det_out, todo, prefs)){
  	delete pre_out;
  	pre_out = NULL;
  	delete ndet_out;
  	ndet_out = NULL;
    return false;
  }

  end_out = CreateEndOperator(str_end, todo, prefs);
  if(end_out == NULL){
  	delete pre_out;
  	pre_out = NULL;
  	delete ndet_out;
  	ndet_out = NULL;
  	delete det_out;
  	det_out = NULL;
    return false;
  }

  pre_out->SetIsTodo(todo);

  bool b = false;

  b |= pre_out->Conflict(ndet_out->GetType());
  b |= pre_out->Conflict(end_out->GetType());
  b |= ndet_out->Conflict(pre_out->GetType());
  b |= ndet_out->Conflict(end_out->GetType());
  b |= det_out->Conflict(ndet_out->GetType());
  b |= det_out->Conflict(pre_out->GetType());
  b |= det_out->Conflict(end_out->GetType());
  b |= end_out->Conflict(ndet_out->GetType());
  b |= end_out->Conflict(pre_out->GetType());

  if(b) {
    delete pre_out;
    delete ndet_out;
    delete det_out;
    delete end_out;
    pre_out = NULL;
    ndet_out = NULL;
    det_out = NULL;
    end_out = NULL;

    return false;
  }

  return true;
}


}
