/***************************************************************************
                          caggregation.cpp  -  description
                             -------------------
    begin                : Wed Sep 1 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "caggregation.h"
#include "print.h"

using std::cerr;
using std::endl;

namespace NS_NOMORE{

/**********************************************************************************************************
  class CAggregation
**********************************************************************************************************/
CAggregation::CAggregation() : CDetOperator() {
  CREATEOBJECT("CAggregation");

  _first_operator = NULL;
  _second_operator = NULL;
}

CAggregation::~CAggregation(){
  DELETEOBJECT("CAggregation");

  if(_first_operator != NULL)
    delete _first_operator;

  if(_second_operator != NULL)
    delete _second_operator;

  _first_operator = NULL;
  _second_operator = NULL;
}

void CAggregation::SetFirst(CDetOperator *op){
	CHECK_POINTER("CAggregation::SetFirst()", op);

  if(_first_operator != NULL)
    delete _first_operator;

  _first_operator = op;
}

void CAggregation::SetSecond(CDetOperator *op){
	CHECK_POINTER("CAggregation::SetSecond()", op);

  if(_second_operator != NULL)
    delete _second_operator;

  _second_operator = op;
}


/**********************************************************************************************************
  class CAggregationStar
**********************************************************************************************************/
CAggregationStar::CAggregationStar() : CAggregation() {
  CREATEOBJECT("CAggregationStar");
}

CAggregationStar::~CAggregationStar(){
  DELETEOBJECT("CAggregationStar");
}

TRetOperator CAggregationStar::Call(CGraph* graph, TStack* stack){
	CHECK_POINTER("CAggregationStar::Call()", graph);
	CHECK_POINTER("CAggregationStar::Call()", stack);

  if(GetFirst() == NULL)
    return return_unchanged;

  // if (()*)* only compute one star
  if(GetFirst()->GetType() == type_caggregation_star)
    return GetFirst()->Call(graph, stack);

  TRetOperator ret;
  int loop = 0;
  while(return_changed == (ret = GetFirst()->Call(graph, stack))) loop++;

  if(loop > 0 && ret != return_colorerror)
    return return_changed;
  else
    return ret;
}

bool CAggregationStar::operator==(CDetOperator& op){
  if(op.GetType() != GetType())
    return false;

  if(GetFirst() == NULL){
    if(((CAggregation*)&op)->GetFirst() == NULL)
      return true;
    else
      return false;
  }

  if(((CAggregation*)&op)->GetFirst() == NULL)
    return false;


  return (GetFirst()->operator==(*((CAggregation*)&op)->GetFirst()));
}

bool CAggregationStar::operator!=(CDetOperator& op){
  return !(this->operator==(op));
}

bool CAggregationStar::Conflict(TType op){
  if(GetFirst() == NULL)
    return false;

  return GetFirst()->Conflict(op);
}


/**********************************************************************************************************
  class CAggregationSequence
**********************************************************************************************************/
CAggregationSequence::CAggregationSequence() : CAggregation() {
  CREATEOBJECT("CAggregationSequence");
}

CAggregationSequence::~CAggregationSequence(){
  DELETEOBJECT("CAggregationSequence");
}

TRetOperator CAggregationSequence::Call(CGraph* graph, TStack* stack){
	CHECK_POINTER("CAggregationSequence::Call()", graph);
	CHECK_POINTER("CAggregationSequence::Call()", stack);

  TRetOperator ret = return_unchanged;
  if(GetFirst() != NULL){
    ret = GetFirst()->Call(graph, stack);
    if(ret == return_colorerror)
      return ret;
  }

  TRetOperator ret2 = return_unchanged;
  if(GetSecond() != NULL){
    ret2 = GetSecond()->Call(graph, stack);
    if(ret2 == return_colorerror)
      return ret2;
  }

  if((ret == return_changed) || (ret2 == return_changed))
    return return_changed;
  else
    return return_unchanged;
}

bool CAggregationSequence::operator==(CDetOperator& agg){
  if(agg.GetType() != GetType())
    return false;

  int x = 0;

  if(GetFirst() == NULL && ((CAggregation*)&agg)->GetFirst() == NULL)
    x++;
  else
  if(GetFirst() != NULL && ((CAggregation*)&agg)->GetFirst() != NULL && GetFirst()->operator==(*((CAggregation*)&agg)->GetFirst()))
    x++;

  if(GetSecond() == NULL && ((CAggregation*)&agg)->GetSecond() == NULL)
    x++;
  else
  if(GetSecond() != NULL && ((CAggregation*)&agg)->GetSecond() != NULL && GetSecond()->operator==(*((CAggregation*)&agg)->GetSecond()))
    x++;

  return x == 2;
}

bool CAggregationSequence::operator!=(CDetOperator& agg){
  return !(this->operator==(agg));
}

bool CAggregationSequence::Conflict(TType op){
  if(GetFirst() == NULL){
    if(GetSecond() == NULL)
      return false;
    else
      return GetSecond()->Conflict(op);
  } else
  if(GetSecond() == NULL)
    return GetFirst()->Conflict(op);

  return GetFirst()->Conflict(op) || GetSecond()->Conflict(op);
}

}
