/***************************************************************************
                          caggregation.h  -  description
                             -------------------
    begin                : Wed Sep 1 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file caggregation.h
		Declaration of class CAggregation, CAggregationStar and CAggregationSequence
*/

#ifndef CAGGREGATION_H
#define CAGGREGATION_H

#include "cdetoperator.h"

namespace NS_NOMORE {

/*! \class CAggregation caggregation.h
		\brief Interface for defining aggregations like * or sequence.

		CAggregation is the base class for all aggregations.
*/
class CAggregation : public CDetOperator {
private:
  CDetOperator*  _first_operator;//!< pointer to the first operator in sequence, etc.
  CDetOperator*  _second_operator;//!< pointer to the second operator in sequence, etc.

public:
  //! constructor
	CAggregation();

  //! destructor
	virtual ~CAggregation();

  //! sets the first operator for the aggregation
  /*! \param op Operator or aggregation used for star-operator or for the first element of the sequence-operator*/
  void SetFirst(CDetOperator *op);

  //! sets the second operator for the aggregation
  /*! \param op Operator or aggregation used for the second element of the sequence-operator*/
  void SetSecond(CDetOperator *op);

  //! returns the first operator
  inline CDetOperator* GetFirst(){
    return _first_operator;
  }

  //! returns the second operator
  inline CDetOperator* GetSecond(){
    return _second_operator;
  }

  //! Colors a node.
  virtual bool ColorNode(CGraph* graph, CNode *node, TColor color, TStack *stack,
                         bool choice_point, TColor choice_color) {
    return false;
  }

  //! Equality operator work on operator ids
  virtual bool operator==(CDetOperator& op) = 0;

  //! Inequality operator work on operator ids
  virtual bool operator!=(CDetOperator& op) = 0;
};

/*! \class CAggregationStar caggregation.h
		\brief Aggregation for computing the closure operator.

		CAggregationStar is an aggregation and an operator for calling an operator until the coloring
    doesn't change.
*/
class CAggregationStar : public CAggregation {
public:
  //! constructor
  CAggregationStar();

  //! destructor
  virtual ~CAggregationStar();

  //! start the operator by starting the first operator until it returns return_unchanged or an error occured the computation
  /*! \param graph Graph on which the computation started
      \param stack Stack to which the changes are stored
      \return if nothing has been changed the methode return return_unchanged, else return_changed. If an error
              occured the computation the methode returns return_colorerror */
  virtual TRetOperator Call(CGraph* graph, TStack* stack);

  //! returns an operator specific id which is used for testing of equality
  virtual TType GetType() {
    return type_caggregation_star;
  }

  //! Equality operator work on operator ids
  virtual bool operator==(CDetOperator& op);

  //! Inequality operator work on operator ids
  virtual bool operator!=(CDetOperator& op);

  //! Returns true if the input operator id is in conflict with actual operator
  virtual bool Conflict(TType op);
};

/*! \class CAggregationSequence caggregation.h
		\brief Aggregation for computing the sequences of operators.

		CAggregationSequence is an aggregation and an operator for calling sequences of operators.
*/
class CAggregationSequence : public CAggregation {
public:
  //! constructor
  CAggregationSequence();

  //! destructor
  virtual ~CAggregationSequence();

  //! start the operator by starting the first operator and then the second operator
  /*! \param graph Graph on which the computation started
      \param stack Stack to which the changes are stored
      \return if nothing has been changed the methode return return_unchanged, else return_changed. If an error
              occured the computation the methode returns return_colorerror */
  virtual TRetOperator Call(CGraph* graph, TStack* stack);

  //! returns an operator specific id which is used for testing of equality
  virtual TType GetType() {
    return type_caggregation_sequence;
  }

  //! Equality operator work on operator ids
  virtual bool operator==(CDetOperator& agg);

  //! Inequality operator work on operator ids
  virtual bool operator!=(CDetOperator& agg);

  //! Returns true if the input operator id is in conflict with actual operator
  virtual bool Conflict(TType op);
};

}

#endif
