/***************************************************************************
                          cdetoperator.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include <iostream>
//#include <stdio.h>
//#include "caggregation.h"
#include "cdetoperator.h"
//#include "coperatorpref.h"
//#include "algorithmpref.h"
#include "cnodepref.h"
//#include "print.h"
//#include "misc.h"
//#include "algorithm.h"
//#include "io.h"

using namespace std;
namespace NS_NOMORE{

/**********************************************************************************************************
  class CDetOperator
**********************************************************************************************************/
CDetOperator::CDetOperator() : COperator() {
  CREATEOBJECT("CDetOperator");
}


CDetOperator::~CDetOperator(){
  DELETEOBJECT("CDetOperator");
}

bool CDetOperator::operator==(CDetOperator& op){
	return GetType() == op.GetType();
}

bool CDetOperator::operator!=(CDetOperator& op){
	return GetType() != op.GetType();
}

/**********************************************************************************************************
  class COperatorCN
**********************************************************************************************************/
/*bool COperatorCN::ColorNode(CGraph* graph, CNode *node, TColor color, TStack *stack,
                            bool choice_point, TColor choice_color){
  CHECK_POINTER("COperatorCN::ColorNode()", graph);
  return graph->ColorNode(node, color, stack, choice_point, choice_color);
}

bool COperatorCN::Conflict(TType op){
  switch(op) {
  case type_coperator_p : return false;
  case type_coperator_u : return false;
  case type_coperator_v : return false;
  case type_coperator_n : return false;
  case type_coperator_c : return false;
  case type_coperator_c1 : return false;
  case type_coperator_d : return false;
  case type_coperator_pre : return false;
  case type_cdetoperator_none : return false;
  case type_caggregation_star : return false;
  case type_caggregation_sequence : return false;
  default: return true;
  }
}*/

/**********************************************************************************************************
  class COperatorCNtodo
**********************************************************************************************************/
/*bool COperatorCNtodo::ColorNode(CGraph* graph, CNode *node, TColor color, TStack *stack,
                            bool choice_point, TColor choice_color){
  CHECK_POINTER("COperatorCNtodo::ColorNode()", graph);
  if(!graph->ColorNode(node, color, stack, choice_point, choice_color))
    return false;

	if ((color != color_none) && (color != color_was_plus)) {
	  InsertTodo(node->GetZeroSuccessors());
		InsertTodo(node->GetOneSuccessors());
//		InsertTodo(((CNodePref*)node)->GetTwoSuccessors());
		CNodePref* n=dynamic_cast<CNodePref*>(node);
		if (n!=NULL)
			InsertTodo(n->GetTwoSuccessors());
  }
  return true;
}

bool COperatorCNtodo::Conflict(TType op){
  switch(op) {
  case type_coperator_ptodo : return false;
  case type_coperator_pstodo : return false;
  case type_coperator_utodo : return false;
  case type_coperator_ntodo : return false;
  case type_coperator_vtodo : return false;
  case type_coperator_ctodo : return false;
  case type_coperator_c1todo : return false;
  case type_coperator_dtodo : return false;
  case type_coperator_d2todo : return false;
  case type_coperator_pretodo : return false;
  case type_coperator_prepreftodo : return false;
  case type_cdetoperator_none : return false;
  case type_caggregation_star : return false;
  case type_caggregation_sequence : return false;
  case type_coperator_dpreftodo : return false;
  case type_coperator_ppreftodo : return false;
  case type_coperator_pspreftodo : return false;
  case type_coperator_upreftodo : return false;
  case type_coperator_dprefhtodo : return false;
  default: return true;
  }
}*/

/**********************************************************************************************************
  class CDetOperatorNone
**********************************************************************************************************/
CDetOperatorNone::CDetOperatorNone() : CDetOperator() {
}

CDetOperatorNone::~CDetOperatorNone() {
}

TRetOperator CDetOperatorNone::Call(CGraph* graph, TStack* stack) {
  return return_unchanged;
}

TType CDetOperatorNone::GetType() {
  return (IsTodo() ? type_cdetoperator_nonetodo : type_cdetoperator_none);
}


/*bool CDetOperatorNone::Conflict(TType op){
	return false;
} */

/**********************************************************************************************************
  CDetOperatorP
**********************************************************************************************************/
CDetOperatorP::CDetOperatorP() : CDetOperator() {
  CREATEOBJECT("CDetOperatorP");
}

CDetOperatorP::~CDetOperatorP(){
  DELETEOBJECT("CDetOperatorP");
}

TRetOperator CDetOperatorP::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_p_call);
  START_TIMER(methode_operator_p_call_time);
	CHECK_POINTER("COperatorP::Call()", graph);
	CHECK_POINTER("COperatorP::Call()", stack);
  TRetOperator val = return_unchanged;

  TNodeSet* nodes = graph->GetNodes();
  TNodeSet::iterator ite;

	PRINT_DEBUG(cout << "Op P:" << endl);
  for(ite=nodes->begin();ite!=nodes->end();ite++){
    CNode* node = ite->second;

    // get supported and unblocked rules
    if(node->GetColor() != color_plus &&
       node->Supported() &&
       node->Unblocked()){

      if(!ColorNode(graph,node,color_plus,stack,false,color_none)){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }

      val = return_changed;
    } else
    // get unsupported or blocked rules
    if(node->GetColor() != color_minus && (node->Unsupported() || node->Blocked())){

      // color node if possible
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
      val = return_changed;
    }
  }
	PRINT_DEBUG(cout << "end Op P." << endl);

  STOP_TIMER(methode_operator_p_call_time);
  return val;
}


TType CDetOperatorP::GetType() {
	return (IsTodo() ? type_coperator_ptodo : type_coperator_p);
}

/**********************************************************************************************************
  CDetOperatorPs
**********************************************************************************************************/
CDetOperatorPs::CDetOperatorPs() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPs");
}


CDetOperatorPs::~CDetOperatorPs(){
  DELETEOBJECT("CDetOperatorPs");
}

TRetOperator CDetOperatorPs::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_p_call);
  START_TIMER(methode_operator_p_call_time);
	CHECK_POINTER("COperatorPtodo::Call()", graph);
	CHECK_POINTER("COperatorPtodo::Call()", stack);

  TRetOperator val = return_unchanged;

	PRINT_DEBUG(cout << "Op Pstodo:" << endl);
  PRINT_DEBUG(WriteColoring(graph));

/*	bool todo = IsTodo();

// for loop for each time
	if (todo)
		InsertTodo(graph->GetNodes());
*/
	while (!EmptyTodo()) {
		CNode *node = GetTodoHead();
		PRINT_DEBUG(cout << " handeling node " << node->GetId() << endl);

    // get unsupported or blocked rules
    TId id=node->GetId();
    if(node->GetColor() != color_minus &&
       (node->Unsupported() ||
        node->Blocked())){

      // color node if possible
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)) {
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }

			val = return_changed;
    } else

    // get supported and unblocked rules
    if(node->GetColor() != color_plus &&
       node->Supported()) {
      PRINT_DEBUG(cout << "  node is not plus and supported" << endl);
      if(node->Unblocked()){

        if(!ColorNode(graph,node,color_plus,stack,false,color_none)){
          STOP_TIMER(methode_operator_p_call_time);
          return return_colorerror;
        }

  			val = return_changed;
      } else
      if(node->GetColor() == color_none) {
        PRINT_DEBUG(cout << "  add node("<<node->GetId()<<") to choice point list" << endl);
        InsertChoicePoint(node);
      }
    }
  }
	PRINT_DEBUG(cout << "end Op Pstodo." << endl);
  STOP_TIMER(methode_operator_p_call_time);

//  InsertChoicePoints(graph->GetUncolored());

  return val;
}


TType CDetOperatorPs::GetType() {
	return (IsTodo() ? type_coperator_pstodo : type_coperator_ps);
}


/**********************************************************************************************************
  CDetOperatorPsl
**********************************************************************************************************/
CDetOperatorPsl::CDetOperatorPsl() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPsl");
}

CDetOperatorPsl::~CDetOperatorPsl(){
  DELETEOBJECT("CDetOperatorPsl");
}

TRetOperator CDetOperatorPsl::Call(CGraph* graph, TStack* stack){  INC_COUNT(methode_operator_p_call);
  START_TIMER(methode_operator_p_call_time);
	CHECK_POINTER("COperatorPl::Call()", graph);
	CHECK_POINTER("COperatorPl::Call()", stack);
  TRetOperator val = return_unchanged;
	TQueue propqueue;

  TNodeSet* nodes = graph->GetNodes();
  TNodeSet::iterator ite;

	PRINT_DEBUG(cout << "Op Pl:" << endl);
  for(ite=nodes->begin();ite!=nodes->end();ite++){
		CNode *node = ite->second;
		TId id=node->GetId();	
//		if (!node->GetStatus() && ((node->Supported() && node->Unblocked())
/*		if ((node->Supported() && node->Unblocked())
															|| node->Unsupported() || node->Blocked()) {
			node->SetStatus(true);
			if (!(node->GetColor() == color_plus) && !(node->GetColor() == color_minus))
				propqueue.push(node);
		} else
				node->SetStatus(false);  */
		if (node->Supported() && node->Unblocked()) {
			if (node->GetColor() == color_minus){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			node->SetStatus(true);
			if (!(node->GetColor() == color_plus) && !(node->GetColor() == color_minus))
				propqueue.push(node);
		}
		else if (node->Unsupported() || node->Blocked()) {
			if (node->GetColor() == color_plus){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			node->SetStatus(true);
			if (!(node->GetColor() == color_plus) && !(node->GetColor() == color_minus))
				propqueue.push(node);
		} else
				node->SetStatus(false);  
	}
		
  while (!propqueue.empty()) {
    CNode* node = propqueue.front();
		propqueue.pop();
		TId id=node->GetId();

    // get supported and unblocked rules
    if(node->GetColor() != color_plus &&
       node->Supported() &&
       node->Unblocked()){

      if(!ColorNode(graph,node,color_plus,stack,false,color_none)){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			else {    //  insert successors
				TNodeSet::iterator ite;
				TNodeSet *succs = node->GetZeroSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
				succs = node->GetOneSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
			}
      val = return_changed;
    } else
    // get unsupported or blocked rules
    if(node->GetColor() != color_minus && (node->Unsupported() || node->Blocked())){

      // color node if possible
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			else {    //  insert successors
				TNodeSet::iterator ite;
				TNodeSet *succs = node->GetZeroSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
				succs = node->GetOneSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
			}
      val = return_changed;
    }	else
		if(node->Supported() && node->GetColor() == color_none) {
	    PRINT_DEBUG(cout << "  add node("<<node->GetId()<<") to choice point list" << endl);
      InsertChoicePoint(node);
    }


	}
	PRINT_DEBUG(cout << "end Op Pl." << endl);

  STOP_TIMER(methode_operator_p_call_time);
  return val;
}


TType CDetOperatorPsl::GetType() {
	return (IsTodo() ? type_coperator_psltodo : type_coperator_psl);
}


/**********************************************************************************************************
  class CDetOperatorU
**********************************************************************************************************/
CDetOperatorU::CDetOperatorU() : CDetOperator() {
  CREATEOBJECT("CDetOperatorU");
}


CDetOperatorU::~CDetOperatorU(){
  DELETEOBJECT("CDetOperatorU");
}

TRetOperator CDetOperatorU::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_u_call);
  START_TIMER(methode_operator_u_call_time);
	CHECK_POINTER("COperatorU::Call()", graph);
	CHECK_POINTER("COperatorU::Call()", stack);

  TNodeSet::iterator ite;
  TNodeSet* nodes = graph->GetNodes();
  TNodeSet maxSuppGraph;
  TRetOperator val = return_unchanged;

  int oldsize, size;
  oldsize = -1;
  size = 0;

	PRINT_DEBUG(cout << "Op U:" << endl);
  // generate maximal support graph
  while(oldsize != size){
    oldsize = size;
    for(ite=nodes->begin();ite!=nodes->end();ite++){
      CNode* node = ite->second;

      if(node->GetColor() != color_minus && node->Supported(&maxSuppGraph))
        maxSuppGraph[node->GetId()] = node;
    }
    size = maxSuppGraph.size();
  }

  // color all uncolored not in maximal support graph
  for(ite=nodes->begin();ite!=nodes->end();ite++){
    CNode* node = ite->second;
		TId id=node->GetId();

    if(maxSuppGraph.find(node->GetId()) == maxSuppGraph.end()){
      if(node->GetColor() == color_none){

        ColorNode(graph,node,color_minus,stack,false,color_none);
        val = return_changed;
      } else
      if(node->GetColor() == color_plus){
        STOP_TIMER(methode_operator_u_call_time);
        return return_colorerror;
      }
    }
  }
	PRINT_DEBUG(cout << "end Op U." << endl);

  STOP_TIMER(methode_operator_u_call_time);
  return val;
}


TType CDetOperatorU::GetType() {
	return (IsTodo() ? type_coperator_utodo : type_coperator_u);
}

/**********************************************************************************************************
  class CDetOperatorN
**********************************************************************************************************/
CDetOperatorN::CDetOperatorN() : CDetOperator() {
  CREATEOBJECT("CDetOperatorN");
}


CDetOperatorN::~CDetOperatorN(){
  DELETEOBJECT("CDetOperatorN");
}

TRetOperator CDetOperatorN::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_n_call);
  START_TIMER(methode_operator_n_call_time);

	CHECK_POINTER("COperatorN::Call()", graph);
	CHECK_POINTER("COperatorN::Call()", stack);

//  TNodeSet *nodes = graph->GetUncolored();
	TNodeSet *nodes = graph->GetNodes();
  TRetOperator val = return_unchanged;

  PRINT_DEBUG(cout << "Op N ..."<< endl);


// what about must_be_minus ... ??????
//  while(!nodes->empty()) {
	TNodeSet::iterator ite;
	for (ite=nodes->begin();ite!=nodes->end();ite++) {
    CNode *node = ite->second;
		if (node->GetColor() == color_none) {

		 	ColorNode(graph,node,color_minus,stack,false,color_none);
  	  val = return_changed;
		}
  }
  PRINT_DEBUG(cout << "... done"<< endl);

  STOP_TIMER(methode_operator_n_call_time);

  return val;
}


TType CDetOperatorN::GetType() {
	return (IsTodo() ? type_coperator_ntodo : type_coperator_n);
}

/**********************************************************************************************************
  class CDetOperatorV
**********************************************************************************************************/
CDetOperatorV::CDetOperatorV() : CDetOperator() {
  CREATEOBJECT("CDetOperatorV");
}


CDetOperatorV::~CDetOperatorV(){
  DELETEOBJECT("CDetOperatorV");
}

TRetOperator CDetOperatorV::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_v_call);
  START_TIMER(methode_operator_v_call_time);

	CHECK_POINTER("COperatorV::Call()", graph);
	CHECK_POINTER("COperatorV::Call()", stack);

  TNodeSet *nodes = graph->GetNodes();
  TNodeSet::iterator ite;

  TNodeSet plus_colored;
  TNodeSet minus_colored;
  TNodeSet uncolored = *nodes;

  // get all plus colored rules
  // get all minus colored rules
  for(ite=nodes->begin();ite!=nodes->end();ite++){
  	CNode *node = ite->second;
   	TId id = ite->first;

    if(node->GetColor() == color_plus){
      plus_colored[id] = node;
      uncolored.erase(id);
    }
    else
    if(node->GetColor() == color_minus){
      minus_colored[id] = node;
      uncolored.erase(id);
    }
  }

  // compute the max-supp-graph V
  long old = -1;
  long changed = 0;
  TNodeSet new_set = uncolored;

  while(old != changed){
    old = changed;

    for(ite=uncolored.begin();ite!=uncolored.end();ite++){
    	CNode *node = ite->second;
     	TId id = ite->first;

//      CNode *nodefg = (CNodeFG*)ite->second;
/*			CNode *node2=ite->second;
      if((node2->GetColor() == color_none || node2->GetColor() == color_was_plus)
					&& node2->Supported(&plus_colored)){
        plus_colored[id] = node;
        new_set.erase(id);
        changed++;
      } */

      if((node->GetColor() == color_none || node->GetColor() == color_was_plus)
					&& node->Supported(&plus_colored)){
        plus_colored[id] = node;
        new_set.erase(id);
        changed++;
      }
    }
    uncolored = new_set;
  }


//why not use the set uncolored instead of double checking ??????
  // color all rules not in V(plus_colored) minus
  nodes = graph->GetNodes();
  TRetOperator val = return_unchanged;

  for(ite=nodes->begin();ite!=nodes->end();ite++){
  	CNode *node = ite->second;
    if(node->GetColor() != color_minus && plus_colored.find(node->GetId()) == plus_colored.end()){
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)){
        STOP_TIMER(methode_operator_v_call_time);
        return return_colorerror;
      }
      val = return_changed;
    }
  }

  STOP_TIMER(methode_operator_v_call_time);

  return val;
}


TType CDetOperatorV::GetType() {
	return (IsTodo() ? type_coperator_vtodo : type_coperator_v);
}

/*********************************************************************************************
  class COperatorPre
*********************************************************************************************/
CDetOperatorPre::CDetOperatorPre() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPre");
}


CDetOperatorPre::~CDetOperatorPre(){
  DELETEOBJECT("CDetOperatorPre");
}

TRetOperator CDetOperatorPre::Call(CGraph* graph, TStack* stack) {
  INC_COUNT(methode_operator_pre_call);
  START_TIMER(methode_operator_pre_call_time);

	CHECK_POINTER("COperatorPre::Call()", graph);
	CHECK_POINTER("COperatorPre::Call()", stack);

  TNodeSet *nodes = graph->GetNodes();
  TNodeSet::iterator ite;
  TRetOperator val = return_unchanged;

	PRINT_DEBUG(cout << "Preprocessing ... " << endl);
  for(ite=nodes->begin();ite!=nodes->end();ite++){
  	CNode *node = ite->second;
		// color facts with plus
		if (node->GetOnePredecessors()->empty() && node->GetZeroPredecessors()->empty()) {
			ColorNode(graph,node,color_plus,stack,false,color_none);
      val = return_changed;
    }
    else {
			TNodeSet *preds = node->GetOnePredecessors();
			TNodeSet::iterator pred = preds->find(node->GetId());
			// color self blocker with minus
	    if (pred != preds->end()) {
      	ColorNode(graph,node,color_minus,stack,false,color_none);
	      val = return_changed;
    	} else
		    if(node->Supported()){
    		  PRINT_DEBUG(cout << "  add node("<<node->GetId()<<") to choice points" << endl);
		      InsertChoicePoint(node);
    		}
    }
  }
	PRINT_DEBUG(cout << "end of Preprocessing ... " << endl);

  while(!stack->empty())
    stack->pop();

  STOP_TIMER(methode_operator_pre_call_time);
//	cout<<"!!!!!!!!!!!!!!!!!!!!"<<endl<<*graph<<endl;
  return val;
}


TType CDetOperatorPre::GetType() {
	return (IsTodo() ? type_coperator_pretodo : type_coperator_pre);
}


/*********************************************************************************************
  class CDetOperatorPrePref
*********************************************************************************************/
CDetOperatorPrePref::CDetOperatorPrePref() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPrePref");
}


CDetOperatorPrePref::~CDetOperatorPrePref(){
  DELETEOBJECT("CDetOperatorPrePref");
}

TRetOperator CDetOperatorPrePref::Call(CGraph* graph, TStack* stack) {

  INC_COUNT(methode_operator_prepref_call);
  START_TIMER(methode_operator_prepref_call_time);

	CHECK_POINTER("COperatorPrePref::Call()", graph);
	CHECK_POINTER("COperatorPrePref::Call()", stack);

  TNodeSet *nodes = graph->GetNodes();
  TNodeSet::iterator ite;
  TRetOperator val = return_unchanged;
  int size = nodes->size();
	PRINT_DEBUG(cout << "Preprocessing ... " << endl);
  for(ite=nodes->begin();ite!=nodes->end();ite++){
  	CNode *node = ite->second;
    if (node != NULL) {
		TId id = node->GetId();
		if (node->GetOnePredecessors()->empty() && node->GetZeroPredecessors()->empty()
				&& ((CNodePref*)node)->Maximal()) {
			ColorNode(graph,node,color_plus,stack,false,color_none);
      val = return_changed;
    }
    else {
			TNodeSet *preds = node->GetOnePredecessors();
			TNodeSet::iterator pred = preds->find(node->GetId());
			// color self blocker with minus
	    if (pred != preds->end()) {
      	ColorNode(graph,node,color_minus,stack,false,color_none);
	      val = return_changed;
    	} else
		    if(node->Supported()){
    		  PRINT_DEBUG(cout << "  add node("<<node->GetId()<<") to choice points" << endl);
		      InsertChoicePoint(node);
    		}
    }
    }
  }
	PRINT_DEBUG(cout << "end of Preprocessing ... " << endl);

  while(!stack->empty())
    stack->pop();

  STOP_TIMER(methode_operator_prepref_call_time);

  return val;
}


TType CDetOperatorPrePref::GetType() {
	return (IsTodo() ? type_coperator_prepreftodo : type_coperator_prepref);
}

/**********************************************************************************************************
  CDetOperatorPPref
**********************************************************************************************************/
CDetOperatorPPref::CDetOperatorPPref() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPPref");
}


CDetOperatorPPref::~CDetOperatorPPref(){
  DELETEOBJECT("CDetOperatorPPref");
}

TRetOperator CDetOperatorPPref::Call(CGraph* graph, TStack* stack){

  INC_COUNT(methode_operator_ppref_call);
  START_TIMER(methode_operator_ppref_call_time);

	CHECK_POINTER("COperatorP::Call()", graph);
	CHECK_POINTER("COperatorP::Call()", stack);

  TRetOperator val = return_unchanged;

  TNodeSet* nodes = graph->GetNodes();

  TNodeSet::iterator ite;

	PRINT_DEBUG(cout << "Op PPref:" << endl);
  for(ite=nodes->begin();ite!=nodes->end();ite++){
    CNodePref* node = (CNodePref*)ite->second;

		TColor color = node->GetColor();
    // get supported and unblocked and maximal rules
    if(color != color_plus &&
       node->Supported() &&
       node->Unblocked() &&
			 node->Maximal()){

      if(!ColorNode(graph,node,color_plus,stack,false,color_none)){
        STOP_TIMER(methode_operator_ppref_call_time);
        return return_colorerror;
      }

      val = return_changed;
    } else
    // get unsupported or (blocked and supported and maximal) rules
    if(color != color_minus && (node->Unsupported() ||
			(node->Blocked() && node->Supported() && node->Maximal()))){

	    // color node if possible
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)){
        STOP_TIMER(methode_operator_ppref_call_time);
        return return_colorerror;
      }
      val = return_changed;
    }
  }
	PRINT_DEBUG(cout << "end Op PPref." << endl);

  STOP_TIMER(methode_operator_ppref_call_time);

  return val;
}


TType CDetOperatorPPref::GetType() {
	return (IsTodo() ? type_coperator_ppreftodo : type_coperator_ppref);
} 

/**********************************************************************************************************
  CDetOperatorPsPref
**********************************************************************************************************/
CDetOperatorPsPref::CDetOperatorPsPref() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPsPref");
}


CDetOperatorPsPref::~CDetOperatorPsPref(){
  DELETEOBJECT("CDetOperatorPsPref");
}

//better, start with facts, check only successors .... !!!!!!!!!
TRetOperator CDetOperatorPsPref::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_ppref_call);
  START_TIMER(methode_operator_ppref_call_time);

	CHECK_POINTER("COperatorPPreftodo::Call()", graph);
	CHECK_POINTER("COperatorPPreftodo::Call()", stack);

  TRetOperator val = return_unchanged;

	PRINT_DEBUG(cout << "Op PsPreftodo:" << endl);

  PRINT_DEBUG(WriteColoring(graph));

	while (!EmptyTodo()) {
		CNode *node = GetTodoHead();
		TId id = node->GetId();
		PRINT_DEBUG(cout << " handeling node " << node->GetId() << endl);

    // get unsupported or blocked rules
    if(node->GetColor() != color_minus && (node->Unsupported() ||
			(node->Blocked() && node->Supported() && ((CNodePref*)node)->Maximal()))){

      // color node if possible
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)) {
        STOP_TIMER(methode_operator_ppref_call_time);
        return return_colorerror;
      }

			val = return_changed;
    } else

    // get supported and unblocked rules
    if(node->GetColor() != color_plus &&
       node->Supported() &&
       node->Unblocked() &&                 //not here!!!!!!!!!!!!!!
			 ((CNodePref*)node)->Maximal()){

	   	PRINT_DEBUG(cout << "  node is not plus and supported" << endl);
  		if(node->Unblocked()){

      	if((node->GetColor() == color_was_plus) || (!ColorNode(graph,node,color_plus,stack,false,color_none))){
//				if (!ColorNode(graph,node,color_plus,stack,false,color_none)) {
          STOP_TIMER(methode_operator_ppref_call_time);
          return return_colorerror;
        }

  			val = return_changed;
      } else
      if(node->GetColor() == color_none) {
        PRINT_DEBUG(cout << "  add node("<<node->GetId()<<") to choice point list" << endl);
        InsertChoicePoint(node);
      }
    }
  }
	PRINT_DEBUG(cout << "end Op PsPreftodo." << endl);
   STOP_TIMER(methode_operator_ppref_call_time);

//  InsertChoicePoints(graph->GetUncolored());

  return val;
}


TType CDetOperatorPsPref::GetType() {
	return (IsTodo() ? type_coperator_pspreftodo : type_coperator_pspref);
}


/**********************************************************************************************************
  CDetOperatorPslPref
**********************************************************************************************************/
CDetOperatorPslPref::CDetOperatorPslPref() : CDetOperator() {
  CREATEOBJECT("CDetOperatorPslPref");
}

CDetOperatorPslPref::~CDetOperatorPslPref(){
  DELETEOBJECT("CDetOperatorPslPref");
}

TRetOperator CDetOperatorPslPref::Call(CGraph* graph, TStack* stack){  INC_COUNT(methode_operator_p_call);
  START_TIMER(methode_operator_p_call_time);
	CHECK_POINTER("COperatorPl::Call()", graph);
	CHECK_POINTER("COperatorPl::Call()", stack);
  TRetOperator val = return_unchanged;
	TQueue propqueue;

  TNodeSet* nodes = graph->GetNodes();
  TNodeSet::iterator ite;

	PRINT_DEBUG(cout << "Op Psl:" << endl);
  for(ite=nodes->begin();ite!=nodes->end();ite++){
		CNodePref *node = (CNodePref*)ite->second;
		TId id=node->GetId();
//		if (!node->GetStatus() && ((node->Supported() && node->Unblocked())
/*		if ((node->Supported() && node->Unblocked())
															|| node->Unsupported() || node->Blocked()) {
			node->SetStatus(true);
			if (!(node->GetColor() == color_plus) && !(node->GetColor() == color_minus))
				propqueue.push(node);
		} else
				node->SetStatus(false);  */
		if (node->Supported() && node->Unblocked() && node->Maximal()) {
			if (node->GetColor() == color_minus){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			node->SetStatus(true);
			if (!(node->GetColor() == color_plus) && !(node->GetColor() == color_minus))
				propqueue.push(node);
		}
		else if ((node->Unsupported() || node->Blocked()) && node->Maximal()) {
			if (node->GetColor() == color_plus){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			node->SetStatus(true);
			if (!(node->GetColor() == color_plus) && !(node->GetColor() == color_minus))
				propqueue.push(node);
		} else
				node->SetStatus(false);
	}

  while (!propqueue.empty()) {
    CNodePref* node = (CNodePref*)propqueue.front();
		propqueue.pop();
		TId id=node->GetId();

    // get supported and unblocked rules
    if(node->GetColor() != color_plus &&
       node->Supported() &&
       node->Unblocked() &&
			 node->Maximal()){

      if(!ColorNode(graph,node,color_plus,stack,false,color_none)){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			else {    //  insert successors
				TNodeSet::iterator ite;
				TNodeSet *succs = node->GetZeroSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
				succs = node->GetOneSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
			}
      val = return_changed;
    } else
    // get unsupported or blocked rules
    if(node->GetColor() != color_minus &&
			((node->Unsupported() || node->Blocked()) && 
				node->Maximal())){

      // color node if possible
      if(!ColorNode(graph,node,color_minus,stack,false,color_none)){
        STOP_TIMER(methode_operator_p_call_time);
        return return_colorerror;
      }
			else {    //  insert successors
				TNodeSet::iterator ite;
				TNodeSet *succs = node->GetZeroSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
				succs = node->GetOneSuccessors();
				for(ite=succs->begin();ite!=succs->end();ite++){
					if (!ite->second->GetStatus()) {
							ite->second->SetStatus(true);
							propqueue.push(ite->second);
					}
				}
			}
      val = return_changed;
    }	/*else
		if(node->Supported() && node->GetColor() == color_none) {
	    PRINT_DEBUG(cout << "  add node("<<node->GetId()<<") to choice point list" << endl);
      InsertChoicePoint(node);
    }   */


	}
	PRINT_DEBUG(cout << "end Op PslPref." << endl);

  STOP_TIMER(methode_operator_p_call_time);
  return val;
}


TType CDetOperatorPslPref::GetType() {
	return (IsTodo() ? type_coperator_pslpreftodo : type_coperator_pslpref);
}


/**********************************************************************************************************
  class CDetOperatorUPref
**********************************************************************************************************/
CDetOperatorUPref::CDetOperatorUPref() : CDetOperator() {
  CREATEOBJECT("CDetOperatorUPref");
}


CDetOperatorUPref::~CDetOperatorUPref(){
  DELETEOBJECT("CDetOperatorUPref");
}

TRetOperator CDetOperatorUPref::Call(CGraph* graph, TStack* stack){
  INC_COUNT(methode_operator_upref_call);
  START_TIMER(methode_operator_upref_call_time);

	CHECK_POINTER("COperatorUPref::Call()", graph);
	CHECK_POINTER("COperatorUPref::Call()", stack);

  TNodeSet::iterator ite;
  TNodeSet* nodes = graph->GetNodes();
  TNodeSet maxSuppGraph;
  TRetOperator val = return_unchanged;

  int oldsize, size;
  oldsize = -1;
  size = 0;

	PRINT_DEBUG(cout << "Op UPref:" << endl);
  // generate maximal support graph
  while(oldsize != size){
    oldsize = size;
    for(ite=nodes->begin();ite!=nodes->end();ite++){
      CNode* node = (CNodePref*)ite->second;

      if(node->GetColor() != color_minus && node->Supported(&maxSuppGraph))
        maxSuppGraph[node->GetId()] = node;
    }
    size = maxSuppGraph.size();
  }

  // color all uncolored/must_be_minus colored nodes not in maximal support graph minus
  for(ite=nodes->begin();ite!=nodes->end();ite++){
    CNode* node = (CNodePref*)ite->second;
		// what happends if node is: color_was_plus/minus ??????????????
    if(maxSuppGraph.find(node->GetId()) == maxSuppGraph.end()){
/*      if(node->GetColor() == color_none){
        ColorNode(graph,node,color_minus,stack,false,color_none);
        val = return_changed;
      } else
			if (node->GetColor() == color_must_be_minus){
        ColorNode(graph,node,color_minus,stack,false,color_none);
        val = return_changed;
			}*/
			if ((node->GetColor() == color_none) || (node->GetColor() == color_must_be_minus)
					|| (node->GetColor() == color_was_plus)){
        ColorNode(graph,node,color_minus,stack,false,color_none);
        val = return_changed;
			} else		
      if(node->GetColor() == color_plus){
        STOP_TIMER(methode_operator_u_call_time);
        return return_colorerror;
      }
    }
  }
	PRINT_DEBUG(cout << "end Op UPref." << endl);

  STOP_TIMER(methode_operator_upref_call_time);

  return val;
}


TType CDetOperatorUPref::GetType() {
	return (IsTodo() ? type_coperator_upreftodo : type_coperator_upref);
}


}
