/***************************************************************************
                          cndoperator.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include "print.h"
#include "algorithm.h"
#include "cnode.h"
#include "cnodepref.h"
#include "crule.h"
#include "misc.h"
#include "print.h"

using namespace std;
namespace NS_NOMORE{

/**********************************************************************************************************
  class CNdOperator
**********************************************************************************************************/
CNdOperator::CNdOperator() : COperator() {
  CREATEOBJECT("CNdOperator");
}

CNdOperator::~CNdOperator(){
  DELETEOBJECT("CNdOperator");
}

bool CNdOperator::RestoreGraph(CGraph* graph, TStack* stack){
  PRINT_DEBUG(cout << "Restore ..." << endl);

  while(true){
    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return true
    if(top._ChoicePoint && top._ChoicePointColor == color_plus)
      return true;

    // else restore node
    PRINT_DEBUG(cout << "  restoring id: " << top._Node->GetId() << endl);
    graph->LoadState(top._Node,top._Data, top._Size);

    // delete top stack element
    stack->pop();
  }

  PRINT_DEBUG(cout << "end Restore" << endl);

  return true;
}                           

void CNdOperator::WriteAnswerSet(int nr, CGraph* graph, TSetOfAtomSets* sets){
	CHECK_POINTER("CNdOperator::WriteAnswerSet()", graph);

  TAtomSet* as = graph->GetAnswerSet();
  TAtomSet set;
  TAtomSet::iterator ite;
  int i = 1;

  #ifdef ASOUTPUT
  std::cout << "Answer Set " << nr << ":" << std::endl;
  #endif

  for(ite=as->begin();ite!=as->end();ite++){
    set[ite->first] = ite->second;
    #ifdef ASOUTPUT
    string name = ite->second->GetName();
//    if ((!name.find("name(",0) == 0) && (!name.find("preferred(",0) == 0)) {
    std::cout << ite->second->GetName();
    std::cout << " ";//}
    #endif
    i++;
  }

  (*sets)[nr] = set;

  #ifdef ASOUTPUT
  std::cout << std::endl;
  #endif
}


void CNdOperator::WritePrefAnswerSet(int nr, CGraph* graph, TSetOfAtomSets* sets){
	CHECK_POINTER("CNdOperator::WriteAnswerSet()", graph);

  TAtomSet* as = graph->GetAnswerSet();
  TAtomSet set;
  TAtomSet::iterator ite;
  int i = 1;

  #ifdef ASOUTPUT
  std::cout << "Preferred Answer Set " << nr << ":" << std::endl;
  #endif

  for(ite=as->begin();ite!=as->end();ite++){
    set[ite->first] = ite->second;
    #ifdef ASOUTPUT
    string name = ite->second->GetName();
    if ((!name.find("name(",0) == 0) && (!name.find("preferred(",0) == 0)) {
    std::cout << ite->second->GetName();
    std::cout << " ";}
    #endif
    i++;
  }

  (*sets)[nr] = set;

  #ifdef ASOUTPUT
  std::cout << std::endl;
  #endif
}


bool CNdOperator::RecolorChoicePoint(CGraph* graph, TStack* stack){
  TStackElement top = stack->top();

  if(top._ChoicePoint && top._ChoicePointColor == color_plus){

    graph->LoadState(top._Node,top._Data, top._Size);
    stack->pop();
		PRINT_DEBUG(cout << "Recolor Choice: " << top._Node->GetId() << endl);
    return ColorNode(graph, top._Node,color_minus,stack,true,color_minus);
  }

  return false;
}

bool CNdOperator::Call(CDetOperator* det_op, CDetOperator* end_op, CGraph* graph, int as_count, TSetOfAtomSets* sets){
	CHECK_POINTER("CNdOperator::Call()", det_op);
	CHECK_POINTER("CNdOperator::Call()", graph);

  TStack stack;
  int as_found = 0;

  while(true){
    // if an error occured while calling the deterministic operators
    if(det_op->Call(graph, &stack) == return_colorerror){
      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack))
        break; // nothing left to backtrack

      RecolorChoicePoint(graph, &stack);

    } else
    // if totally colored, an answer set is found
    if(graph->TotalColoring()){
      as_found++;
      WriteAnswerSet(as_found, graph, sets);

      // all answer sets are found
      if(as_found == as_count)
        return true;

      // try to go to last choice point for recoloring
      if(!RestoreGraph(graph, &stack))
        break;

      RecolorChoicePoint(graph, &stack);

    } else
    // else use non-deterministic operator to color graph
    {
//      cout<<endl<<endl<<"????????????????"<<*graph<<endl<<endl;
      CNode* node = ChooseNode(graph);

			if(node == NULL) {
				if(return_changed != end_op->Call(graph, &stack)) {
          PRINT_DEBUG(cout << "End-Operator does not return return_changed"<< endl);
          exit(1);
        }
//        cout << endl << "N: ";WriteAnswerSet(-1, graph, sets);
			} else {

				PRINT_DEBUG(cout << "Choice: " << node->GetId() << endl);

  	    if(!ColorNode(graph, node,color_plus,&stack,true,color_plus)){
    	    PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
      	  exit(1);
	      }
	    }
    }
  }

  // all answer sets found
  if(as_count == -1)
    return true;
  else
    return false;
}

/**********************************************************************************************************
  class CNdOperatorC
**********************************************************************************************************/
CNdOperatorC::CNdOperatorC() : CNdOperator() {
  CREATEOBJECT("CNdOperatorC");
}

CNdOperatorC::~CNdOperatorC(){
	DELETEOBJECT("CNdOperatorC");
}

CNode* CNdOperatorC::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_c_call);
  START_TIMER(methode_operator_c_call_time);

	CHECK_POINTER("COperatorC::ChooseNode()", graph);

  TNodeSet::iterator ite;
  TNodeSet* nodes = graph->GetNodes();

  for(ite = nodes->begin();ite != nodes->end();ite++) {
		CNode *node = ite->second;
    if(node->GetColor() == color_none){

      PRINT_DEBUG(cout << "Choice node " <<ite->second->GetId() << endl);
      STOP_TIMER(methode_operator_c_call_time);
      INC_COUNT(counter_choicepoints);
      return node;
    }

  }
  START_TIMER(methode_operator_c_call_time);
  return NULL;
}


/**********************************************************************************************************
  class CNdOperatorCtodo
**********************************************************************************************************/
CNdOperatorCtodo::CNdOperatorCtodo() : CNdOperatorC() {
  CREATEOBJECT("CNdOperatorCtodo");
}

CNdOperatorCtodo::~CNdOperatorCtodo(){
	DELETEOBJECT("CNdOperatorCtodo");
}

/**********************************************************************************************************
  class CNdOperatorC1
**********************************************************************************************************/
CNdOperatorC1::CNdOperatorC1() : CNdOperator() {
	CREATEOBJECT("CNdOperatorC1");
}

CNdOperatorC1::~CNdOperatorC1(){
	DELETEOBJECT("CNdOperatorC1");
}

CNode* CNdOperatorC1::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_c1_call);
  START_TIMER(methode_operator_c1_call_time);

  CHECK_POINTER("COperatorC1::ChooseNode()", graph);

//  TNodeSet* nodes = graph->GetUncolored();
	TNodeSet* nodes = graph->GetNodes();
	TNodeSet::iterator ite;
	for (ite=nodes->begin();ite!=nodes->end();ite++) {
		if (ite->second->GetColor() == color_none) {
		  STOP_TIMER(methode_operator_c1_call_time);
		  INC_COUNT(counter_choicepoints);
		  return ite->second;
		}
	}
	STOP_TIMER(methode_operator_c1_call_time);
	return NULL;

/*  STOP_TIMER(methode_operator_c1_call_time);

  if (nodes->empty())
		return NULL;
	else
		return nodes->begin()->second;*/
}


/**********************************************************************************************************
  class CNdOperatorC1todo
**********************************************************************************************************/
CNdOperatorC1todo::CNdOperatorC1todo() : CNdOperatorC1() {
	CREATEOBJECT("CNdOperatorC1todo");
}

CNdOperatorC1todo::~CNdOperatorC1todo(){
	DELETEOBJECT("CNdOperatorC1todo");
}


/**********************************************************************************************************
  class CNdOperatorD
**********************************************************************************************************/
CNdOperatorD::CNdOperatorD() : CNdOperator() {
	CREATEOBJECT("CNdOperatorD");
}

CNdOperatorD::~CNdOperatorD(){
	DELETEOBJECT("CNDOperatorD");
}

CNode* CNdOperatorD::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_d_call);
  START_TIMER(methode_operator_d_call_time);

	CHECK_POINTER("COperatorD::ChooseNode()", graph);

  TNodeSet::iterator ite;
	TNodeSet *nodes = graph->GetNodes();

  for(ite = nodes->begin();ite != nodes->end();ite++){
    CNode* node = ite->second;

    if(node->GetColor() == color_none && node->Supported()) {
      STOP_TIMER(methode_operator_d_call_time);
      INC_COUNT(counter_choicepoints);
      return node;
    }
  }

  STOP_TIMER(methode_operator_d_call_time);
  return NULL;
}


/**********************************************************************************************************
  class CNdOperatorDtodo
**********************************************************************************************************/
CNdOperatorDtodo::CNdOperatorDtodo() : CNdOperatorD() {
	CREATEOBJECT("CNdOperatorDtodo");
}

CNdOperatorDtodo::~CNdOperatorDtodo(){
	DELETEOBJECT("CNdOperatorDtodo");
}

/*  if (CNdOperator::ColorNode(graph, node, color, stack, choice_point, choice_color)) {
		TNodeSet::iterator ite;
		TNodeSet *nodes = node->GetOnePredecessors();
		for (ite=nodes->begin();ite!=nodes->end();ite++) {
			nodesg = (CNodeSG*)ite->second;
			COperator::ColorNode(graph,node,color_minus,stack,false,color_none);
		  InsertTodo(nodesg->GetZeroSuccessors());
  		InsertTodo(nodesg->GetOneSuccessors());
		}
    return true;
  } else
  	return false;
*/


/**********************************************************************************************************
  class CNdOperatorD2
**********************************************************************************************************/
CNdOperatorD2::CNdOperatorD2() : CNdOperator() {
	CREATEOBJECT("CNdOperatorD2");
}

CNdOperatorD2::~CNdOperatorD2(){
	DELETEOBJECT("CNdOperatorD2");
}

CNode* CNdOperatorD2::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_d_call);
  START_TIMER(methode_operator_d_call_time);

	CHECK_POINTER("COperatorD2::ChooseNode()", graph);

  CNode *node = GetChoicePoint();
  while(node != NULL) {
    if(node->GetColor() == color_none && node->Supported())
      break;

    node = GetChoicePoint();
  }

  STOP_TIMER(methode_operator_d_call_time);
  INC_COUNT(counter_choicepoints);
  return node;
}

bool CNdOperatorD2::RestoreGraph(CGraph* graph, TStack* stack){
  PRINT_DEBUG(cout << "D2Call::RestoreGraph ..." << endl);

  while(true){
    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return true
    if(top._ChoicePoint && top._ChoicePointColor == color_plus)
      return true;

    // else restore node
    PRINT_DEBUG(cout << "  restoring id: " << top._Node->GetId() << endl);
    graph->LoadState(top._Node,top._Data, top._Size);

    if(top._Node->Supported())
      InsertChoicePoint(top._Node);

    // delete top stack element
    stack->pop();
  }

  PRINT_DEBUG(cout << "end Restore" << endl);

  return true;
}

/**********************************************************************************************************
  class CNdOperatorD2todo
**********************************************************************************************************/
CNdOperatorD2todo::CNdOperatorD2todo() : CNdOperatorD2() {
	CREATEOBJECT("CNdOperatorD2todo");
}

CNdOperatorD2todo::~CNdOperatorD2todo(){
	DELETEOBJECT("CNdOperatorD2todo");
}





/**********************************************************************************************************
  class CNdOperatorDPref
**********************************************************************************************************/
CNdOperatorDPref::CNdOperatorDPref() : CNdOperator() {
	CREATEOBJECT("CNdOperatorDPref");
}

CNdOperatorDPref::~CNdOperatorDPref(){
	DELETEOBJECT("CNdOperatorDPref");
}

TChoiceLists CNdOperatorDPref::_choicepointstack;
//int level = 0;


bool CNdOperatorDPref::RestoreGraph(CGraph* graph, TStack* stack){
  PRINT_DEBUG(cout << "Restore ..." << endl);

  while(true){
    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return true
    if(top._ChoicePoint && ((top._ChoicePointColor == color_plus) || (top._ChoicePointColor == color_must_be_minus))) {
			if (!_choicepointstack.empty()) {
				TNodeSet *nodes = _choicepointstack.top();
				if (nodes->empty()) {
						_choicepointstack.pop();
				}

      	else return true;
			}
		}

    // else restore node
    PRINT_DEBUG(cout << "  restoring id: " << top._Node->GetId() << endl);
		TColor old = top._Node->GetColor();
    graph->LoadState(top._Node,top._Data, top._Size);
		TId id = top._Node->GetId();
		TColor color = top._Node->GetColor();
		if ((color == color_was_plus) && (old != color_minus)) {
			ColorNode(graph, top._Node,color_none,stack,false,color_none);
			stack->pop();
		}
//		InsertChoicePoint(top._Node);

    // delete top stack element
    stack->pop();
  }

  PRINT_DEBUG(cout << "end Restore" << endl);

  return true;
}


bool CNdOperatorDPref::RecolorChoicePoint(CGraph* graph, TStack* stack){
  TStackElement top = stack->top();

  if(top._ChoicePoint && ((top._ChoicePointColor == color_plus) || (top._ChoicePointColor == color_must_be_minus))) {

    graph->LoadState(top._Node,top._Data, top._Size);
		TColor color = top._Node->GetColor();
		TId id = top._Node->GetId();
		stack->pop();
		if (top._ChoicePointColor == color_plus)
			ColorNode(graph, top._Node,color_was_plus,stack,false,color_none);
		PRINT_DEBUG(cout << "Recolor Choice: " << top._Node->GetId() << endl);
		CNode *node = ChooseNode(graph);
		if (node == NULL) {
			node = ChooseMustBeMinus(graph);
//			INC_COUNT(choice_points);

			if (node == NULL) {
					return false;
			}

			else return ColorNode(graph, node,color_must_be_minus,stack,true,color_must_be_minus);
		}
		else if (node->GetColor() == color_was_plus)
				return false;
			else {
//				INC_COUNT(choice_points);
				return ColorNode(graph, node,color_plus,stack,true,color_plus);
			}
  }

  return false;
}


bool CNdOperatorDPref::Call(CDetOperator* det_op, CDetOperator* end_op, CGraph* graph, int as_count, TSetOfAtomSets* sets){
	CHECK_POINTER("CNdOperator::Call()", det_op);
	CHECK_POINTER("CNdOperator::Call()", graph);

  TStack stack;
  int as_found = 0;

  while(true){
//	cout<<*graph;
    // if an error occured while calling the deterministic operators
    if(det_op->Call(graph, &stack) == return_colorerror){
      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack))
        break; // nothing left to backtrack

      if (!RecolorChoicePoint(graph, &stack))
				break;

    } else
    // if totally colored, an answer set is found
    if(graph->TotalColoring()){
      as_found++;
      WritePrefAnswerSet(as_found, graph, sets);

      // all answer sets are found
      if(as_found == as_count)
        return true;

      // try to go to last choice point for recoloring
      if(!RestoreGraph(graph, &stack))
        break;

      if (!RecolorChoicePoint(graph, &stack))
				break;

    } else
    // else use non-deterministic operator to color graph
    {
//      cout<<endl<<endl<<"????????????????"<<*graph<<endl<<endl;
	GenerateChoicePointList(graph);
	CNode* node = ChooseNode(graph);
			if (node == NULL) {
				node = ChooseMustBeMinus(graph);
//				INC_COUNT(choice_points);

				if(node == NULL) {
					if (!_choicepointstack.empty()) {
						TNodeSet *nodes = _choicepointstack.top();
						if (nodes->empty()) {
							_choicepointstack.pop();
						}
					}
			    if(!RestoreGraph(graph, &stack))
      			 break;

			    if (!RecolorChoicePoint(graph, &stack))
						break;

//        cout << endl << "N: ";WriteAnswerSet(-1, graph, sets);
				} else {
					if (node->GetColor() != color_was_minus) {    // needed ??????
		 	  	  if(!ColorNode(graph, node,color_must_be_minus,&stack,true,color_must_be_minus)){
  		 	  	  PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
    		 	  	exit(1);
						}
					}
//					else			?????
//					INC_COUNT(choice_points);
				}

			} else {

				PRINT_DEBUG(cout << "Choice: " << node->GetId() << endl);

/* 	  	  if(!ColorNode(graph, node,color_plus,&stack,true,color_plus)){
   	  	  PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
     	  	exit(1);
				}
*/
				if (node->GetColor() != color_was_plus) {
	 	  	  if(!ColorNode(graph, node,color_plus,&stack,true,color_plus)){
  	 	  	  PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
    	 	  	exit(1);
					}
	      } else {
			     if(!RestoreGraph(graph, &stack))
      			 break;

			     if (!RecolorChoicePoint(graph, &stack))
						break;
				}

	    }
    }
  }

  // all answer sets found
  if(as_count
   == -1)
    return true;
  else
    return false;
}



void CNdOperatorDPref::GenerateChoicePointList(CGraph *graph) {
		const TNodeSet nodes=*graph->GetNodes();
		TNodeSet *choicepointlist = new TNodeSet(nodes);
		TNodeSet::iterator ite;
		for (ite=choicepointlist->begin();ite!=choicepointlist->end();ite++) {
			TId id=ite->second->GetId();
		// color_was_plus und color_was_minus include or exclude ???????????
			TColor color = ite->second->GetColor();
			if (((ite->second->GetColor() != color_none) && (ite->second->GetColor() != color_was_plus))
					 || (!((CNodePref*)ite->second)->Maximal()))
				choicepointlist->erase(ite->first);
		}
		_choicepointstack.push(choicepointlist);
}




CNode* CNdOperatorDPref::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_dpref_call);
  START_TIMER(methode_operator_dpref_call_time);

	CHECK_POINTER("COperatorDPref::ChooseNode()", graph);

	if (_choicepointstack.empty())
		return false;
	TNodeSet *nodes = _choicepointstack.top();
	TNodeSet::iterator ite;
  for(ite = nodes->begin();ite != nodes->end();ite++){
	    CNode* node = ite->second;
			TId id = node->GetId();
			if (((node->GetColor() != color_none) && (node->GetColor() != color_was_plus))
					 || ((node->GetColor() == color_was_plus) && node->Supported())) {
				nodes->erase(node->GetId());
				_choicepointstack.pop();
				_choicepointstack.push(nodes);
			}
  	  if(node->GetColor() == color_none && node->Supported() //) {
					&& ((CNodePref*)node)->Maximal()) {

				nodes->erase(node->GetId());
				_choicepointstack.pop();
				_choicepointstack.push(nodes);
				INC_COUNT(counter_choicepoints);
	    	STOP_TIMER(methode_operator_dpref_call_time);
	      return node;
		}
	}

  STOP_TIMER(methode_operator_dpref_call_time);
  return NULL;
}

CNode* CNdOperatorDPref::ChooseMustBeMinus(CGraph* graph){
  INC_COUNT(methode_operator_dpref_call);
  START_TIMER(methode_operator_dpref_call_time);

	CHECK_POINTER("COperatorDPref::ChooseMustBeMinus()", graph);

	if (_choicepointstack.empty())
		return false;
	TNodeSet *nodes = _choicepointstack.top();
	TNodeSet::iterator ite;
  for(ite = nodes->begin();ite != nodes->end();ite++){

    CNode* node = ite->second;

    if((node->GetColor() == color_none || node->GetColor() == color_was_plus) && !node->Supported()
				&& ((CNodePref*)node)->Maximal()) {
      STOP_TIMER(methode_operator_dpref_call_time);
			TId id = node->GetId();
			nodes->erase(node->GetId());
			_choicepointstack.pop();
			_choicepointstack.push(nodes);
      return node;

		} else {
			if (((node->GetColor() == color_none) || (node->GetColor() == color_was_plus)) && node->Supported()){
				nodes->erase(node->GetId());
				_choicepointstack.pop();
				_choicepointstack.push(nodes);
			}
		}

	}

  STOP_TIMER(methode_operator_dpref_call_time);
  return NULL;
}





/**********************************************************************************************************
  class CNdOperatorDHPref
**********************************************************************************************************/

CNdOperatorDHPref::CNdOperatorDHPref() : CNdOperator() {
  CREATEOBJECT("CNdOperatorDHPref");
}

CNdOperatorDHPref::~CNdOperatorDHPref(){
  DELETEOBJECT("CNdOperatorDHPref");
}

/*bool CNdOperatorDHPref::RestoreGraph(CGraph* graph, TStack* stack){
  PRINT_DEBUG(cout << "Restore ..." << endl);

  while(true){
    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return true
    if(top._ChoicePoint && top._ChoicePointColor == color_plus)
      return true;

    // else restore node
    PRINT_DEBUG(cout << "  restoring id: " << top._Node->GetId() << endl);
    graph->LoadState(top._Node,top._Data, top._Size);

    // delete top stack element
    stack->pop();
  }

  PRINT_DEBUG(cout << "end Restore" << endl);

  return true;
}*/

/*bool CNdOperatorDHPref::RecolorChoicePoint(CGraph* graph, TStack* stack){
  TStackElement top = stack->top();

  if(top._ChoicePoint && top._ChoicePointColor == color_plus){

    graph->LoadState(top._Node,top._Data, top._Size);
    stack->pop();
		PRINT_DEBUG(cout << "Recolor Choice: " << top._Node->GetId() << endl);
    return ColorNode(graph, top._Node,color_minus,stack,true,color_minus);
  }

  return false;
}*/

bool CNdOperatorDHPref::Call(CDetOperator* det_op, CDetOperator* end_op, CGraph* graph, int as_count, TSetOfAtomSets* sets){
	CHECK_POINTER("CNdOperator::Call()", det_op);
	CHECK_POINTER("CNdOperator::Call()", graph);

  TStack stack;
  int as_found = 0;

  while(true){
    // if an error occured while calling the deterministic operators
    if(det_op->Call(graph, &stack) == return_colorerror){
      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack))
        break; // nothing left to backtrack

      if (!RecolorChoicePoint(graph, &stack))
        break;

    } else
    // if totally colored, an answer set is found
    if(graph->TotalColoring()){
			if (Heightfunction(graph)) {
	      as_found++;
  	    WritePrefAnswerSet(as_found, graph, sets);

    	  // all answer sets are found
      	if(as_found == as_count)
        	return true;
       }

      // try to go to last choice point for recoloring
      if(!RestoreGraph(graph, &stack))
        break;

      if (!RecolorChoicePoint(graph, &stack))
        break;
    } else
    // else use non-deterministic operator to color graph
    {
      CNode* node = ChooseNode(graph);

			if(node == NULL) {
				if(return_changed != end_op->Call(graph, &stack)) {
          PRINT_DEBUG(cout << "End-Operator does not return return_changed"<< endl);
          exit(1);
        }
			} else {

				PRINT_DEBUG(cout << "Choice: " << node->GetId() << endl);

  	    if(!ColorNode(graph, node,color_plus,&stack,true,color_plus)){
    	    PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
      	  exit(1);
	      }
	    }
    }
  }

  // all answer sets found
  if(as_count == -1)
    return true;
  else
    return false;

}


bool CNdOperatorDHPref::Heightfunction(CGraph* graph){
	TNodeSet* nodes = graph->GetNodes();
	TNodeSet::iterator ite;
	TNodeSet* nodes_h = new TNodeSet();
  bool val = 1;

	while (val) {
		val=0;
		for (ite=nodes->begin();ite!=nodes->end();ite++) {
			CNodePref* node = (CNodePref*) ite->second;
			TId id=node->GetId();
//			string name = node->GetRule()->GetHeads()->begin()->second->GetName();
			if ((node->GetColor() == color_plus) && (node->Supported(nodes_h)) && (node->Maximal(nodes_h))) {
				if (nodes_h->find(node->GetId()) == nodes_h->end()) {
					(*nodes_h)[node->GetId()]=node;
					val=1;
				}
			}
			else if ((node->GetColor() == color_minus) && (node->Supported())
																						&& (node->Blocked(nodes_h)) && (node->Maximal(nodes_h))) {
				if (nodes_h->find(node->GetId()) == nodes_h->end()) {
					(*nodes_h)[node->GetId()]=node;
					val=1;
				}
			}
			else if ((node->GetColor() == color_minus) && (node->Unsupported()) && (node->Maximal(nodes_h))) {
				if (nodes_h->find(node->GetId()) == nodes_h->end()) {
					(*nodes_h)[node->GetId()]=node;
					val=1;
				}
			}
		}
  }
	if (nodes_h->size() == nodes->size())
		return true;

  return false;
}


CNode* CNdOperatorDHPref::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_dprefh_call);
  START_TIMER(methode_operator_dprefh_call_time);

	CHECK_POINTER("COperatorDPrefH::ChooseNode()", graph);

  TNodeSet::iterator ite;
  TNodeSet* nodes = graph->GetNodes();

  for(ite = nodes->begin();ite != nodes->end();ite++) {
		CNode *node = ite->second;
    if((node->GetColor() == color_none) && (node->Supported())){

      PRINT_DEBUG(cout << "Choice node " <<ite->second->GetId() << endl);
      STOP_TIMER(methode_operator_dprefh_call_time);

      INC_COUNT(counter_choicepoints);
      return node;
    }

  }
  START_TIMER(methode_operator_dprefh_call_time);
  return NULL;

}



/**********************************************************************************************************
  class CNdOperatorD2Pref
**********************************************************************************************************/
CNdOperatorD2Pref::CNdOperatorD2Pref() : CNdOperator() {
	CREATEOBJECT("CNdOperatorD2Pref");
}

CNdOperatorD2Pref::~CNdOperatorD2Pref(){
	DELETEOBJECT("CNdOperatorD2Pref");
}

TChoiceLists CNdOperatorD2Pref::_choicepointstack;
//int level = 0;


bool CNdOperatorD2Pref::RestoreGraph(CGraph* graph, TStack* stack){
  PRINT_DEBUG(cout << "Restore ..." << endl);

  while(true){
    // if stack is empty return false
    if(stack->empty())
      return false;

    // take top element
    TStackElement top = stack->top();

    // if it is a choice point and was previously colored with plus return true
    if(top._ChoicePoint && ((top._ChoicePointColor == color_plus) || (top._ChoicePointColor == color_must_be_minus))) {
			if (!_choicepointstack.empty()) {
				TNodeSet *nodes = _choicepointstack.top();
				if (nodes->empty()) {
						_choicepointstack.pop();
				}

      	else return true;
			}
		}

    // else restore node
    PRINT_DEBUG(cout << "  restoring id: " << top._Node->GetId() << endl);
		TColor old = top._Node->GetColor();
    graph->LoadState(top._Node,top._Data, top._Size);
		TId id = top._Node->GetId();
		TColor color = top._Node->GetColor();
		if ((color == color_was_plus) && (old != color_minus)) {
			ColorNode(graph, top._Node,color_none,stack,false,color_none);
			stack->pop();
		}
		if ((color == color_was_minus) && (old != color_plus)) {
			ColorNode(graph, top._Node,color_none,stack,false,color_none);
			stack->pop();
		}

    // delete top stack element
    stack->pop();
  }

  PRINT_DEBUG(cout << "end Restore" << endl);

  return true;
}


bool CNdOperatorD2Pref::RecolorChoicePoint(CGraph* graph, TStack* stack){
  TStackElement top = stack->top();

  if(top._ChoicePoint && ((top._ChoicePointColor == color_plus) || (top._ChoicePointColor == color_must_be_minus))) {

  	TColor color = top._Node->GetColor();
   	graph->LoadState(top._Node,top._Data, top._Size);
	//TColor color = top._Node->GetColor();
	//TId id = top._Node->GetId();
		stack->pop();
	//if (top._ChoicePointColor == color_plus)
		if (color == color_plus)
			ColorNode(graph, top._Node,color_was_plus,stack,false,color_none);
	//if (top._ChoicePointColor == color_must_be_minus)
		if (color == color_must_be_minus)
			ColorNode(graph, top._Node,color_was_minus,stack,false,color_none);
		PRINT_DEBUG(cout << "Recolor Choice: " << top._Node->GetId() << endl);
		CNode *node = ChooseNode(graph);
		if (node == NULL) return false;		// hier kein extra test, weil sonst rekursive Restore, Recolor ... aufgerufen werden muss
		else if ((node->GetColor() != color_was_plus) && node->Supported())
  		return ColorNode(graph, node,color_plus,stack,true,color_plus);
  	else if (!node->Supported() && (node->GetColor() != color_was_minus)) 
		return ColorNode(graph, node,color_must_be_minus,stack,true,color_plus);
    
//    else if (node->GetColor() != color_was_minus)               //!!!!!!!!!!!! was wenn color_was_plus und supported
//      return ColorNode(graph, node,color_must_be_minus,stack,true,color_must_be_minus);
    }
  return false;
}


bool CNdOperatorD2Pref::Call(CDetOperator* det_op, CDetOperator* end_op, CGraph* graph, int as_count, TSetOfAtomSets* sets){
	CHECK_POINTER("CNdOperator::Call()", det_op);
	CHECK_POINTER("CNdOperator::Call()", graph);

  TStack stack;
  int as_found = 0;
//  cout<<*graph;
  while(true){
//	cout<<*graph;
    // if an error occured while calling the deterministic operators
    if(det_op->Call(graph, &stack) == return_colorerror){
      // backtrack: restore graph to saved state
      if(!RestoreGraph(graph, &stack))
        break; // nothing left to backtrack

      if (!RecolorChoicePoint(graph, &stack))
				break;

    } else
    // if totally colored, an answer set is found
    if(graph->TotalColoring()){
      as_found++;
      WritePrefAnswerSet(as_found, graph, sets);

      // all answer sets are found
      if(as_found == as_count)
        return true;

      // try to go to last choice point for recoloring
      if(!RestoreGraph(graph, &stack))
        break;

      if (!RecolorChoicePoint(graph, &stack))
				break;

    } else
    // else use non-deterministic operator to color graph
    {
      GenerateChoicePointList(graph);
      CNode* node = ChooseNode(graph);

			if(node == NULL) {
				if (!_choicepointstack.empty()) {
					TNodeSet *nodes = _choicepointstack.top();
					if (nodes->empty()) {
						_choicepointstack.pop();
					}
				}
			    	if(!RestoreGraph(graph, &stack))
      			 		break;
			    	if (!RecolorChoicePoint(graph, &stack))
					break;

/*				if(return_changed != end_op->Call(graph, &stack)) {
          PRINT_DEBUG(cout << "End-Operator does not return return_changed"<< endl);
          exit(1);
        }*/
//        cout << endl << "N: ";WriteAnswerSet(-1, graph, sets);
			} else {
				PRINT_DEBUG(cout << "Choice: " << node->GetId() << endl);

        			if ((node->Supported()) && (node->GetColor() != color_was_plus)) {       
     	    				if(!ColorNode(graph, node,color_plus,&stack,true,color_plus)){
      	    					PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
        	  				exit(1);
	        			}
        			}
        			else if ((!node->Supported()) && (node->GetColor() != color_was_minus)) {       
					if(!ColorNode(graph, node,color_must_be_minus,&stack,true,color_must_be_minus)){
  		 	  			PRINT_ERROR(std::cerr << "color error during coloring choice point" << std::endl);
    		  				exit(1);
					}
	    			}
    			}
    }
  }
  // all answer sets found
  if(as_count == -1)
    return true;
  else
    return false;
}



CNode* CNdOperatorD2Pref::ChooseNode(CGraph* graph){
  INC_COUNT(methode_operator_d2pref_call);
  START_TIMER(methode_operator_d2pref_call_time);

	CHECK_POINTER("COperatorD2Pref::ChooseNode()", graph);

//	TNodeSet *nodes = graph->GetNodes();
  if (_choicepointstack.empty())
    return false;
  TNodeSet *nodes = _choicepointstack.top();
	TNodeSet::iterator ite;
  for(ite = nodes->begin();ite != nodes->end();ite++){
	    CNode* node = ite->second;
			TId id = node->GetId();
			if (((node->GetColor() == color_none) || (node->GetColor() == color_was_minus))
					 && ((CNodePref*)node)->Maximal() && node->Supported()) {
    			nodes->erase(node->GetId());
		  		_choicepointstack.pop();
			  	_choicepointstack.push(nodes);        
          STOP_TIMER(methode_operator_d2pref_call_time);
          if (node->GetColor() == color_was_minus)
            cout<<"!!  in ChooseNode C_plus, node was colored C_color_was_minus !!";
	  INC_COUNT(counter_choicepoints);
          return node;
      }
  }          
  for(ite = nodes->begin();ite != nodes->end();ite++){
	    CNode* node = ite->second;
			TId id = node->GetId();
			nodes->erase(node->GetId());      
			if (((node->GetColor() == color_none) || (node->GetColor() == color_was_plus))
					 && ((CNodePref*)node)->Maximal() && !node->Supported()) {
//  				nodes->erase(node->GetId());
	  			_choicepointstack.pop();
		  		_choicepointstack.push(nodes);
          STOP_TIMER(methode_operator_d2pref_call_time);        
          if (node->GetColor() == color_was_minus)
            cout<<"!!  in ChooseNode C_must_be_minus, node was colored C_color_was_plus !!";
	  INC_COUNT(counter_choicepoints);
          return node;
      }
  }

  STOP_TIMER(methode_operator_d2pref_call_time);
  return NULL;
}



void CNdOperatorD2Pref::GenerateChoicePointList(CGraph *graph) {
/*		const TNodeSet nodes=*graph->GetNodes();
		TNodeSet *choicepointlist = new TNodeSet(nodes);
		TNodeSet::iterator ite;
		for (ite=choicepointlist->begin();ite!=choicepointlist->end();ite++) {
			TId id=ite->second->GetId();
		// color_was_plus und color_was_minus include or exclude ???????????
			TColor color = ite->second->GetColor();
			if ((ite->second->GetColor() != color_none) // && (ite->second->GetColor() != color_was_plus))
					 || (!((CNodePref*)ite->second)->Maximal()))
				choicepointlist->erase(ite->first);
		}
		_choicepointstack.push(choicepointlist);*/

		TNodeSet *nodes = graph->GetNodes();
		TNodeSet *choicepointlist = new TNodeSet();
		TNodeSet::iterator ite;
		for (ite=nodes->begin();ite!=nodes->end();ite++) {
			TId id=ite->second->GetId();
			TColor color=ite->second->GetColor();
			if ((color == color_none) && ((CNodePref*)ite->second)->Maximal())
				(*choicepointlist)[ite->first] = ite->second;
		}
		_choicepointstack.push(choicepointlist);
}


} // end of namespace
