/***************************************************************************
                          cnode.cpp  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <cstdio>
#include "cnode.h"
#include "crule.h"
#include "misc.h"
#include "print.h"

using namespace std;

namespace NS_NOMORE {

/**********************************************************************************************************
  class CNode
**********************************************************************************************************/
CNode::CNode(CIdGenerator *ig) {
	CHECK_POINTER("CNode::CNode(CIdGenerator*, CRule*) ig", ig);

	_id = ig->GetId();
	_color = color_none;

  _pzero_predecessors = new TSetOfNodeSets;
  _pone_predecessors = new TNodeSet;
  _pzero_successors = new TNodeSet;
  _pone_successors = new TNodeSet;

  _prule = NULL;

	_blocked = 0;
	_unblocked = 0;

	_status = 0;
  CREATEOBJECT("CNode")
}


CNode::CNode(CIdGenerator *ig, CRule *rule) {
	CHECK_POINTER("CNode::CNode(CIdGenerator*, CRule*) rule", rule);
	CHECK_POINTER("CNode::CNode(CIdGenerator*, CRule*) ig", ig);

	_id = ig->GetId();
	_color = color_none;

  _pzero_predecessors = new TSetOfNodeSets;
  _pone_predecessors = new TNodeSet;
  _pzero_successors = new TNodeSet;
  _pone_successors = new TNodeSet;

  _prule = rule;

	_blocked = 0;
	_unblocked = 0;

	_status = 0;
  CREATEOBJECT("CNode")
}


CNode::CNode(TId sid) {

	_id = sid;
	_color = color_none;

  _pzero_predecessors = new TSetOfNodeSets;
  _pone_predecessors = new TNodeSet;
  _pzero_successors = new TNodeSet;
  _pone_successors = new TNodeSet;

  _prule = NULL;

	_blocked = 0;
	_unblocked = 0;

	_status = 0;
  CREATEOBJECT("CNode")
}


CNode::CNode(TId sid, CRule *rule) {
	CHECK_POINTER("CNode::CNode(TId, CRule*)", rule);

	_id = sid;
	_color = color_none;

  _pzero_predecessors = new TSetOfNodeSets;
  _pone_predecessors = new TNodeSet;
  _pzero_successors = new TNodeSet;
  _pone_successors = new TNodeSet;

  _prule = rule;

	_blocked = 0;
	_unblocked = 0;

	_status = 0;
  CREATEOBJECT("CNode")
}


CNode::~CNode() {
	TSetOfNodeSets::iterator ite;
  for (ite=_pzero_predecessors->begin();ite!=_pzero_predecessors->end();ite++) {
  	delete ite->second;
	}

	delete _pzero_successors;
	delete _pone_successors;
	delete _pzero_predecessors;
	delete _pone_predecessors;

  DELETEOBJECT("CNode")
}


bool CNode::operator==(const CNode &rhs){
  if(GetType() != rhs.GetType())
    return false;

  CNode *fg = (CNode*)&rhs;

	return (
		_id == rhs.GetId() &&
		_color == rhs.GetColor() &&
		(*_pzero_predecessors) == (*(fg->_pzero_predecessors)) &&
		(*_pone_predecessors) == (*(fg->_pone_predecessors)) &&
		_blocked == fg->_blocked &&
		_unblocked == fg->_unblocked &&
		_supported == fg->_supported &&
		_unsupported == fg->_unsupported
	);
}


bool CNode::operator!=(const CNode &rhs){
	return !(operator==(rhs));
}


// saves dynamic state of a node
char* CNode::SaveState(unsigned long& size){
  PRINT_DEBUG_MORE(cout << "Saving node " << GetId() << endl);

	TSaveState state;
  state.color = _color;

  size = sizeof(TSaveState);

  char *buffer = new char[size];

  // Byte copy
  memcpy(buffer, &state, size);

  // outside this methode buffer must be delete with "delete[] XXX;"
  return buffer;
}


bool CNode::LoadState(char *rhs, unsigned long& size) {

  PRINT_DEBUG_MORE(cout << "Loading node " << GetId() << endl);

  CHECK_POINTER("CNode::LoadState()", rhs);

  if(size != sizeof(TSaveState))
    return false;

  TSaveState state;

  // Byte copy
  memcpy(&state, rhs, sizeof(TSaveState));

	TNodeSet::iterator ite;
	// undo the effects of coloring a node plus
	if (_color == color_plus) {
		for (ite=_pzero_successors->begin();ite!=_pzero_successors->end();ite++) {
			TId id = GetRule()==NULL?0:
						(GetRule()->GetHeads()==NULL?0:GetRule()->GetHeads()->begin()->first);
			ite->second->IncSupported(id);
		}
		for (ite=_pone_successors->begin();ite!=_pone_successors->end();ite++) {
			ite->second->IncBlocked();
		}
	}
	// undo the effects of coloring a node minus
	if (_color == color_minus || _color == color_must_be_minus) {
		for (ite=_pzero_successors->begin();ite!=_pzero_successors->end();ite++) {
			TId id = GetRule()==NULL?0:
							(GetRule()->GetHeads()==NULL?0:GetRule()->GetHeads()->begin()->first);
			ite->second->IncUnsupported(id);
		}
		for (ite=_pone_successors->begin();ite!=_pone_successors->end();ite++) {
			ite->second->IncUnblocked();
		}
	}

  _color = state.color;

  // the buffer must be deleted ??
  delete[] rhs;

  return true;
}


bool CNode::InsertZeroPredecessor(CNode* node) {
	CHECK_POINTER("CNode::InsertZeroPredecessor()", node);
	// 0 for atoms which don't occur as headatoms, what if there are several/constraints ????
	TId headid = node->GetRule()==NULL?0:
							(node->GetRule()->GetHeads()==NULL?0:node->GetRule()->GetHeads()->begin()->first);
	TSetOfNodeSets::iterator ite;
	if ((ite=_pzero_predecessors->find(headid)) != _pzero_predecessors->end()) {
    // in case the same atom, appeares twice in the rule
//    TId id=node->GetId();
//    if (ite->second->find(node->GetId()) == ite->second->end()) {
      (*ite->second)[node->GetId()]=node;
	  	_unsupported[headid]++;
//    }
	}
	else {
		TNodeSet *nodes = new TNodeSet();
		(*nodes)[node->GetId()]=node;
		(*_pzero_predecessors)[headid]=nodes;
		_supported[headid]=1;
		_unsupported[headid]=1;
	}

	return true;
}


bool CNode::InsertOnePredecessor(CNode* node) {
	CHECK_POINTER("CNode::InsertOnePredecessor()", node);

	pair<TNodeSet::iterator,bool> p = _pone_predecessors->insert(valType(node->GetId(),node));
	_unblocked++;
	return p.second;
}


bool CNode::ColorNode(TColor color, TStack *stack, bool choice_point, TColor choice_color){
  INC_COUNT(methode_colornode);

  CHECK_POINTER("CNode::ColorNode()", stack);

  if (_color == color_none) {
    TStackElement elem;

    elem._Node = this;
    elem._ChoicePoint = choice_point;
    elem._ChoicePointColor = color; //choice_color;

    PRINT_DEBUG_MORE(cout << "saving node: ");

    elem._Data = SaveState(elem._Size);
    stack->push(elem);

	  _color = color;

    PRINT_DEBUG(cout << "  Coloring " << GetId() << " with " << color << endl);

		TNodeSet::iterator ite;
		if (color == color_plus) {
			for (ite=_pzero_successors->begin();ite!=_pzero_successors->end();ite++) {
				TId id = GetRule()==NULL?0:
							(GetRule()->GetHeads()==NULL?0:GetRule()->GetHeads()->begin()->first);
				ite->second->DecSupported(id);
			}
			for (ite=_pone_successors->begin();ite!=_pone_successors->end();ite++) {
				ite->second->DecBlocked();
			}
		}

		if (color == color_minus || color == color_must_be_minus) {
			for (ite=_pzero_successors->begin();ite!=_pzero_successors->end();ite++) {
				TId id = GetRule()==NULL?0:
							(GetRule()->GetHeads()==NULL?0:GetRule()->GetHeads()->begin()->first);
				ite->second->DecUnsupported(id);
			}
			for (ite=_pone_successors->begin();ite!=_pone_successors->end();ite++) {
				ite->second->DecUnblocked();
			}
		}

    return true;
  }	else
  if (_color == color)
		return true;

  PRINT_DEBUG(cout << "color error" << endl);

  return false;
}


bool CNode::Supported(TNodeSet* plus_colored){
	STARTTIMER;
  INC_COUNT(methode_supported_by_set);

	TSetOfNodeSets::iterator ite;

  if(_pzero_predecessors->empty()) {
  	STOPTIMER;
  	return true;
  }
  for(ite=_pzero_predecessors->begin();ite!=_pzero_predecessors->end();ite++) {
		TNodeSet::iterator ite2;
		for (ite2=ite->second->begin();ite2!=ite->second->end();ite2++) {
	  	CNode *node = ite2->second;
	    if(plus_colored->find(node->GetId()) != plus_colored->end()) {
				break;
			}
		}
		if (ite2 == ite->second->end())
			return false;
	}
	STOPTIMER;
	return true;
}


bool CNode::Supported(){
  INC_COUNT(methode_supported);

	TSetOfCounters::iterator ite;
	for (ite=_supported.begin();ite!=_supported.end();ite++) {
		if (ite->second > 0 )
			return false;
	}
	return true;
}


bool CNode::Unsupported(){
  INC_COUNT(methode_unsupported);

	TSetOfCounters::iterator ite;
	for (ite=_unsupported.begin();ite!=_unsupported.end();ite++) {
		if (ite->second <= 0 )
			return true;
	}
	return false;
}


bool CNode::Blocked(){
  INC_COUNT(methode_blocked);
	return (_blocked < 0);
}


bool CNode::Blocked(TNodeSet* set){
	STARTTIMER;
  INC_COUNT(methode_blocked_by_set);

	TNodeSet::iterator ite;

  if(_pone_predecessors->empty()) {
  	STOPTIMER;
  	return false;
  }
  for(ite=_pone_predecessors->begin();ite!=_pone_predecessors->end();ite++) {
  	CNode *node = ite->second;
    if((set->find(node->GetId()) != set->end()) && (node->GetColor() == color_plus)) {
				STOPTIMER;
				return true;
		}
	}
	STOPTIMER;
	return false;
}

//!!! bei unblocked schwach minus beachten

bool CNode::Unblocked(){
  INC_COUNT(methode_unblocked);
  int i=_unblocked;
	return (_unblocked <= 0);
}


bool CNode::InsertZeroSuccessor(CNode* node){
	CHECK_POINTER("CNode::InsertZeroSuccessor()", node);

  //in case the same atom appears twice in the body
//  if (_pzero_successors->find(node->GetId()) == _pzero_successors->end()) {
//    TId id = node->GetId();
  	pair<TNodeSet::iterator,bool> p = _pzero_successors->insert(valType(node->GetId(),node));
	  return p.second;
//  }
//  return true;
}


bool CNode::InsertOneSuccessor(CNode* node){
	CHECK_POINTER("CNode::InsertOneSuccessor()", node);

	pair<TNodeSet::iterator,bool> p = _pone_successors->insert(valType(node->GetId(),node));
	return p.second;
}


int CNode::HeuristicValue(){
	return 256*_pone_successors->size()+_pone_predecessors->size();
}

} // end of namespace NS_NOMORE
