/***************************************************************************
                          cnodepref.h  -  description
                             -------------------
    begin                : Wed Aug 25 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file cnodepref.h
		Declaration of class CNodePref
*/


#ifndef CNODEPREF_H
#define CNODEPREF_H

#include "misc.h"
#include "cnode.h"

/*! \namespace NS_NOMORE
		\brief Contains everything related to nomore++
*/
namespace NS_NOMORE {

/*! \class CNodePref cnodepref.h
  	\brief Defines node in a Graph.

*/
class CNodePref : public CNode {
	//! Output operator
	friend std::ostream& operator<<(std::ostream& os, CNodePref& node);

private:
	TNodeSet  *_ptwo_predecessors; //!< Contains all 2-preds
	TNodeSet  *_ptwo_successors; //!< Contains all 2-succs
//	int _applied;

public:
	//! Constructor. Initalizes Node with an id.
 	CNodePref(CIdGenerator *ig);

  //! Constructor. Initalizes Node with an id and a rule.
 	CNodePref(CIdGenerator *ig, CRule *rule);

	//! Constructor. Initalizes Node with an id.
 	CNodePref(TId sid);

  //! Constructor. Initalizes Node with an id and a rule.
 	CNodePref(TId sid, CRule *rule);

	//! Destrcutor.
	virtual ~CNodePref();

	//! Equality operator.
	virtual bool operator==(const CNode &rhs);

  //! inequality operator
	virtual bool operator!=(const CNode &rhs);

	//! Returns type of instance
	inline virtual TType GetType() const {
    return type_cnodepref;
  }

	//! Changes Color of Node after saving the state of the node.
	virtual bool ColorNode(TColor color, TStack *stack, bool choice_point, TColor choice_color);

	//! Returns 2-Preds
	inline virtual TNodeSet *GetTwoPredecessors() {
    return _ptwo_predecessors;
  }

	//! Returns 1-Succs
	inline virtual TNodeSet *GetTwoSuccessors() {
    return _ptwo_successors;
  }

	//! Inserts one 2-Pred
	virtual bool InsertTwoPredecessor(CNode*);

	//! Inserts one 2-Pred
	virtual bool InsertTwoSuccessor(CNode*);

  //! Returns true if the node is maximal
  virtual bool Maximal();

  //! Returns true if the node is maximal in the given set
  virtual bool Maximal(TNodeSet* set);
/*
	inline void SetApplied(int value) {
    _applied=value;
	}

	inline int GetApplied() {
		return _applied;
	}*/
};

} // end of namespace NS_NOMORE

#endif
