/***************************************************************************
                          coperator.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream>
#include <stdio.h>
//#include "caggregation.h"
#include "coperator.h"
#include "cdetoperator.h"
#include "cndoperator.h"
//#include "coperatorpref.h"
//#include "algorithmpref.h"
#include "cnodepref.h"
//#include "print.h"
//#include "misc.h"
//#include "algorithm.h"
//#include "io.h"

using namespace std;
namespace NS_NOMORE{

/**********************************************************************************************************
  class COperator
**********************************************************************************************************/
TQueue COperator::_todo;
TChoices COperator::_choices;
bool COperator::_istodo;
//long COperator::_reference_counter = 0;

COperator::COperator(){
  CREATEOBJECT("COperator");

//	_istodo = true;
//  _reference_counter++;
}


COperator::COperator(bool todo){
  CREATEOBJECT("COperator");

	_istodo = todo;
//  _reference_counter++;
}


COperator::~COperator(){
  DELETEOBJECT("COperator");

//  _reference_counter--;
}

bool COperator::EmptyTodo(){
	return _todo.empty();
}

CNode* COperator::GetTodoHead(){
	if(_todo.empty())
		return NULL;

	CNode* node = _todo.front();
	_todo.pop();
	return node;
}

void COperator::InsertTodo(CNode* node){
	CHECK_POINTER("COperator::InsertTodo()", node);
	_todo.push(node);
}

void COperator::InsertTodo(TNodeSet* nodeset){
	TNodeSet::iterator ite;

	for(ite=nodeset->begin();ite!=nodeset->end();ite++){
		CNode* node = ite->second;
		_todo.push(node);
	}
}

bool COperator::EmptyChoicePoints(){
	return _choices.empty();
}

CNode* COperator::GetChoicePoint(){
	if(_choices.empty())
		return NULL;

	CNode* node = _choices.top();
	_choices.pop();
	return node;
}

void COperator::InsertChoicePoint(CNode* node){
	CHECK_POINTER("COperator::InsertChoice()", node);
	_choices.push(node);
}

void COperator::InsertChoicePoints(TNodeSet* nodeset){
	TNodeSet::iterator ite;

	for(ite=nodeset->begin();ite!=nodeset->end();ite++){
		CNode* node = ite->second;
		_choices.push(node);
	}
}

bool COperator::operator==(COperator& op){
	return GetType() == op.GetType();
}

bool COperator::operator!=(COperator& op){
	return GetType() != op.GetType();
}

bool COperator::ColorNode(CGraph* graph, CNode *node, TColor color, TStack *stack,
                            bool choice_point, TColor choice_color){
  CHECK_POINTER("COperator::ColorNode()", graph);
  if(!graph->ColorNode(node, color, stack, choice_point, choice_color))
    return false;
	if (_istodo) {
		if ((color != color_none) && (color != color_was_plus) && (color != color_was_minus)) {
		  InsertTodo(node->GetZeroSuccessors());
			InsertTodo(node->GetOneSuccessors());
//		InsertTodo(((CNodePref*)node)->GetTwoSuccessors());
			if (node->GetType() == type_cnodepref)
				InsertTodo(((CNodePref*)node)->GetTwoSuccessors());
/*			CNodePref* n=dynamic_cast<CNodePref*>(node);
			if (n!=NULL)
				InsertTodo(n->GetTwoSuccessors());*/
	  }
  	return true;
	}
	return true;
}

bool COperator::Conflict(TType op){
	if (_istodo)
	  switch(op) {
  		case type_coperator_ptodo : return false;
		  case type_coperator_pstodo : return false;
  		case type_coperator_utodo : return false;
		  case type_coperator_ntodo : return false;
  		case type_coperator_vtodo : return false;
	  	case type_coperator_ctodo : return false;
	  	case type_coperator_c1todo : return false;
		  case type_coperator_dtodo : return false;
  		case type_coperator_d2todo : return false;
		  case type_coperator_pretodo : return false;
  		case type_coperator_prepreftodo : return false;
	  	case type_cdetoperator_none : return false;
	  	case type_caggregation_star : return false;
		  case type_caggregation_sequence : return false;
  		case type_coperator_dpreftodo : return false;
  		case type_coperator_d2preftodo : return false;    
		  case type_coperator_ppreftodo : return false;
  		case type_coperator_pspreftodo : return false;
  		case type_coperator_pslpreftodo : return false;
	  	case type_coperator_upreftodo : return false;
	  	case type_coperator_dprefhtodo : return false;
		  default: return true;
	  }
	else
	  switch(op) {
	  	case type_coperator_p : return false;
		 	case type_coperator_u : return false;
  		case type_coperator_v : return false;
		  case type_coperator_n : return false;
		  case type_coperator_c : return false;
		  case type_coperator_c1 : return false;
		  case type_coperator_d : return false;
		  case type_coperator_pre : return false;
  		case type_cdetoperator_none : return false;
	  	case type_caggregation_star : return false;
	  	case type_caggregation_sequence : return false;
		  default: return true;
	  }
}



}
