/***************************************************************************
                          crule.h  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file crule.h
		Contains Definitions of CAtom and CRule */

#ifndef CRULE_H
#define CRULE_H

#include <map>
#include <iostream>
#include "misc.h"
#include "print.h"

namespace NS_NOMORE{

/*! \class CAtom
		\brief Defines atoms.

    An atom consists of a string and an id.*/
class CAtom {
	//! Output operator
	friend std::ostream& operator<<(std::ostream& os, CAtom& atom);

public:
  //! Constructes the atom and set the name to empty string
  CAtom(const TId id);

  //! Constructs the atom and initialize the name
  CAtom(const TId id, const string name);

  //! Constructes the atom and set the name to empty string
  CAtom(CIdGenerator *ig);

  //! Constructs the atom and initialize the name
  CAtom(CIdGenerator *ig, const string name);

  //! Destroys the object
  ~CAtom();

  //! Equality operator on atoms (tests for equal name's)
  bool operator==(const CAtom& atom);

  //! Inequality operator on atoms (tests for equal name's)
  bool operator!=(const CAtom& atom);

  //! Sets name attribute.
  /*! \param name Sets the new name of the atom*/
  void SetName(const string& name);

	//! Returns name attribute.
  inline string GetName() const {
	  return _name;
  };

	//! Sets Id attribute.
  /*! \param id The new id*/
  void SetId(const TId id);

	//! Returns Id attribute.
  inline TId GetId() const {
 	 return _id;
  };

private:
  string _name; //!< Contains the name of the atom as found in the logic program.
  TId  _id; //!< Contains an id to uniquely identify each atom.
};

/*! \class CRule
		\brief Defines a simple rule of the form head :- a1, .. , an, not an+1, .. , not am. */
class CRule {
	//! Output operator
	friend std::ostream& operator<<(std::ostream& os, CRule& rule);
private:
  // Contains the id to an atom and its reference
  TAtomSet *_pheads;//!< set of all heads of the rule
  TAtomSet *_pnbody;//!< set of all negative body elements of the rule
  TAtomSet *_ppbody;//!< set of all positive body elements of the rule

  TId  _id;//!< id of the rule

public:
  //! constructor
  	CRule(const TId id);

  //! constructor
  	CRule(CIdGenerator *ig);

  //! destructor
  ~CRule();

  //! Equality operator on rules
  bool operator==(CRule& rule);

  //! Inequality operator on rules
  bool operator!=(CRule& rule);

  //! Inserts an atom to heads
  /*! \param atom Inserts the address of the atom to the set of heads */
  void InsertHead(CAtom* atom);

  //! Inserts an atom to negative body map
  /*! \param atom Inserts the address of the atom to the set of negative atoms */
  void InsertNegAtom(CAtom* atom);

  //! Inserts an atom to positive body map
  /*! \param atom Inserts the address of the atom to the set of positive atoms */
  void InsertPosAtom(CAtom* atom);

	//! Returns the ID of the rule
	inline TId GetId() {
		return _id;
  };

  //! Returns the set of all heads
  inline TAtomSet* GetHeads() {
		return _pheads;
  };

  //! Returns the set of all negative body elements
  inline TAtomSet* GetnBody() {
		return _pnbody;
  };

  //! Returns the set of all positive body elements
  inline TAtomSet* GetpBody() {
		return _ppbody;
  };
};

} // end of namespace NS_NOMORE

#endif
