/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri Aug 20 10:57:39 MET DST 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>

#include "algorithm.h"
#include "cgraph.h"
#include "cgraphpref.h"
#include "cprogram.h"
#include "timer.h"
#include "print.h"

using namespace std;
using namespace NS_NOMORE;

void usage ()
{
  cerr << "Usage: nomorepref [number] [-pref] [-op \"pre:nd:d:post\"]" << endl
       << "       The number determines the number of stable models computed." << endl
       << "       A zero indicates all." << endl
       << "       The op switch enables choosing of operators where " << endl
       << "       pre is the preprocessing operator out of the following:" << endl
       << "                {Pre, None}" << endl
       << "       nd is the nondeterministic operator out of the following:" << endl
       << "                {C, C1, D, D2, DH}" << endl
       << "       d is the deterministic operator out of the following:" << endl
       << "                {P, Ps, Psl, U, V, None}" << endl
       << "         or an aggeregation of the above using sequence (,) and iteration (*)" << endl
       << "       post is the postprocessing operator out of the following:" << endl
       << "                {N, None}" << endl
       << "       if obmitted, Pretodo:Dtodo:Pstodo:Ntodo is used" << endl;

}

int main(int argc, char *argv[])
{
        string operators = "Pre:D:(Ps,U)*:N";
        int as_number = 0;
        bool error = false;
        bool todo = true;
        bool prefs = false;

        for(int c=1;c<argc;c++) {
    if (argv[c][0] == '-') {
                        if(strcmp(&argv[c][1], "op") == 0) {
                                c++;
                                if(c >= argc) {
                                        error = true;
                                        break;
                                }
                                operators = string(argv[c]);
                        }
                        else if(strcmp(&argv[c][1], "pref") == 0) {

        prefs = true;
                        }
                        else if(strcmp(&argv[c][1], "notodo") == 0) {
                                todo = false;
                        }
                        else {
                                error = true;
                                break;
                        }
                }
                else
                        sscanf(argv[c], "%i", &as_number);
        }

        if(error) {
                usage();

                return 1;
        }

        Timer timer;
        timer.start();
//        cout << PACKAGE << " " << VERSION << " Reading ... ";
	cout << "Reading ... ";
        CProgram *program = new CProgram();
  if (prefs) {
    if (!program->ReadWithPrefs(cin)) {
                  cerr << "Something wrong with reading lparse output" << endl;
                delete program;
                return 1;
    }
  }
  else {
    if (!program->Read(cin)) {
                  cerr << "Something wrong with reading lparse output" << endl;
                delete program;
                return 1;
    }
        }

        cout << "done" << endl;

        CGraph *graph;

        if (prefs) {
                graph = new CGraphPref(program);
 }
        else {
                graph = new CGraph(program);
  }

        PRINT_DEBUG(cout << *graph << endl);
        if(!ColorGraph(graph, operators, as_number, todo, prefs)) {
                usage();


                delete graph;
                delete program;

                return 1;
        }

        timer.stop();
        cout << "Time: " << timer.print() << endl;

        delete graph;
        delete program;

  PRINT_ALL_COUNTER;
  PRINTTIMER;

  return EXIT_SUCCESS;
}
