/***************************************************************************
                          print.h  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file print.h
		Contains Definitions of CObjectCounter and all kinds of other debugging information */

#ifndef _PRINT_H_
#define _PRINT_H_

#include <iostream>
#include "timer.h"

using namespace std;

#define _DEBUG

#define ASOUTPUT						// output of answer sets
//#define PRINTALL          // print all information
//#define PRINTERRORS         // print errors
//#define PRINTDEBUG        // print debug information
//#define PRINTDEBUGMORE        // print more debug information
#define PRINTTESTDEBUG      // print test debug information if in tests are pointer erros
#define PRINTCALLCOUNTER    // print information of calling different methodes
//#define PRINTTIME

#ifdef PRINTALL
  #define PRINTERRORS
  #define PRINTDEBUG
  #define PRINTDEBUGMORE
  #define PRINTCALLCOUNTER
  #define PRINTTIMES
  #define PRINTTESTDEBUG
#endif

#ifdef PRINTDEBUG
  #define PRINT_DEBUG(x) x
#else
  #define PRINT_DEBUG(x)
#endif

#ifdef PRINTTESTDEBUG
  #define PRINT_TEST_DEBUG(x) x
#else
  #define PRINT_TEST_DEBUG(x)
#endif

#ifdef PRINTDEBUGMORE
  #define PRINT_DEBUG_MORE(x) x
#else
  #define PRINT_DEBUG_MORE(x)
#endif

#ifdef PRINTERRORS
  #define PRINT_ERROR(x) x
#else
  #define PRINT_ERROR(x)
#endif

#ifdef PRINTCALLCOUNTER
  extern long methode_supported;
  extern long methode_unsupported;
  extern long methode_blocked;
  extern long methode_unblocked;
	extern long methode_maximal;
	extern long methode_maximal_by_set;
  extern long methode_supported_by_set;
  extern long methode_blocked_by_set;
  extern long methode_totalcoloring;
  
  extern long counter_choicepoints;


  extern long methode_operator_p_call;
  extern long methode_operator_u_call;
  extern long methode_operator_v_call;
  extern long methode_operator_n_call;
	extern long methode_operator_c_call;
	extern long methode_operator_c1_call;
	extern long methode_operator_d_call;
	extern long methode_operator_pre_call;
	extern long methode_operator_prepref_call;
  extern long methode_operator_ppref_call;
  extern long methode_operator_upref_call;
	extern long methode_operator_dpref_call;
  extern long methode_operator_d2pref_call;
	extern long methode_operator_dprefh_call;

  extern Timer methode_operator_p_call_time;
  extern Timer methode_operator_u_call_time;
  extern Timer methode_operator_v_call_time;
  extern Timer methode_operator_n_call_time;
	extern Timer methode_operator_c_call_time;
	extern Timer methode_operator_c1_call_time;
	extern Timer methode_operator_d_call_time;
	extern Timer methode_operator_pre_call_time;
	extern Timer methode_operator_prepref_call_time;
  extern Timer methode_totalcoloring_time;
  extern Timer methode_operator_ppref_call_time;
  extern Timer methode_operator_upref_call_time;
	extern Timer methode_operator_dpref_call_time;
	extern Timer methode_operator_d2pref_call_time;  
	extern Timer methode_operator_dprefh_call_time;

  extern long methode_colornode;
  extern long methode_colornode_fg;

  #define INC_COUNT(x) x++
  #define PRINT_COUNTER1(text, x) if(x>0) cout << "Call to " << text << ": " << x << endl;
  #define PRINT_COUNTER2(text, x, t) if(x>0) cout << "Call to " << text << ": " << x << " (" << t.print()<< ")" << endl;
/*  #define PRINT_ALL_COUNTER PRINT_COUNTER1("supported       ", methode_supported);\
                            PRINT_COUNTER1("supported_by_set", methode_supported_by_set);\
                            PRINT_COUNTER1("unsupported     ", methode_unsupported);\
                            PRINT_COUNTER1("blocked         ", methode_blocked);\
                            PRINT_COUNTER1("unblocked       ", methode_unblocked);\
			    PRINT_COUNTER1("maximal         ", methode_maximal);\
                            PRINT_COUNTER2("operator_p      ", methode_operator_p_call, methode_operator_p_call_time);\
                            PRINT_COUNTER2("operator_u      ", methode_operator_u_call, methode_operator_u_call_time);\
                            PRINT_COUNTER2("operator_v      ", methode_operator_v_call, methode_operator_v_call_time);\
                            PRINT_COUNTER2("operator_n      ", methode_operator_n_call, methode_operator_n_call_time);\
                            PRINT_COUNTER2("operator_c      ", methode_operator_c_call, methode_operator_c_call_time);\
                            PRINT_COUNTER2("operator_c1     ", methode_operator_c1_call, methode_operator_c1_call_time);\
                            PRINT_COUNTER2("operator_d      ", methode_operator_d_call, methode_operator_d_call_time);\
                            PRINT_COUNTER2("operator_pre    ", methode_operator_pre_call, methode_operator_pre_call_time);\
                            PRINT_COUNTER1("colornode       ", methode_colornode);\
                            PRINT_COUNTER1("colornode_fg    ", methode_colornode_fg);\
                            PRINT_COUNTER1("total coloring  ", methode_totalcoloring);\
			    PRINT_COUNTER1("choice points    ", counter_choicepoints);*/
  #define PRINT_ALL_COUNTER  PRINT_COUNTER1("choice points    ", counter_choicepoints);			    
  #define START_TIMER(x) x.start();
  #define STOP_TIMER(x) x.stop();
#else
  #define START_TIMER(x)
  #define STOP_TIMER(x)
  #define INC_COUNT(x)
  #define PRINT_COUNTER1(text, x)
  #define PRINT_COUNTER2(text, x, t)
  #define PRINT_ALL_COUNTER
#endif

#ifdef PRINTTIME
	extern Timer _call_timer;
	#define STARTTIMER _call_timer.start()
	#define STOPTIMER _call_timer.stop()
	#define PRINTTIMER cout << "timer: " << _call_timer.print() << endl;
#else
	#define STARTTIMER
	#define STOPTIMER
	#define PRINTTIMER
#endif

#define CHECK_POINTER(text, x) if(x == NULL){\
		PRINT_ERROR(std::cerr << text << " - encountered NULL pointer" << std::endl);\
		exit(1);}

// priviously file cobjectcounter.h

#ifdef _DEBUG
  #define CREATEOBJECT(STR) _object_counter.CreateObject(STR);
  #define DELETEOBJECT(STR) _object_counter.DeleteObject(STR);
#else
  #define CREATEOBJECT(STR)
  #define DELETEOBJECT(STR)
#endif

#ifdef _DEBUG

  #include <map>
  #include <string>

  namespace NS_NOMORE{

  /*! \struct TCounter
  		\brief Counts the created and destroyed objects of one object type. */
  typedef struct{
    long Created; /*!< Counts the created instances of any type*/
    long Deleted; /*!< Counts the deleted instances of any type*/
  } TCounter;

  /*! \class CObjectCounter
  		\brief Counts the created and destroyed objects. */
  class CObjectCounter {
  	/*! Output operator */
	  friend std::ostream& operator<<(std::ostream& os, CObjectCounter& obj);
  private:
    std::map<std::string, TCounter>  _count_list; //!< structure for counting the objects

  public:
    //! destructor
  	CObjectCounter();

    //! constructor
  	~CObjectCounter();

    //! increase the <tt>Created</tt> counter for <tt>type</tt>
    void CreateObject(std::string type);

    //! increase the <tt>Deleted</tt> counter for <tt>type</tt>
    void DeleteObject(std::string type);

    //! returns the count of object which are not deleted yet of specified type
    long ObjectCount(std::string type);

    //! returns true if all objects are deleted
    bool Clear();

    //! clears the map
    void DeleteAll();
  };

  extern CObjectCounter _object_counter;

  }

#endif

#endif
