%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predicates for lists                                                    %
%                                                                         %
% Thomas Linke                                                            %
%                                                                         %
% last edit: June 2003                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
%   choose(?Element, ?Set, ?Residue)
%   is true when Set is a list, Element occurs in Set, and Residue is
%   everything in Set except Element (things stay in the same order).
%
choose(X, [X|R],     R        ).
choose(X, [A,X|R],   [A|R]    ).
choose(X, [A,B,X|R], [A,B|R]  ).
choose(X, [A,B,C,X|R], [A,B,C|R]  ).
choose(X, [A,B,C,D,X|R], [A,B,C,D|R]  ).
choose(X, [A,B,C,D,E,X|R], [A,B,C,D,E|R]  ).
choose(X, [A,B,C,D,E,F,X|R], [A,B,C,D,E,F|R]  ).
choose(X, [A,B,C,D,E,F,G,X|R], [A,B,C,D,E,F,G|R]  ).
choose(X, [A,B,C,D,E,F,G,H,X|R], [A,B,C,D,E,F,G,H|R]  ).
choose(X, [A,B,C,D,E,F,G,H,I,X|R], [A,B,C,D,E,F,G,H,I|R]  ).
choose(X, [A,B,C,D,E,F,G,H,I|L], [A,B,C,D,E,F,G,H,I|R]  ) :-
        choose(X, L, R).

