%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% graph reductions                                                        %
%                                                                         %
% Thomas Linke                                                            %
%                                                                         %
% last edit:   Jul, 2003                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% block graph transformations work on compiled block graphs               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

reduction :-
	!,     % + -
	chain_0([],Del_Bs, [],As, 0,1),
 	sort(Del_Bs,C1),
 	sort(As,    C2),

	append(C1,C2,NewC),
	compile_clauses(NewC,"tmp_new_db.pl").

%
% chain_0(+Del_Bs1,-Del_Bs,+Del_Rs1,-Del_Rs,+Arcs1,-Arcs) where
% Del_Bs = list of deleted (not compiled) clauses: nc_del_b/1
% NAs    = list of new     (not compiled) clauses: nc_rule_h/2
%
chain_0( Del_Bs1, Del_Bs, As1, As, Ni,No ) :-
	(   %              -   -   - +       +
	    reducable_body(GRs,GHs,B,Del_Bs1,As1) ->
	    (   %            +   +   +
		reduce_body( GRs,GHs,B,Del_Bs1,Del_Bs2,As1,As2),
		chain_0(Del_Bs2,Del_Bs,As2,As,N1,No)
	    );
	    (
		Del_Bs1 = Del_Bs, 
		As1     = As
	    )
	).

% B   = body
% GHs = grounding heads for B (GHs -0-> B)
% GRs = grounding rules for B (GRs -> GHs -0-> B)
%             +    +    +   
reduce_body(  GRs, GHs, B, Del_Bs1, Del_Bs2, As1, As2 ) :-
	findall(GH1, ( rule_b(R1,B),   %      (B -> R1s -> GR_HS)
	              (rule_h(R1,GH1);member(nc_rule_h(R1,GH1),As1)) ), 
		GR_HS),
	% new arcs: (GRs -> GR_HS)
	get_new(nc_rule_h,GRs,GR_HS,As1,As2),
	ord_union(Del_Bs1,[nc_del_b(B)],Del_Bs2).

%
get_new( nc_rule_h, [], _GR_HS, NAs, NAs ).
get_new( nc_rule_h, [R|GRs], GR_HS, NAs1,NAsx ) :- 
	get_nc_rule_h(R,GR_HS,NAs1,NAs2),
	get_new(nc_rule_h,GRs,GR_HS,NAs2,NAsx).

get_nc_rule_h( _R, [], NAs, NAs ).
get_nc_rule_h(  R, [H|GR_HS], NAs1, NAsx ) :- 
	new_clause(nc_rule_h,R,H,C),
	ord_union(NAs1,[C],NAs2), 
	get_nc_rule_h(R,GR_HS,NAs2,NAsx).

get_new( _CSort, [], Cl, Cl ).
get_new( CSort, [Id|Ids], Cl1, Clx ) :-
	new_clause(CSort,Id,C),
	ord_union(Cl1,[C],Cl2), 
	get_new(CSort,Ids,Cl2,Clx).

% new_clause/3
new_clause( nc_fact_body,    H, nc_fact_body(H) ).
new_clause( nc_del_b,   B, nc_del_b(B)  ).
% new_clause/4
new_clause( nc_rule_h,  R, H, nc_rule_h(R,H) ).

% reducable_body\5 comutes one reducable body 
% B   is reducable body
% GRs is list of rules grounding B
% GHs is list of heads grounded by B
%               -    -    -  +        +
reducable_body( GRs, GHs, B, Del_Bs1, As1) :- 
	id_b(B,_),                       % choose body B s.t.
	not_deleted(B,Del_Bs1),          % B has to be not deleted and
	pred_1(B,[]),                    % B has to have no 1 predecessors 
	grounding_rules_and_grounded_heads(GRs,GHs,B,As1),
	GRs = [_].                       % GRs(B) should be exactely one

not_deleted( B, Del_Bs ) :- 
	not(member(nc_del_b(B),Del_Bs)),
	not(c_del_b(B)).

%                                   -    -    +  +
grounding_rules_and_grounded_heads( GRs, GHs, B, NC_Rule_Hs ) :-
	pred_0(B,GHs),         % grounding heads for B
	findall(R1,(member(H1,GHs),l_rule_h(R1,NC_Rule_Hs,H1)),RR),
	findall(R2,(member(R2,RR), l_rule_hs(R2,NC_Rule_Hs,Hs2),
	            ord_subset(GHs,Hs2)),
		GRs).

% l_rule_h/3 and l_rule_hs/3 are local (l = local) 
% versions of rule_h/2 and rule_hs/2 respecting list 
% NC_Rule_Hs of new nc_rule_h/2 terms
l_rule_h( R, NC_Rule_Hs, H ) :- 
	c_rule_h(R,H);member(nc_rule_h(R,H),NC_Rule_Hs).

l_rule_hs( R, NC_Rule_Hs, Hs ) :- 
	findall(H1,l_rule_h(R,NC_Rule_Hs,H1),Hs1), % bagof\3 or setof\2 ????
	sort(Hs1,Hs).

% 0- and 1-predecessors for body nodes
pred_0( B, Preds_0 ) :- findall(H, (h_0_b(H,B),not(c_del_h(H))), Preds_0).
pred_1( B, Preds_1 ) :- findall(H, (h_1_b(H,B),not(c_del_h(H))),Preds_1).
