#!/usr/bin/env python
#########################################################################
#   Copyright 2011 Torsten Grote
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
##########################################################################

import sys
import os
import subprocess
import tempfile

TESTS = [
	['access', 'accessStatic.lp',   'streams/accessgen01.str',],
	['access', 'accessStatic.lp',   'streams/accessgen02.str',],
#	['access', 'accessStatic.lp',   'streams/accessgen03.str',],
#	['access', 'accessStatic.lp',   'streams/accessgen04.str',],

	['overtaking', 'overtakingStatic.lp', 'streams/otgen01.str'],
	['overtaking', 'overtakingStatic.lp', 'streams/otgen02.str'],
#	['overtaking', 'overtakingStatic.lp', 'streams/otgen03.str'],
#	['overtaking', 'overtakingStatic.lp', 'streams/otgen04.str'],

	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str1'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str2'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str3'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str1'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str2'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str3'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str1'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str2'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str3'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str1'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str2'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str3'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str1'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str2'],
	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str3'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str1'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str2'],
#	['jobscheduling', 'jobscheduleRL_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str3'],
		]

RUNSCRIPT = sys.path[0] + '/startrelaunch.sh'
CLINGO = sys.path[0] + '/relaunchclingo.py'

def main():
	tests = []
	for test in TESTS:
		tests.append(TestCase(test))

	for test in tests:
		test_string = test.name + " " + str.rsplit(test.encoding, '/')[-1] + " " +  str.rsplit(test.online, '/')[-1]

		print "Running " + test.uid + " ..."
		
		if not os.path.isfile(sys.path[0] + '/results/' + test.uid):
			runClingo(test)
			
			print "Test " + test_string + " completed sucessfully.\n"
		else:
			print "Test " + test_string + " skippped. Result already exisists.\n"


	print
	print "**********************************************"
	print "* ALL BENCHMARK RUNS SUCCESSFULLY COMPLETED! *"
	print "**********************************************"

	return 0

class TestCase:
	def __init__(self, case):
		self.name = case[0]
		self.encoding = os.path.join(self.name, case[1])
		if len(case) > 3:
			self.instance = os.path.join(self.name, case[2])
			self.online = os.path.join(self.name, case[3])
		else:
			self.instance = ''
			self.online = os.path.join(self.name, case[2])
		self.check()
		self.uid = self.name + "-" + str.rsplit(self.encoding, '/')[-1].replace('.lp','') + "-" +  str.rsplit(self.online, '/')[-1]

	def check(self):
		if not os.path.isfile(self.encoding):
			raise IOError('File not found: ' + self.encoding)
		if not os.path.isfile(self.online):
			raise IOError('File not found: ' + self.online)


def runClingo(test):
	global RUNSCRIPT
	try:
		command = [RUNSCRIPT, CLINGO+' -e '+test.encoding+' -s '+test.online]
		if test.instance:
			command[1] = command[1] + ' -i ' + test.instance
		command.append(test.uid)
		print "Running",
		print command
		subprocess.check_call(command, stdout=subprocess.STDOUT, stderr=subprocess.STDOUT)
	except OSError, err:
		print err
		sys.exit(1)


if __name__ == '__main__':
	if sys.version < '2.6':
		print 'You need at least python 2.6'
		sys.exit(1)

#	try:
	sys.exit(main())
#	except Exception, err:
#		sys.stderr.write('ERROR: %s\n' % str(err))
#		sys.exit(1)

