// $Id: atom.cpp,v 1.4 2004/08/02 18:34:41 jean Exp $

#include <cassert>
#include <iostream>
#include <interfaces/atom.h>

using namespace std;

namespace Platypus
{
	const ProgramInterfaceType* Atom::program_ = 0;
	void Atom::setProgram(const ProgramInterfaceType* p)
	{
		if(program_)
		{
			assert(program_ == p);
		}
		else
		{
			program_ = p;
			assert("[Atom] Pointer to ProgramInterface is NULL" && program_);
		}
	}
	Atom::Atom(AtomId id, const ProgramInterfaceType& prg)
		:	id_(id)
	{
		setProgram(&prg);
		// ensure the exception is raised if the id does not exist
		program_->idToName(id);
	}
	Atom::Atom(const std::string& name, const ProgramInterfaceType& prg)
		:	id_(prg.nameToId(name))
	{
		setProgram(&prg);
	}
	
	std::ostream& operator<<(std::ostream& os, const Atom& atom)
	{
		if(atom.visible())
			os << atom.name();
		return os;
	}
}
