// $Id: expander_chooser_impl.h,v 1.2 2004/11/21 15:14:33 sthiele Exp $

#ifndef PLATYPUS_EXPANDER_CHOOSER_IMPL_H
#define PLATYPUS_EXPANDER_CHOOSER_IMPL_H

#include <memory>
#include <string>
#include <sstream>
#include <interfaces/from_idl/exception.h>
#include <interfaces/from_idl/expander.h>
#include <interfaces/from_idl/chooser.h>
#include <interfaces/choice.h>
#include <interfaces/partial_model_impl.h>
#include <interfaces/strong_smodels_expander_impl.h>

#include <iostream>

namespace Platypus
{
	class Program;
	class SmodelsEnhancedProgram;
	class InjectConstraints
	{
		std::stringstream stream_;
		static std::string formatLparse(const PartialModelType& partialModel, const Program& program);
	public:
		InjectConstraints(const PartialModelType& partialModel, const ProgramType& program);
		std::stringstream& stream();
	};

	typedef ExpanderInterface<PartialModelType, ChoiceType> LocalExpanderInterfaceType;
	typedef ExpanderInterface<PartialModelType, DelegatableChoiceType> DelegatableExpanderInterfaceType;

	template<class Interface = LocalExpanderInterfaceType, class Interface2 = ChooserInterface>
	class Expander : public Interface, public Interface2
	{
	public:
		typedef typename Interface::ExpanderState ExpanderState;
		typedef typename Interface::PartialModelType PartialModelType;
		typedef typename Interface::ChoiceType ChoiceType;
	private:
		mutable PartialModelType partialModel_;

		std::auto_ptr<StrongSmodelsExpander> pimpl_;
		void updatePartialModel() const
		{
			pimpl_->update(partialModel_);
		}
		typedef std::vector< Atom > AtomVec;
		AtomVec atoms;

	public:
		Expander(const PartialModelType& partialModel, const Program& program)
			:	partialModel_(partialModel)
		{



		// create a collection of all Atoms in the program need this to create a Choice later

		for(Program::CollectionType::const_iterator it = program.atoms().begin();
			it != program.atoms().end(); ++it)
		{
		//	std::cout<<*it<<" "<<program.idToName(*it)<<std::endl;
			atoms.push_back(Atom(*it, program));

		}


			InjectConstraints injector(partialModel, program);
			std::auto_ptr<StrongSmodelsExpander> gcc_295_fix(new StrongSmodelsExpander(injector.stream()));

			pimpl_ = gcc_295_fix;
			//updatePartialModel();

		}

		// returns the current state of the Expander
		// OR'd together
		// This could be any combination of the
		// values above except those hat mutually
		// exclude each other
		// So a valid state would be HAS_UNKNOWN | HAS_CONFLICT
		ExpanderState state() const
		{
			return	(pimpl_->hasUnknown()	? Interface::HAS_UNKNOWN  : Interface::NIL) |
					(pimpl_->hasConflict()	? Interface::HAS_CONFLICT : Interface::NIL);
		}

		// shall return false whether the Expander is in shape
		// for another call to expand, true otherwise.
		bool done() const
		{
			return (state() & HAS_CONFLICT) || !(state() &  HAS_UNKNOWN);
		}

		// expands the partial model located in the implementation
		// of the Expander with the choice passed.
		void expand(const ChoiceType& choice)
		{
			pimpl_->expand(choice.atom_.name(), choice.positive_);
			//updatePartialModel();
		}

		// returns a PartialModel representation of the internal
		// partial model.
		PartialModelType partialModel() const
		{
			updatePartialModel();
			return partialModel_;
		}

		// backtracks the internal partial model to the choice indicated
		// by the argument. If no choice has been made the corresponding
		// exception shall be raised. The method shall raise
		// NoTruthValue if the atom specified has not yet been assigned
		// a truth value (that is it wasn't a choice or is yet to be one).
		void backtrackTo(const Atom& choice)
		{
			pimpl_->backtrackTo(choice.name());
			partialModel_.reset();
			//updatePartialModel();
		}
		
		// returns the next choice smodels would do
		Choice makeChoice()
		{
			if(!partialModel_.hasUnknown())
				throw NoChoiceLeft();

			// For the case smodels heuristic doesnt work
			if(pimpl_->sm_choice==""){
				Choice c(*partialModel_.unknownAtoms().begin(), true);
				return c;
			}else // create Choice that smodels heuristic prefers
			{
				for(AtomVec::const_iterator it = atoms.begin(); it != atoms.end(); ++it)
				{
					if(it->name()==pimpl_->sm_choice){
						Choice c(*it, pimpl_->ispos);
						return c;
					}
				}
				Choice c(*partialModel_.unknownAtoms().begin(), true);
				return c;

			}

		}

	};
}

#endif

