// $Id: choicestodo.h,v 1.2 2004/08/01 11:37:49 jean Exp $

#ifndef PLATYPUS_CHOICESTODO_H
#define PLATYPUS_CHOICESTODO_H

#include <interfaces/from_idl/exception.h>

namespace Platypus
{
	template<class ChoiceT, class CollectionT>
	class ChoicesToDoInterface
	{
	protected:
		ChoicesToDoInterface() {}
	public:
		virtual ~ChoicesToDoInterface() {}
		typedef ChoiceT ChoiceType;
		typedef CollectionT CollectionType;
		
		// adds a choice to the "choices todo" collection
		virtual void add(const ChoiceType& choice) = 0;
	
		// returns the collection of choices todo allowing
		// for iterating over it
		// accessor method
		virtual const CollectionType& choicesToDo() const = 0;
		
		// removes a choice from the collection
		virtual void remove(const ChoiceType& choice) = 0;
		
		// returns true whenever there are choices stored, false otherwise
		virtual bool hasChoice() const = 0;
		
		// returns the next choice to be change using the 
		// builtin policy
		// A stack for instance would allow for chronological backtracking,
		// however, one could apply other policies e.g. random choice, 
		// only choose visible atoms (those that have a meaning in the
		// original logic program, ...)
		virtual ChoiceType nextChoice() = 0;	
	};
}

#endif
