// $Id: exception.h,v 1.2 2004/08/01 11:37:49 jean Exp $

#ifndef PLATYPUS_EXCEPTION_H
#define PLATYPUS_EXCEPTION_H

#include <string>
#include <stdexcept>

namespace Platypus
{
	class PlatypusException : public std::runtime_error
	{
	public:
		PlatypusException(const std::string& reason = std::string())
			:	std::runtime_error(reason)
		{};
	};
	
	// Indicates that an atom does not exist
	// within the logic program (interface Program)
	// has been passed to a method.
	class UnknownAtom : public PlatypusException
	{
	public:
		UnknownAtom(const std::string& reason = "This atom does not exist in the logic program")
			:	PlatypusException(reason)
		{}
	};
	
	
	// Indicates indicates an invalid choice 
	// (e.g. the atom already has a truth value)
	class InvalidChoice : public PlatypusException
	{
	public:
		InvalidChoice(const std::string& reason = "The choice is invalid.")
			:	PlatypusException(reason)
		{}
	};
	
	// Indicates that no further choices are available
	class NoChoiceLeft : public PlatypusException
	{
	public:
		NoChoiceLeft(const std::string& reason = "There are no more atoms left to choose.")
			:	PlatypusException(reason)
		{}
	};
	
	// Indicates the errornous invocation of a method 
	// that implies that a choice has been made.
	class NoChoiceMade : public PlatypusException
	{
	public:
		NoChoiceMade(const std::string& reason = "No choice has been made.")
			:	PlatypusException(reason)
		{}
	};
		
	// Indicates that an atom was passed to a method that 
	// does not yet have a truth value assigned in partial
	// model.
	class NoTruthValue : public PlatypusException
	{
	public:
		NoTruthValue(const std::string& reason = "No truth value has been assigned to the atom.")
			:	PlatypusException(reason)
		{}
	};

	// Indicates that the logic program feed contains malformated lines
	class ParseError : public PlatypusException
	{
	public:
		ParseError(const std::string& reason = "The logic program contains errors.")
			:	PlatypusException(reason)
		{}
	};
};

#endif
